/*
 * Decompiled with CFR 0.152.
 */
package org.fryske_akademy.pos_tagger;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;

public class WrappedRConnection
extends RConnection {
    public static final String OUTPUT_R_VAR_NAME = "annotated";
    public static final String LOAD_ERRORS = "loaderrors";
    private File output;
    private File loadErrors;
    private final String loadScript;
    private boolean init;

    public WrappedRConnection(String loadScript) throws RserveException {
        this.loadScript = loadScript;
    }

    public boolean deleteOutput() {
        return this.output.delete();
    }

    private void init() {
        if (this.init) {
            return;
        }
        try {
            this.output = File.createTempFile(OUTPUT_R_VAR_NAME, "txt");
            this.loadErrors = File.createTempFile(LOAD_ERRORS, "log");
            this.output.deleteOnExit();
            this.loadErrors.deleteOnExit();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        try {
            this.assign(LOAD_ERRORS, this.loadErrors.getPath());
            this.eval("source(\"" + this.loadScript + "\")");
        }
        catch (REngineException e) {
            try {
                throw new IllegalStateException("Load failed, you may need to use cat \"/proc/PID of Rserve/fd/2\" to find what is wrong. " + new String(Files.readAllBytes(this.loadErrors.toPath())), e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.assign(OUTPUT_R_VAR_NAME, this.output.getPath());
        }
        catch (RserveException e) {
            throw new IllegalStateException(e);
        }
        this.init = true;
    }

    public File initOutput() throws IOException {
        this.init();
        this.output.createNewFile();
        return this.output;
    }
}

