################################################################################
#                                                                              #
# Script for tokenizing, lemmatizing, POS-tagging and dependency parsing of    #
# Frisian text via rest                                                        #
#                                                                              #
#                                                                              #
# Copyright: Fryske Akademy, Leeuwarden, The Netherlands, 10 June 2021.        #
# Contact  : edrenth@fryske-akademy.nl                                         #
#                                                                              #
################################################################################

s <- text
result <- annotated

s <- paste(s, collapse = " ")

# load model, tokenize, lemmatize, tag, annotate

checkPunct <- function(s)
{
  s <- str_replace_all(s, "(?<=[:alpha:])['](?=[:alpha:])", "’")
  return(s)
}

resultUD <- as.data.frame(udpipe(x = checkPunct(s), object = udmodel, parser="none"))
resultUD$term_id <- NULL

# write result

if  (output=="tsv") {
  write.table(resultUD, result, sep = "\t", na = "", dec = ".", quote = TRUE, qmethod = "double", row.names = FALSE, col.names = TRUE, fileEncoding = "UTF-8")
} else {
  writeLines(as_conllu(resultUD), result)
}