package org.fryskeakademy.validation.validationservice;

/*-
 * #%L
 * Validation
 * %%
 * Copyright (C) 2025 Fryske Akademy
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import jakarta.validation.constraints.Size;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import name.dmaus.schxslt.SchematronException;
import org.fa.tei.validation.ValidationHelper;
import org.xml.sax.SAXException;

import java.io.IOException;

@Path("/")
public class ValidationService {

    private static final int MAX = 10240000;

    @POST()
    @Path("corpus")
    @Consumes({MediaType.APPLICATION_XML, MediaType.TEXT_PLAIN})
    @Produces(MediaType.TEXT_PLAIN)
    public String corpus(@Size(min = 1, max = MAX) String text) {
        try {
            ValidationHelper.validateXsdSchematron(text);
            return "valid\n";
        } catch (IOException | SAXException | SchematronException e) {
            return e.getMessage()+"\n";
        }
    }

    @POST
    @Path("dictArticle")
    @Consumes({MediaType.APPLICATION_XML, MediaType.TEXT_PLAIN})
    @Produces(MediaType.TEXT_PLAIN)
    public String dictArticle(@Size(min = 1, max = MAX) String text) {
        try {
            org.fryske_akademy.validation.dicts.ValidationHelper.validateXsdSchematron(text);
            return "valid\n";
        } catch (Exception e) {
            return e.getMessage()+"\n";
        }
    }
}
