/*
 * Decompiled with CFR 0.152.
 */
package org.fryskeakademy.validation.validationservice;

import jakarta.validation.constraints.Size;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import name.dmaus.schxslt.SchematronException;
import org.fryske_akademy.validation.dicts.ValidationHelper;
import org.xml.sax.SAXException;

@Path(value="/")
public class ValidationService {
    private static final int MAX = 10240000;

    @POST
    @Path(value="corpus")
    @Consumes(value={"application/xml", "text/plain"})
    @Produces(value={"text/plain"})
    public String corpus(@Size(min=1, max=10240000) @Size(min=1, max=10240000) String text) {
        try {
            org.fa.tei.validation.ValidationHelper.validateXsdSchematron((String)text);
            return "valid\n";
        }
        catch (IOException | SchematronException | SAXException e) {
            return e.getMessage() + "\n";
        }
    }

    @POST
    @Path(value="dictArticle")
    @Consumes(value={"application/xml", "text/plain"})
    @Produces(value={"text/plain"})
    public String dictArticle(@Size(min=1, max=10240000) @Size(min=1, max=10240000) String text) {
        try {
            ValidationHelper.validateXsdSchematron((String)text);
            return "valid\n";
        }
        catch (Exception e) {
            return e.getMessage() + "\n";
        }
    }
}

