/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.mrpe;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.matrixJep.MatrixOperatorSet;
import org.lsmp.djep.matrixJep.MatrixSpecialEvaluationI;
import org.lsmp.djep.matrixJep.MatrixVariable;
import org.lsmp.djep.matrixJep.MatrixVariableI;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMFunNode;
import org.lsmp.djep.matrixJep.nodeTypes.ASTMVarNode;
import org.lsmp.djep.matrixJep.nodeTypes.MatrixNodeI;
import org.lsmp.djep.mrpe.MRpCommandList;
import org.lsmp.djep.mrpe.MRpRes;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Scaler;
import org.lsmp.djep.xjep.XOperator;
import org.nfunk.jep.ASTConstant;
import org.nfunk.jep.ASTFunNode;
import org.nfunk.jep.ASTStart;
import org.nfunk.jep.ASTVarNode;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SimpleNode;
import org.nfunk.jep.Variable;
import org.nfunk.jep.function.SpecialEvaluationI;

public final class MRpEval
implements ParserVisitor {
    private MatrixOperatorSet opSet;
    static final short CONST = 0;
    static final short VAR = 1;
    static final short ADD = 2;
    static final short SUB = 3;
    static final short MUL = 4;
    static final short DIV = 5;
    static final short MOD = 6;
    static final short POW = 7;
    static final short AND = 8;
    static final short OR = 9;
    static final short NOT = 10;
    static final short LT = 11;
    static final short LE = 12;
    static final short GT = 13;
    static final short GE = 14;
    static final short NE = 15;
    static final short EQ = 16;
    static final short LIST = 17;
    static final short DOT = 18;
    static final short CROSS = 19;
    static final short ASSIGN = 20;
    static final short VLIST = 21;
    static final short MLIST = 22;
    static final short FUN = 23;
    static final short UMINUS = 24;
    private static final short SCALER = 0;
    private static final short V2 = 2;
    private static final short V3 = 3;
    private static final short V4 = 4;
    private static final short Vn = 5;
    private static final short M22 = 6;
    private static final short M23 = 7;
    private static final short M24 = 8;
    private static final short M32 = 9;
    private static final short M33 = 10;
    private static final short M34 = 11;
    private static final short M42 = 12;
    private static final short M43 = 13;
    private static final short M44 = 14;
    private static final short Mnn = 15;
    private static final short Dtens = 16;
    private static final short SIN = 1;
    private static final short COS = 2;
    private static final short TAN = 3;
    private static final short ASIN = 4;
    private static final short ACOS = 5;
    private static final short ATAN = 6;
    private static final short SINH = 7;
    private static final short COSH = 8;
    private static final short TANH = 9;
    private static final short ASINH = 10;
    private static final short ACOSH = 11;
    private static final short ATANH = 12;
    private static final short ABS = 13;
    private static final short EXP = 14;
    private static final short LOG = 15;
    private static final short LN = 16;
    private static final short SQRT = 17;
    private static final short SEC = 18;
    private static final short COSEC = 19;
    private static final short COT = 20;
    private static final Hashtable functionHash = new Hashtable();
    private double[] constVals;
    private ScalerObj scalerRes;
    ScalerStore scalerStore;
    private V2Store v2Store;
    private V3Store v3Store;
    private V4Store v4Store;
    private VnStore vnStore;
    private M22Store m22Store;
    private M23Store m23Store;
    private M24Store m24Store;
    private M32Store m32Store;
    private M33Store m33Store;
    private M34Store m34Store;
    private M42Store m42Store;
    private M43Store m43Store;
    private M44Store m44Store;
    private MnnStore mnnStore;
    private MRpCommandList curCommandList;
    private static double LOG10 = Math.log(10.0);

    public MRpEval(MatrixJep mjep) {
        functionHash.put("sin", new Short(1));
        functionHash.put("cos", new Short(2));
        functionHash.put("tan", new Short(3));
        functionHash.put("asin", new Short(4));
        functionHash.put("acos", new Short(5));
        functionHash.put("atan", new Short(6));
        functionHash.put("sinh", new Short(7));
        functionHash.put("cosh", new Short(8));
        functionHash.put("tanh", new Short(9));
        functionHash.put("asinh", new Short(10));
        functionHash.put("acosh", new Short(11));
        functionHash.put("atanh", new Short(12));
        functionHash.put("abs", new Short(13));
        functionHash.put("exp", new Short(14));
        functionHash.put("log", new Short(15));
        functionHash.put("ln", new Short(16));
        functionHash.put("sqrt", new Short(17));
        functionHash.put("sec", new Short(18));
        functionHash.put("cosec", new Short(19));
        functionHash.put("cot", new Short(20));
        this.constVals = new double[0];
        this.scalerRes = new ScalerObj(0.0);
        this.scalerStore = new ScalerStore();
        this.v2Store = new V2Store();
        this.v3Store = new V3Store();
        this.v4Store = new V4Store();
        this.vnStore = new VnStore();
        this.m22Store = new M22Store();
        this.m23Store = new M23Store();
        this.m24Store = new M24Store();
        this.m32Store = new M32Store();
        this.m33Store = new M33Store();
        this.m34Store = new M34Store();
        this.m42Store = new M42Store();
        this.m43Store = new M43Store();
        this.m44Store = new M44Store();
        this.mnnStore = new MnnStore();
        this.opSet = (MatrixOperatorSet)mjep.getOperatorSet();
    }

    private MRpEval() {
        functionHash.put("sin", new Short(1));
        functionHash.put("cos", new Short(2));
        functionHash.put("tan", new Short(3));
        functionHash.put("asin", new Short(4));
        functionHash.put("acos", new Short(5));
        functionHash.put("atan", new Short(6));
        functionHash.put("sinh", new Short(7));
        functionHash.put("cosh", new Short(8));
        functionHash.put("tanh", new Short(9));
        functionHash.put("asinh", new Short(10));
        functionHash.put("acosh", new Short(11));
        functionHash.put("atanh", new Short(12));
        functionHash.put("abs", new Short(13));
        functionHash.put("exp", new Short(14));
        functionHash.put("log", new Short(15));
        functionHash.put("ln", new Short(16));
        functionHash.put("sqrt", new Short(17));
        functionHash.put("sec", new Short(18));
        functionHash.put("cosec", new Short(19));
        functionHash.put("cot", new Short(20));
        this.constVals = new double[0];
        this.scalerRes = new ScalerObj(0.0);
        this.scalerStore = new ScalerStore();
        this.v2Store = new V2Store();
        this.v3Store = new V3Store();
        this.v4Store = new V4Store();
        this.vnStore = new VnStore();
        this.m22Store = new M22Store();
        this.m23Store = new M23Store();
        this.m24Store = new M24Store();
        this.m32Store = new M32Store();
        this.m33Store = new M33Store();
        this.m34Store = new M34Store();
        this.m42Store = new M42Store();
        this.m43Store = new M43Store();
        this.m44Store = new M44Store();
        this.mnnStore = new MnnStore();
    }

    public final MRpCommandList compile(MatrixVariableI var, Node node) throws ParseException {
        MRpCommandList list = this.compile(node);
        ObjStore store = this.getStoreByDim(var.getDimensions());
        short vRef = (short)store.addVar(var);
        store.decStack();
        list.addCommand((short)20, MRpEval.getDimType(var.getDimensions()), vRef);
        return list;
    }

    public final MRpCommandList compile(Node node) throws ParseException {
        this.curCommandList = new MRpCommandList();
        node.jjtAccept(this, null);
        this.scalerStore.alloc();
        this.v2Store.alloc();
        this.v3Store.alloc();
        this.v4Store.alloc();
        this.vnStore.alloc();
        this.m22Store.alloc();
        this.m23Store.alloc();
        this.m24Store.alloc();
        this.m32Store.alloc();
        this.m33Store.alloc();
        this.m34Store.alloc();
        this.m42Store.alloc();
        this.m43Store.alloc();
        this.m44Store.alloc();
        this.mnnStore.alloc();
        Dimensions dims = ((MatrixNodeI)node).getDim();
        this.curCommandList.setFinalType(MRpEval.getDimType(dims));
        return this.curCommandList;
    }

    public int getVarRef(Variable var) throws ParseException {
        Dimensions dims = ((MatrixVariableI)((Object)var)).getDimensions();
        ObjStore store = this.getStoreByDim(dims);
        int ref = store.addVar((MatrixVariableI)((Object)var));
        return ref;
    }

    public int getVarRef(MatrixVariableI var) throws ParseException {
        Dimensions dims = var.getDimensions();
        ObjStore store = this.getStoreByDim(dims);
        int ref = store.addVar(var);
        return ref;
    }

    public final void setVarValue(int ref, MatrixValueI val) throws ParseException {
        ObjStore store = this.getStoreByDim(val.getDim());
        store.setVarValue(ref, val);
    }

    public final void setVarValue(int ref, double val) {
        this.scalerStore.setVarValue(ref, val);
    }

    static final Dimensions dimTypeToDimension(int dt) {
        switch (dt) {
            case 0: {
                return Dimensions.ONE;
            }
            case 2: {
                return Dimensions.TWO;
            }
            case 3: {
                return Dimensions.THREE;
            }
            case 4: {
                return Dimensions.valueOf(4);
            }
            case 6: {
                return Dimensions.valueOf(2, 2);
            }
            case 7: {
                return Dimensions.valueOf(2, 3);
            }
            case 8: {
                return Dimensions.valueOf(2, 4);
            }
            case 9: {
                return Dimensions.valueOf(3, 2);
            }
            case 10: {
                return Dimensions.valueOf(3, 3);
            }
            case 11: {
                return Dimensions.valueOf(3, 4);
            }
            case 12: {
                return Dimensions.valueOf(4, 2);
            }
            case 13: {
                return Dimensions.valueOf(4, 3);
            }
            case 14: {
                return Dimensions.valueOf(4, 4);
            }
        }
        return null;
    }

    private static final short getDimType(Dimensions dims) {
        if (dims.is0D()) {
            return 0;
        }
        if (dims.is1D()) {
            switch (dims.getFirstDim()) {
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
            }
            return 5;
        }
        if (dims.is2D()) {
            switch (dims.getFirstDim()) {
                case 2: {
                    switch (dims.getLastDim()) {
                        case 2: {
                            return 6;
                        }
                        case 3: {
                            return 7;
                        }
                        case 4: {
                            return 8;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (dims.getLastDim()) {
                        case 2: {
                            return 9;
                        }
                        case 3: {
                            return 10;
                        }
                        case 4: {
                            return 11;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (dims.getLastDim()) {
                        case 2: {
                            return 12;
                        }
                        case 3: {
                            return 13;
                        }
                        case 4: {
                            return 14;
                        }
                    }
                }
            }
            return 15;
        }
        return 16;
    }

    private final ObjStore getStoreByDim(Dimensions dims) throws ParseException {
        switch (MRpEval.getDimType(dims)) {
            case 0: {
                return this.scalerStore;
            }
            case 2: {
                return this.v2Store;
            }
            case 3: {
                return this.v3Store;
            }
            case 4: {
                return this.v4Store;
            }
            case 5: {
                return this.vnStore;
            }
            case 6: {
                return this.m22Store;
            }
            case 7: {
                return this.m23Store;
            }
            case 8: {
                return this.m24Store;
            }
            case 9: {
                return this.m32Store;
            }
            case 10: {
                return this.m33Store;
            }
            case 11: {
                return this.m34Store;
            }
            case 12: {
                return this.m42Store;
            }
            case 13: {
                return this.m43Store;
            }
            case 14: {
                return this.m44Store;
            }
            case 15: {
                return this.mnnStore;
            }
        }
        throw new ParseException("Sorry, can only handle scaler, 2, 3 and 4 dimensional vectors and matrices");
    }

    private final void incByDim(Dimensions dims) throws ParseException {
        this.getStoreByDim(dims).incStack();
    }

    private final void decByDim(Dimensions dims) throws ParseException {
        this.getStoreByDim(dims).decStack();
    }

    private final void incheapByDim(Dimensions dims) throws ParseException {
        this.getStoreByDim(dims).incHeap();
    }

    @Override
    public final Object visit(ASTStart node, Object data) throws ParseException {
        throw new ParseException("RpeEval: Start node encountered");
    }

    @Override
    public final Object visit(SimpleNode node, Object data) throws ParseException {
        throw new ParseException("RpeEval: Simple node encountered");
    }

    final void addConstant(Object obj) throws ParseException {
        if (!(obj instanceof Number)) {
            throw new ParseException("RpeEval: only constants of double type allowed");
        }
        double val = ((Number)obj).doubleValue();
        this.scalerStore.incStack();
        for (short i = 0; i < this.constVals.length; i = (short)(i + 1)) {
            if (val != this.constVals[i]) continue;
            this.curCommandList.addCommand((short)0, i);
            return;
        }
        double[] newConst = new double[this.constVals.length + 1];
        System.arraycopy(this.constVals, 0, newConst, 0, this.constVals.length);
        newConst[this.constVals.length] = val;
        this.curCommandList.addCommand((short)0, (short)this.constVals.length);
        this.constVals = newConst;
    }

    @Override
    public final Object visit(ASTConstant node, Object data) throws ParseException {
        this.addConstant(node.getValue());
        return null;
    }

    @Override
    public final Object visit(ASTVarNode node, Object data) throws ParseException {
        MatrixVariableI var = (MatrixVariableI)((Object)node.getVar());
        if (var.isConstant()) {
            this.addConstant(var.getMValue());
            return null;
        }
        Dimensions dims = var.getDimensions();
        ObjStore store = this.getStoreByDim(dims);
        short vRef = (short)store.addVar(var);
        store.incStack();
        this.curCommandList.addCommand((short)1, MRpEval.getDimType(dims), vRef);
        return null;
    }

    @Override
    public final Object visit(ASTFunNode node, Object data) throws ParseException {
        ASTMFunNode mnode = (ASTMFunNode)node;
        MatrixNodeI leftnode = null;
        MatrixNodeI rightnode = null;
        int nChild = mnode.jjtGetNumChildren();
        Dimensions dims = mnode.getDim();
        Dimensions ldims = null;
        Dimensions rdims = null;
        if (!(mnode.getPFMC() instanceof MatrixSpecialEvaluationI) && !(mnode.getPFMC() instanceof SpecialEvaluationI)) {
            node.childrenAccept(this, null);
        }
        if (nChild >= 1) {
            leftnode = (MatrixNodeI)node.jjtGetChild(0);
            ldims = leftnode.getDim();
        }
        if (nChild >= 2) {
            rightnode = (MatrixNodeI)node.jjtGetChild(1);
            rdims = rightnode.getDim();
        }
        if (mnode.isOperator()) {
            XOperator op = (XOperator)mnode.getOperator();
            if (op.isBinary() && nChild != 2) {
                throw new ParseException("RpeEval: binary operator must have two children, but it has " + nChild);
            }
            if (op.isUnary() && nChild != 1) {
                throw new ParseException("RpeEval: unary operator must have one child, but it has " + nChild);
            }
            if (op == this.opSet.getAdd()) {
                if (!dims.equals(ldims) || !dims.equals(rdims)) {
                    throw new ParseException("RpeEval: dims for add must be equal");
                }
                this.curCommandList.addCommand((short)2, MRpEval.getDimType(dims));
                this.decByDim(dims);
                this.incheapByDim(dims);
                return null;
            }
            if (op == this.opSet.getSubtract()) {
                if (!dims.equals(ldims) || !dims.equals(rdims)) {
                    throw new ParseException("RpeEval: dims for add must be equal");
                }
                this.curCommandList.addCommand((short)3, MRpEval.getDimType(dims));
                this.decByDim(dims);
                this.incheapByDim(dims);
                return null;
            }
            if (op == this.opSet.getUMinus()) {
                this.curCommandList.addCommand((short)24, MRpEval.getDimType(dims));
                this.incheapByDim(dims);
                return null;
            }
            if (op == this.opSet.getMultiply()) {
                this.decByDim(rdims);
                this.decByDim(ldims);
                this.incByDim(dims);
                this.incheapByDim(dims);
                this.curCommandList.addCommand((short)4, MRpEval.getDimType(ldims), MRpEval.getDimType(rdims));
                return null;
            }
            if (op == this.opSet.getMList()) {
                this.incByDim(dims);
                this.incheapByDim(dims);
                for (int j = 0; j < dims.numEles(); ++j) {
                    this.scalerStore.decStack();
                }
                short d = MRpEval.getDimType(dims);
                if (d == 5) {
                    this.curCommandList.addCommand((short)21, (short)dims.getFirstDim());
                } else if (d == 15) {
                    this.curCommandList.addCommand((short)22, (short)dims.getFirstDim(), (short)dims.getLastDim());
                } else {
                    this.curCommandList.addCommand((short)17, MRpEval.getDimType(dims));
                }
                return null;
            }
            if (op == this.opSet.getDot()) {
                this.scalerStore.incStack();
                this.decByDim(rdims);
                this.decByDim(ldims);
                this.curCommandList.addCommand((short)18, MRpEval.getDimType(ldims));
                return null;
            }
            if (op == this.opSet.getCross()) {
                if (ldims.equals(Dimensions.THREE) && rdims.equals(Dimensions.THREE)) {
                    this.v3Store.decStack();
                    this.v3Store.incHeap();
                    this.curCommandList.addCommand((short)19, (short)3);
                    return null;
                }
                if (ldims.equals(Dimensions.TWO) && rdims.equals(Dimensions.TWO)) {
                    this.scalerStore.incStack();
                    this.decByDim(ldims);
                    this.decByDim(rdims);
                    this.curCommandList.addCommand((short)19, (short)2);
                    return null;
                }
                throw new ParseException("Bad dimensions for cross product " + ldims + " " + rdims);
            }
            if (op == this.opSet.getAssign()) {
                rightnode.jjtAccept(this, null);
                MatrixVariableI var = (MatrixVariableI)((Object)((ASTMVarNode)node.jjtGetChild(0)).getVar());
                ObjStore store = this.getStoreByDim(dims);
                short vRef = (short)store.addVar(var);
                store.decStack();
                this.curCommandList.addCommand((short)20, MRpEval.getDimType(dims), vRef);
                return null;
            }
            if (op == this.opSet.getEQ()) {
                if (!ldims.equals(rdims)) {
                    throw new ParseException("Dimensions of operands for equals operator must be the same");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)16, MRpEval.getDimType(ldims));
                return null;
            }
            if (op == this.opSet.getNE()) {
                if (!ldims.equals(rdims)) {
                    throw new ParseException("Dimensions of operands for not-equals operator must be the same");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)15, MRpEval.getDimType(ldims));
                return null;
            }
            if (op == this.opSet.getLT()) {
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for < operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)11, (short)0);
                return null;
            }
            if (op == this.opSet.getGT()) {
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for > operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)13, (short)0);
                return null;
            }
            if (op == this.opSet.getLE()) {
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for <= operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)12, (short)0);
                return null;
            }
            if (op == this.opSet.getGE()) {
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for >= operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)14, (short)0);
                return null;
            }
            if (op == this.opSet.getAnd()) {
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for && operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)8, (short)0);
                return null;
            }
            if (op == this.opSet.getOr()) {
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for || operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)9, (short)0);
                return null;
            }
            if (op == this.opSet.getNot()) {
                if (!ldims.is0D()) {
                    throw new ParseException("Dimension of operand for not operator must be one");
                }
                this.scalerStore.incStack();
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)10, (short)0);
                return null;
            }
            if (op == this.opSet.getDivide()) {
                if (!rdims.is0D()) {
                    throw new ParseException("RHS operands of / operator must be a Scaler");
                }
                this.decByDim(rdims);
                this.decByDim(ldims);
                this.incByDim(dims);
                this.incheapByDim(dims);
                this.curCommandList.addCommand((short)5, MRpEval.getDimType(ldims), MRpEval.getDimType(rdims));
                return null;
            }
            if (op == this.opSet.getMod()) {
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for || operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)6, (short)0);
                return null;
            }
            if (op == this.opSet.getPower()) {
                if (!ldims.is0D() || !rdims.is0D()) {
                    throw new ParseException("Dimensions of operands for || operator must both be one");
                }
                this.scalerStore.incStack();
                this.decByDim(ldims);
                this.decByDim(rdims);
                this.curCommandList.addCommand((short)7, (short)0);
                return null;
            }
            throw new ParseException("RpeEval: Sorry unsupported operator/function: " + mnode.getName());
        }
        Short val = (Short)functionHash.get(mnode.getName());
        if (val == null) {
            throw new ParseException("RpeEval: Sorry unsupported operator/function: " + mnode.getName());
        }
        if (mnode.getPFMC().getNumberOfParameters() == 1 && nChild == 1) {
            this.scalerStore.incStack();
            this.decByDim(ldims);
            this.curCommandList.addCommand((short)23, val);
            return null;
        }
        throw new ParseException("RpeEval: Sorry unsupported operator/function: " + mnode.getName());
    }

    public final MRpRes evaluate(MRpCommandList comList) {
        this.scalerStore.reset();
        this.v2Store.reset();
        this.v3Store.reset();
        this.v4Store.reset();
        this.vnStore.reset();
        this.m22Store.reset();
        this.m23Store.reset();
        this.m24Store.reset();
        this.m32Store.reset();
        this.m33Store.reset();
        this.m34Store.reset();
        this.m42Store.reset();
        this.m43Store.reset();
        this.m44Store.reset();
        this.mnnStore.reset();
        int num = comList.getNumCommands();
        block350: for (int commandNum = 0; commandNum < num; commandNum = (int)((short)(commandNum + 1))) {
            MRpCommandList.MRpCommand command = comList.commands[commandNum];
            short aux1 = command.aux1;
            short aux2 = command.aux2;
            block0 : switch (command.command) {
                case 0: {
                    this.scalerStore.stack[this.scalerStore.sp++] = this.constVals[aux1];
                    continue block350;
                }
                case 1: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.stack[this.scalerStore.sp++] = this.scalerStore.vars[aux2];
                            break;
                        }
                        case 2: {
                            this.v2Store.stack[this.v2Store.sp++] = this.v2Store.vars[aux2];
                            break;
                        }
                        case 3: {
                            this.v3Store.stack[this.v3Store.sp++] = this.v3Store.vars[aux2];
                            break;
                        }
                        case 4: {
                            this.v4Store.stack[this.v4Store.sp++] = this.v4Store.vars[aux2];
                            break;
                        }
                        case 5: {
                            this.vnStore.stack[this.vnStore.sp++] = this.vnStore.vars[aux2];
                            break;
                        }
                        case 6: {
                            this.m22Store.stack[this.m22Store.sp++] = this.m22Store.vars[aux2];
                            break;
                        }
                        case 7: {
                            this.m23Store.stack[this.m23Store.sp++] = this.m23Store.vars[aux2];
                            break;
                        }
                        case 8: {
                            this.m24Store.stack[this.m24Store.sp++] = this.m24Store.vars[aux2];
                            break;
                        }
                        case 9: {
                            this.m32Store.stack[this.m32Store.sp++] = this.m32Store.vars[aux2];
                            break;
                        }
                        case 10: {
                            this.m33Store.stack[this.m33Store.sp++] = this.m33Store.vars[aux2];
                            break;
                        }
                        case 11: {
                            this.m34Store.stack[this.m34Store.sp++] = this.m34Store.vars[aux2];
                            break;
                        }
                        case 12: {
                            this.m42Store.stack[this.m42Store.sp++] = this.m42Store.vars[aux2];
                            break;
                        }
                        case 13: {
                            this.m43Store.stack[this.m43Store.sp++] = this.m43Store.vars[aux2];
                            break;
                        }
                        case 14: {
                            this.m44Store.stack[this.m44Store.sp++] = this.m44Store.vars[aux2];
                            break;
                        }
                        case 15: {
                            this.mnnStore.stack[this.mnnStore.sp++] = this.mnnStore.vars[aux2];
                        }
                    }
                    continue block350;
                }
                case 2: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.add();
                            break;
                        }
                        case 2: {
                            this.v2Store.add();
                            break;
                        }
                        case 3: {
                            this.v3Store.add();
                            break;
                        }
                        case 4: {
                            this.v4Store.add();
                            break;
                        }
                        case 5: {
                            this.vnStore.add();
                            break;
                        }
                        case 6: {
                            this.m22Store.add();
                            break;
                        }
                        case 7: {
                            this.m23Store.add();
                            break;
                        }
                        case 8: {
                            this.m24Store.add();
                            break;
                        }
                        case 9: {
                            this.m32Store.add();
                            break;
                        }
                        case 10: {
                            this.m33Store.add();
                            break;
                        }
                        case 11: {
                            this.m34Store.add();
                            break;
                        }
                        case 12: {
                            this.m42Store.add();
                            break;
                        }
                        case 13: {
                            this.m43Store.add();
                            break;
                        }
                        case 14: {
                            this.m44Store.add();
                            break;
                        }
                        case 15: {
                            this.mnnStore.add();
                        }
                    }
                    continue block350;
                }
                case 3: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.sub();
                            break;
                        }
                        case 2: {
                            this.v2Store.sub();
                            break;
                        }
                        case 3: {
                            this.v3Store.sub();
                            break;
                        }
                        case 4: {
                            this.v4Store.sub();
                            break;
                        }
                        case 5: {
                            this.vnStore.sub();
                            break;
                        }
                        case 6: {
                            this.m22Store.sub();
                            break;
                        }
                        case 7: {
                            this.m23Store.sub();
                            break;
                        }
                        case 8: {
                            this.m24Store.sub();
                            break;
                        }
                        case 9: {
                            this.m32Store.sub();
                            break;
                        }
                        case 10: {
                            this.m33Store.sub();
                            break;
                        }
                        case 11: {
                            this.m34Store.sub();
                            break;
                        }
                        case 12: {
                            this.m42Store.sub();
                            break;
                        }
                        case 13: {
                            this.m43Store.sub();
                            break;
                        }
                        case 14: {
                            this.m44Store.sub();
                            break;
                        }
                        case 15: {
                            this.mnnStore.sub();
                        }
                    }
                    continue block350;
                }
                case 4: {
                    block78 : switch (aux1) {
                        case 0: {
                            switch (aux2) {
                                case 0: {
                                    this.scalerStore.mulS();
                                    break;
                                }
                                case 2: {
                                    this.v2Store.mulS();
                                    break;
                                }
                                case 3: {
                                    this.v3Store.mulS();
                                    break;
                                }
                                case 4: {
                                    this.v4Store.mulS();
                                    break;
                                }
                                case 5: {
                                    this.vnStore.mulS();
                                    break;
                                }
                                case 6: {
                                    this.m22Store.mulS();
                                    break;
                                }
                                case 7: {
                                    this.m23Store.mulS();
                                    break;
                                }
                                case 8: {
                                    this.m24Store.mulS();
                                    break;
                                }
                                case 9: {
                                    this.m32Store.mulS();
                                    break;
                                }
                                case 10: {
                                    this.m33Store.mulS();
                                    break;
                                }
                                case 11: {
                                    this.m34Store.mulS();
                                    break;
                                }
                                case 12: {
                                    this.m42Store.mulS();
                                    break;
                                }
                                case 13: {
                                    this.m43Store.mulS();
                                    break;
                                }
                                case 14: {
                                    this.m44Store.mulS();
                                    break;
                                }
                                case 15: {
                                    this.mnnStore.mulS();
                                }
                            }
                            break;
                        }
                        case 2: {
                            switch (aux2) {
                                case 0: {
                                    this.v2Store.mulS();
                                    break;
                                }
                                case 2: {
                                    this.v2Store.mulV2();
                                    break;
                                }
                                case 6: {
                                    this.mulV2M22();
                                    break;
                                }
                                case 7: {
                                    this.mulV2M23();
                                    break;
                                }
                                case 8: {
                                    this.mulV2M24();
                                    break;
                                }
                                case 15: {
                                    this.mulVnMnn(this.v2Store.stack[--this.v2Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (aux2) {
                                case 0: {
                                    this.v3Store.mulS();
                                    break;
                                }
                                case 9: {
                                    this.mulV3M32();
                                    break;
                                }
                                case 10: {
                                    this.mulV3M33();
                                    break;
                                }
                                case 11: {
                                    this.mulV3M34();
                                    break;
                                }
                                case 15: {
                                    this.mulVnMnn(this.v3Store.stack[--this.v3Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 4: {
                            switch (aux2) {
                                case 0: {
                                    this.v4Store.mulS();
                                    break;
                                }
                                case 12: {
                                    this.mulV4M42();
                                    break;
                                }
                                case 13: {
                                    this.mulV4M43();
                                    break;
                                }
                                case 14: {
                                    this.mulV4M44();
                                    break;
                                }
                                case 15: {
                                    this.mulVnMnn(this.v4Store.stack[--this.v4Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 5: {
                            switch (aux2) {
                                case 0: {
                                    this.mnnStore.mulS();
                                    break;
                                }
                                case 15: {
                                    this.mulVnMnn(this.vnStore.stack[--this.vnStore.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 6: {
                            switch (aux2) {
                                case 0: {
                                    this.m22Store.mulS();
                                    break;
                                }
                                case 2: {
                                    this.mulM22V2();
                                    break;
                                }
                                case 6: {
                                    this.mulM22M22();
                                    break;
                                }
                                case 7: {
                                    this.mulM22M23();
                                    break;
                                }
                                case 8: {
                                    this.mulM22M24();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m22Store.stack[--this.m22Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 7: {
                            switch (aux2) {
                                case 0: {
                                    this.m23Store.mulS();
                                    break;
                                }
                                case 3: {
                                    this.mulM23V3();
                                    break;
                                }
                                case 9: {
                                    this.mulM23M32();
                                    break;
                                }
                                case 10: {
                                    this.mulM23M33();
                                    break;
                                }
                                case 11: {
                                    this.mulM23M34();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m23Store.stack[--this.m23Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 8: {
                            switch (aux2) {
                                case 0: {
                                    this.m24Store.mulS();
                                    break;
                                }
                                case 4: {
                                    this.mulM24V4();
                                    break;
                                }
                                case 12: {
                                    this.mulM24M42();
                                    break;
                                }
                                case 13: {
                                    this.mulM24M43();
                                    break;
                                }
                                case 14: {
                                    this.mulM24M44();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m24Store.stack[--this.m24Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 9: {
                            switch (aux2) {
                                case 0: {
                                    this.m32Store.mulS();
                                    break;
                                }
                                case 2: {
                                    this.mulM32V2();
                                    break;
                                }
                                case 6: {
                                    this.mulM32M22();
                                    break;
                                }
                                case 7: {
                                    this.mulM32M23();
                                    break;
                                }
                                case 8: {
                                    this.mulM32M24();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m32Store.stack[--this.m32Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 10: {
                            switch (aux2) {
                                case 0: {
                                    this.m33Store.mulS();
                                    break;
                                }
                                case 3: {
                                    this.mulM33V3();
                                    break;
                                }
                                case 9: {
                                    this.mulM33M32();
                                    break;
                                }
                                case 10: {
                                    this.mulM33M33();
                                    break;
                                }
                                case 11: {
                                    this.mulM33M34();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m33Store.stack[--this.m33Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 11: {
                            switch (aux2) {
                                case 0: {
                                    this.m34Store.mulS();
                                    break;
                                }
                                case 4: {
                                    this.mulM34V4();
                                    break;
                                }
                                case 12: {
                                    this.mulM34M42();
                                    break;
                                }
                                case 13: {
                                    this.mulM34M43();
                                    break;
                                }
                                case 14: {
                                    this.mulM34M44();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m34Store.stack[--this.m34Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 12: {
                            switch (aux2) {
                                case 0: {
                                    this.m42Store.mulS();
                                    break;
                                }
                                case 2: {
                                    this.mulM42V2();
                                    break;
                                }
                                case 6: {
                                    this.mulM42M22();
                                    break;
                                }
                                case 7: {
                                    this.mulM42M23();
                                    break;
                                }
                                case 8: {
                                    this.mulM42M24();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m42Store.stack[--this.m42Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 13: {
                            switch (aux2) {
                                case 0: {
                                    this.m43Store.mulS();
                                    break;
                                }
                                case 3: {
                                    this.mulM43V3();
                                    break;
                                }
                                case 9: {
                                    this.mulM43M32();
                                    break;
                                }
                                case 10: {
                                    this.mulM43M33();
                                    break;
                                }
                                case 11: {
                                    this.mulM43M34();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m43Store.stack[--this.m43Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 14: {
                            switch (aux2) {
                                case 0: {
                                    this.m44Store.mulS();
                                    break;
                                }
                                case 4: {
                                    this.mulM44V4();
                                    break;
                                }
                                case 12: {
                                    this.mulM44M42();
                                    break;
                                }
                                case 13: {
                                    this.mulM44M43();
                                    break;
                                }
                                case 14: {
                                    this.mulM44M44();
                                    break;
                                }
                                case 15: {
                                    this.mulMnnMnn(this.m44Store.stack[--this.m44Store.sp], this.mnnStore.stack[--this.mnnStore.sp]);
                                }
                            }
                            break;
                        }
                        case 15: {
                            switch (aux2) {
                                case 0: {
                                    this.mnnStore.mulS();
                                    break block78;
                                }
                                case 2: {
                                    this.mulMnnVn(this.mnnStore.stack[--this.mnnStore.sp], this.v2Store.stack[--this.v2Store.sp]);
                                    break block78;
                                }
                                case 3: {
                                    this.mulMnnVn(this.mnnStore.stack[--this.mnnStore.sp], this.v3Store.stack[--this.v3Store.sp]);
                                    break block78;
                                }
                                case 4: {
                                    this.mulMnnVn(this.mnnStore.stack[--this.mnnStore.sp], this.v4Store.stack[--this.v4Store.sp]);
                                    break block78;
                                }
                                case 5: {
                                    this.mulMnnVn(this.mnnStore.stack[--this.mnnStore.sp], this.vnStore.stack[--this.vnStore.sp]);
                                    break block78;
                                }
                                case 6: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m22Store.stack[--this.m22Store.sp]);
                                    break block78;
                                }
                                case 7: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m23Store.stack[--this.m23Store.sp]);
                                    break block78;
                                }
                                case 8: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m24Store.stack[--this.m24Store.sp]);
                                    break block78;
                                }
                                case 9: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m32Store.stack[--this.m32Store.sp]);
                                    break block78;
                                }
                                case 10: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m33Store.stack[--this.m33Store.sp]);
                                    break block78;
                                }
                                case 11: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m34Store.stack[--this.m34Store.sp]);
                                    break block78;
                                }
                                case 12: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m42Store.stack[--this.m42Store.sp]);
                                    break block78;
                                }
                                case 13: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m43Store.stack[--this.m43Store.sp]);
                                    break block78;
                                }
                                case 14: {
                                    this.mulMnnMnn(this.mnnStore.stack[--this.mnnStore.sp], this.m44Store.stack[--this.m44Store.sp]);
                                    break block78;
                                }
                                case 15: {
                                    MnnObj r = this.mnnStore.stack[--this.mnnStore.sp];
                                    MnnObj l = this.mnnStore.stack[--this.mnnStore.sp];
                                    this.mulMnnMnn(l, r);
                                }
                            }
                        }
                    }
                    continue block350;
                }
                case 5: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.divS();
                            break;
                        }
                        case 2: {
                            this.v2Store.divS();
                            break;
                        }
                        case 3: {
                            this.v3Store.divS();
                            break;
                        }
                        case 4: {
                            this.v4Store.divS();
                            break;
                        }
                        case 5: {
                            this.vnStore.divS();
                            break;
                        }
                        case 6: {
                            this.m22Store.divS();
                            break;
                        }
                        case 7: {
                            this.m23Store.divS();
                            break;
                        }
                        case 8: {
                            this.m24Store.divS();
                            break;
                        }
                        case 9: {
                            this.m32Store.divS();
                            break;
                        }
                        case 10: {
                            this.m33Store.divS();
                            break;
                        }
                        case 11: {
                            this.m34Store.divS();
                            break;
                        }
                        case 12: {
                            this.m42Store.divS();
                            break;
                        }
                        case 13: {
                            this.m43Store.divS();
                            break;
                        }
                        case 14: {
                            this.m44Store.divS();
                            break;
                        }
                        case 15: {
                            this.mnnStore.divS();
                        }
                    }
                    continue block350;
                }
                case 6: {
                    this.scalerStore.mod();
                    continue block350;
                }
                case 7: {
                    this.scalerStore.pow();
                    continue block350;
                }
                case 8: {
                    this.scalerStore.and();
                    continue block350;
                }
                case 9: {
                    this.scalerStore.or();
                    continue block350;
                }
                case 10: {
                    this.scalerStore.not();
                    continue block350;
                }
                case 11: {
                    this.scalerStore.lt();
                    continue block350;
                }
                case 12: {
                    this.scalerStore.le();
                    continue block350;
                }
                case 13: {
                    this.scalerStore.gt();
                    continue block350;
                }
                case 14: {
                    this.scalerStore.ge();
                    continue block350;
                }
                case 15: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.neq();
                            break;
                        }
                        case 2: {
                            this.v2Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 3: {
                            this.v3Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 4: {
                            this.v4Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 6: {
                            this.m22Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 7: {
                            this.m23Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 8: {
                            this.m24Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 9: {
                            this.m32Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 10: {
                            this.m33Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 11: {
                            this.m34Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 12: {
                            this.m42Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 13: {
                            this.m43Store.eq();
                            this.scalerStore.not();
                            break;
                        }
                        case 14: {
                            this.m44Store.eq();
                            this.scalerStore.not();
                        }
                    }
                    continue block350;
                }
                case 16: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.eq();
                            break;
                        }
                        case 2: {
                            this.v2Store.eq();
                            break;
                        }
                        case 3: {
                            this.v3Store.eq();
                            break;
                        }
                        case 4: {
                            this.v4Store.eq();
                            break;
                        }
                        case 6: {
                            this.m22Store.eq();
                            break;
                        }
                        case 7: {
                            this.m23Store.eq();
                            break;
                        }
                        case 8: {
                            this.m24Store.eq();
                            break;
                        }
                        case 9: {
                            this.m32Store.eq();
                            break;
                        }
                        case 10: {
                            this.m33Store.eq();
                            break;
                        }
                        case 11: {
                            this.m34Store.eq();
                            break;
                        }
                        case 12: {
                            this.m42Store.eq();
                            break;
                        }
                        case 13: {
                            this.m43Store.eq();
                            break;
                        }
                        case 14: {
                            this.m44Store.eq();
                        }
                    }
                    continue block350;
                }
                case 20: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.assign(aux2);
                            break;
                        }
                        case 2: {
                            this.v2Store.assign(aux2);
                            break;
                        }
                        case 3: {
                            this.v3Store.assign(aux2);
                            break;
                        }
                        case 4: {
                            this.v4Store.assign(aux2);
                            break;
                        }
                        case 5: {
                            this.vnStore.assign(aux2);
                            break;
                        }
                        case 6: {
                            this.m22Store.assign(aux2);
                            break;
                        }
                        case 7: {
                            this.m23Store.assign(aux2);
                            break;
                        }
                        case 8: {
                            this.m24Store.assign(aux2);
                            break;
                        }
                        case 9: {
                            this.m32Store.assign(aux2);
                            break;
                        }
                        case 10: {
                            this.m33Store.assign(aux2);
                            break;
                        }
                        case 11: {
                            this.m34Store.assign(aux2);
                            break;
                        }
                        case 12: {
                            this.m42Store.assign(aux2);
                            break;
                        }
                        case 13: {
                            this.m43Store.assign(aux2);
                            break;
                        }
                        case 14: {
                            this.m44Store.assign(aux2);
                            break;
                        }
                        case 15: {
                            this.mnnStore.assign(aux2);
                        }
                    }
                    continue block350;
                }
                case 17: {
                    switch (aux1) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            this.v2Store.makeList();
                            break;
                        }
                        case 3: {
                            this.v3Store.makeList();
                            break;
                        }
                        case 4: {
                            this.v4Store.makeList();
                            break;
                        }
                        case 6: {
                            this.m22Store.makeList();
                            break;
                        }
                        case 7: {
                            this.m23Store.makeList();
                            break;
                        }
                        case 8: {
                            this.m24Store.makeList();
                            break;
                        }
                        case 9: {
                            this.m32Store.makeList();
                            break;
                        }
                        case 10: {
                            this.m33Store.makeList();
                            break;
                        }
                        case 11: {
                            this.m34Store.makeList();
                            break;
                        }
                        case 12: {
                            this.m42Store.makeList();
                            break;
                        }
                        case 13: {
                            this.m43Store.makeList();
                            break;
                        }
                        case 14: {
                            this.m44Store.makeList();
                        }
                    }
                    continue block350;
                }
                case 21: {
                    this.vnStore.makeList(aux1);
                    continue block350;
                }
                case 22: {
                    this.mnnStore.makeList(aux1, aux2);
                    continue block350;
                }
                case 18: {
                    switch (aux1) {
                        case 2: {
                            this.dotV2();
                            break;
                        }
                        case 3: {
                            this.dotV3();
                            break;
                        }
                        case 4: {
                            this.dotV4();
                            break;
                        }
                        case 5: {
                            this.dotVn();
                        }
                    }
                    continue block350;
                }
                case 19: {
                    switch (aux1) {
                        case 2: {
                            this.crossV2();
                            break;
                        }
                        case 3: {
                            this.crossV3();
                        }
                    }
                    continue block350;
                }
                case 23: {
                    this.unitaryFunction(aux1);
                    continue block350;
                }
                case 24: {
                    switch (aux1) {
                        case 0: {
                            this.scalerStore.uminus();
                            break block0;
                        }
                        case 2: {
                            this.v2Store.uminus();
                            break block0;
                        }
                        case 3: {
                            this.v3Store.uminus();
                            break block0;
                        }
                        case 4: {
                            this.v4Store.uminus();
                            break block0;
                        }
                        case 5: {
                            this.vnStore.uminus();
                            break block0;
                        }
                        case 6: {
                            this.m22Store.uminus();
                            break block0;
                        }
                        case 7: {
                            this.m23Store.uminus();
                            break block0;
                        }
                        case 8: {
                            this.m24Store.uminus();
                            break block0;
                        }
                        case 9: {
                            this.m32Store.uminus();
                            break block0;
                        }
                        case 10: {
                            this.m33Store.uminus();
                            break block0;
                        }
                        case 11: {
                            this.m34Store.uminus();
                            break block0;
                        }
                        case 12: {
                            this.m42Store.uminus();
                            break block0;
                        }
                        case 13: {
                            this.m43Store.uminus();
                            break block0;
                        }
                        case 14: {
                            this.m44Store.uminus();
                            break block0;
                        }
                        case 15: {
                            this.mnnStore.uminus();
                        }
                    }
                }
            }
        }
        switch (comList.getFinalType()) {
            case 0: {
                this.scalerRes.a = this.scalerStore.stack[--this.scalerStore.sp];
                return this.scalerRes;
            }
            case 2: {
                return this.v2Store.stack[--this.v2Store.sp];
            }
            case 3: {
                return this.v3Store.stack[--this.v3Store.sp];
            }
            case 4: {
                return this.v4Store.stack[--this.v4Store.sp];
            }
            case 5: {
                return this.vnStore.stack[--this.vnStore.sp];
            }
            case 6: {
                return this.m22Store.stack[--this.m22Store.sp];
            }
            case 7: {
                return this.m23Store.stack[--this.m23Store.sp];
            }
            case 8: {
                return this.m24Store.stack[--this.m24Store.sp];
            }
            case 9: {
                return this.m32Store.stack[--this.m32Store.sp];
            }
            case 10: {
                return this.m33Store.stack[--this.m33Store.sp];
            }
            case 11: {
                return this.m34Store.stack[--this.m34Store.sp];
            }
            case 12: {
                return this.m42Store.stack[--this.m42Store.sp];
            }
            case 13: {
                return this.m43Store.stack[--this.m43Store.sp];
            }
            case 14: {
                return this.m44Store.stack[--this.m44Store.sp];
            }
            case 15: {
                return this.mnnStore.stack[--this.mnnStore.sp];
            }
        }
        return null;
    }

    private final void dotV2() {
        V2Obj r = this.v2Store.stack[--this.v2Store.sp];
        V2Obj l = this.v2Store.stack[--this.v2Store.sp];
        this.scalerStore.stack[this.scalerStore.sp++] = l.a * r.a + l.b * r.b;
    }

    private final void crossV2() {
        V2Obj r = this.v2Store.stack[--this.v2Store.sp];
        V2Obj l = this.v2Store.stack[--this.v2Store.sp];
        this.scalerStore.stack[this.scalerStore.sp++] = l.a * r.b - l.b * r.a;
    }

    private final void dotV3() {
        V3Obj r = this.v3Store.stack[--this.v3Store.sp];
        V3Obj l = this.v3Store.stack[--this.v3Store.sp];
        this.scalerStore.stack[this.scalerStore.sp++] = l.a * r.a + l.b * r.b + l.c * r.c;
    }

    private final void crossV3() {
        V3Obj r = this.v3Store.stack[--this.v3Store.sp];
        V3Obj l = this.v3Store.stack[--this.v3Store.sp];
        V3Obj res = this.v3Store.heap[this.v3Store.hp++];
        res.a = l.b * r.c - l.c * r.b;
        res.b = l.c * r.a - l.a * r.c;
        res.c = l.a * r.b - l.b * r.a;
        this.v3Store.stack[this.v3Store.sp++] = res;
    }

    private final void dotV4() {
        V4Obj r = this.v4Store.stack[--this.v4Store.sp];
        V4Obj l = this.v4Store.stack[--this.v4Store.sp];
        this.scalerStore.stack[this.scalerStore.sp++] = l.a * r.a + l.b * r.b + l.c * r.c + l.d * r.d;
    }

    private final void dotVn() {
        VnObj r = this.vnStore.stack[--this.vnStore.sp];
        VnObj l = this.vnStore.stack[--this.vnStore.sp];
        double res = l.data[0] * r.data[0];
        for (int i = 1; i < l.data.length; ++i) {
            res += l.data[i] * r.data[i];
        }
        this.scalerStore.stack[this.scalerStore.sp++] = res;
    }

    private final void mulM22V2() {
        V2Obj r = this.v2Store.stack[--this.v2Store.sp];
        M22Obj l = this.m22Store.stack[--this.m22Store.sp];
        V2Obj res = this.v2Store.heap[this.v2Store.hp++];
        res.a = l.a * r.a + l.b * r.b;
        res.b = l.c * r.a + l.d * r.b;
        this.v2Store.stack[this.v2Store.sp++] = res;
    }

    private final void mulV2M22() {
        M22Obj r = this.m22Store.stack[--this.m22Store.sp];
        V2Obj l = this.v2Store.stack[--this.v2Store.sp];
        V2Obj res = this.v2Store.heap[this.v2Store.hp++];
        res.a = l.a * r.a + l.b * r.c;
        res.b = l.a * r.b + l.b * r.d;
        this.v2Store.stack[this.v2Store.sp++] = res;
    }

    private final void mulM32V2() {
        V2Obj r = this.v2Store.stack[--this.v2Store.sp];
        M32Obj l = this.m32Store.stack[--this.m32Store.sp];
        V3Obj res = this.v3Store.heap[this.v3Store.hp++];
        res.a = l.a * r.a + l.b * r.b;
        res.b = l.c * r.a + l.d * r.b;
        res.c = l.e * r.a + l.f * r.b;
        this.v3Store.stack[this.v3Store.sp++] = res;
    }

    private final void mulV2M23() {
        M23Obj r = this.m23Store.stack[--this.m23Store.sp];
        V2Obj l = this.v2Store.stack[--this.v2Store.sp];
        V3Obj res = this.v3Store.heap[this.v3Store.hp++];
        res.a = l.a * r.a + l.b * r.d;
        res.b = l.a * r.b + l.b * r.e;
        res.c = l.a * r.c + l.b * r.f;
        this.v3Store.stack[this.v3Store.sp++] = res;
    }

    private final void mulM42V2() {
        V2Obj r = this.v2Store.stack[--this.v2Store.sp];
        M42Obj l = this.m42Store.stack[--this.m42Store.sp];
        V4Obj res = this.v4Store.heap[this.v4Store.hp++];
        res.a = l.a * r.a + l.b * r.b;
        res.b = l.c * r.a + l.d * r.b;
        res.c = l.e * r.a + l.f * r.b;
        res.d = l.g * r.a + l.h * r.b;
        this.v4Store.stack[this.v4Store.sp++] = res;
    }

    private final void mulV2M24() {
        M24Obj r = this.m24Store.stack[--this.m24Store.sp];
        V2Obj l = this.v2Store.stack[--this.v2Store.sp];
        V4Obj res = this.v4Store.heap[this.v4Store.hp++];
        res.a = l.a * r.a + l.b * r.e;
        res.b = l.a * r.b + l.b * r.f;
        res.c = l.a * r.c + l.b * r.g;
        res.d = l.a * r.d + l.b * r.h;
        this.v4Store.stack[this.v4Store.sp++] = res;
    }

    private final void mulM23V3() {
        V3Obj r = this.v3Store.stack[--this.v3Store.sp];
        M23Obj l = this.m23Store.stack[--this.m23Store.sp];
        V2Obj res = this.v2Store.heap[this.v2Store.hp++];
        res.a = l.a * r.a + l.b * r.b + l.c * r.c;
        res.b = l.d * r.a + l.e * r.b + l.f * r.c;
        this.v2Store.stack[this.v2Store.sp++] = res;
    }

    private final void mulV3M32() {
        M32Obj r = this.m32Store.stack[--this.m32Store.sp];
        V3Obj l = this.v3Store.stack[--this.v3Store.sp];
        V2Obj res = this.v2Store.heap[this.v2Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f;
        this.v2Store.stack[this.v2Store.sp++] = res;
    }

    private final void mulM33V3() {
        V3Obj r = this.v3Store.stack[--this.v3Store.sp];
        M33Obj l = this.m33Store.stack[--this.m33Store.sp];
        V3Obj res = this.v3Store.heap[this.v3Store.hp++];
        res.a = l.a * r.a + l.b * r.b + l.c * r.c;
        res.b = l.d * r.a + l.e * r.b + l.f * r.c;
        res.c = l.g * r.a + l.h * r.b + l.i * r.c;
        this.v3Store.stack[this.v3Store.sp++] = res;
    }

    private final void mulV3M33() {
        M33Obj r = this.m33Store.stack[--this.m33Store.sp];
        V3Obj l = this.v3Store.stack[--this.v3Store.sp];
        V3Obj res = this.v3Store.heap[this.v3Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i;
        this.v3Store.stack[this.v3Store.sp++] = res;
    }

    private final void mulM43V3() {
        V3Obj r = this.v3Store.stack[--this.v3Store.sp];
        M43Obj l = this.m43Store.stack[--this.m43Store.sp];
        V4Obj res = this.v4Store.heap[this.v4Store.hp++];
        res.a = l.a * r.a + l.b * r.b + l.c * r.c;
        res.b = l.d * r.a + l.e * r.b + l.f * r.c;
        res.c = l.g * r.a + l.h * r.b + l.i * r.c;
        res.d = l.j * r.a + l.k * r.b + l.l * r.c;
        this.v4Store.stack[this.v4Store.sp++] = res;
    }

    private final void mulV3M34() {
        M34Obj r = this.m34Store.stack[--this.m34Store.sp];
        V3Obj l = this.v3Store.stack[--this.v3Store.sp];
        V4Obj res = this.v4Store.heap[this.v4Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l;
        this.v4Store.stack[this.v4Store.sp++] = res;
    }

    private final void mulM24V4() {
        V4Obj r = this.v4Store.stack[--this.v4Store.sp];
        M24Obj l = this.m24Store.stack[--this.m24Store.sp];
        V2Obj res = this.v2Store.heap[this.v2Store.hp++];
        res.a = l.a * r.a + l.b * r.b + l.c * r.c + l.d * r.d;
        res.b = l.e * r.a + l.f * r.b + l.g * r.c + l.h * r.d;
        this.v2Store.stack[this.v2Store.sp++] = res;
    }

    private final void mulV4M42() {
        M42Obj r = this.m42Store.stack[--this.m42Store.sp];
        V4Obj l = this.v4Store.stack[--this.v4Store.sp];
        V2Obj res = this.v2Store.heap[this.v2Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e + l.d * r.g;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f + l.d * r.h;
        this.v2Store.stack[this.v2Store.sp++] = res;
    }

    private final void mulM34V4() {
        V4Obj r = this.v4Store.stack[--this.v4Store.sp];
        M34Obj l = this.m34Store.stack[--this.m34Store.sp];
        V3Obj res = this.v3Store.heap[this.v3Store.hp++];
        res.a = l.a * r.a + l.b * r.b + l.c * r.c + l.d * r.d;
        res.b = l.e * r.a + l.f * r.b + l.g * r.c + l.h * r.d;
        res.c = l.i * r.a + l.j * r.b + l.k * r.c + l.l * r.d;
        this.v3Store.stack[this.v3Store.sp++] = res;
    }

    private final void mulV4M43() {
        M43Obj r = this.m43Store.stack[--this.m43Store.sp];
        V4Obj l = this.v4Store.stack[--this.v4Store.sp];
        V3Obj res = this.v3Store.heap[this.v3Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g + l.d * r.j;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h + l.d * r.k;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i + l.d * r.l;
        this.v3Store.stack[this.v3Store.sp++] = res;
    }

    private final void mulM44V4() {
        V4Obj r = this.v4Store.stack[--this.v4Store.sp];
        M44Obj l = this.m44Store.stack[--this.m44Store.sp];
        V4Obj res = this.v4Store.heap[this.v4Store.hp++];
        res.a = l.a * r.a + l.b * r.b + l.c * r.c + l.d * r.d;
        res.b = l.e * r.a + l.f * r.b + l.g * r.c + l.h * r.d;
        res.c = l.i * r.a + l.j * r.b + l.k * r.c + l.l * r.d;
        res.d = l.m * r.a + l.n * r.b + l.o * r.c + l.p * r.d;
        this.v4Store.stack[this.v4Store.sp++] = res;
    }

    private final void mulV4M44() {
        M44Obj r = this.m44Store.stack[--this.m44Store.sp];
        V4Obj l = this.v4Store.stack[--this.v4Store.sp];
        V4Obj res = this.v4Store.heap[this.v4Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i + l.d * r.m;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j + l.d * r.n;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k + l.d * r.o;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l + l.d * r.p;
        this.v4Store.stack[this.v4Store.sp++] = res;
    }

    private final void mulM22M22() {
        M22Obj r = this.m22Store.stack[--this.m22Store.sp];
        M22Obj l = this.m22Store.stack[--this.m22Store.sp];
        M22Obj res = this.m22Store.heap[this.m22Store.hp++];
        res.a = l.a * r.a + l.b * r.c;
        res.b = l.a * r.b + l.b * r.d;
        res.c = l.c * r.a + l.d * r.c;
        res.d = l.c * r.b + l.d * r.d;
        this.m22Store.stack[this.m22Store.sp++] = res;
    }

    private final void mulM22M23() {
        M23Obj r = this.m23Store.stack[--this.m23Store.sp];
        M22Obj l = this.m22Store.stack[--this.m22Store.sp];
        M23Obj res = this.m23Store.heap[this.m23Store.hp++];
        res.a = l.a * r.a + l.b * r.d;
        res.b = l.a * r.b + l.b * r.e;
        res.c = l.a * r.c + l.b * r.f;
        res.d = l.c * r.a + l.d * r.d;
        res.e = l.c * r.b + l.d * r.e;
        res.f = l.c * r.c + l.d * r.f;
        this.m23Store.stack[this.m23Store.sp++] = res;
    }

    private final void mulM22M24() {
        M24Obj r = this.m24Store.stack[--this.m24Store.sp];
        M22Obj l = this.m22Store.stack[--this.m22Store.sp];
        M24Obj res = this.m24Store.heap[this.m24Store.hp++];
        res.a = l.a * r.a + l.b * r.e;
        res.b = l.a * r.b + l.b * r.f;
        res.c = l.a * r.c + l.b * r.g;
        res.d = l.a * r.d + l.b * r.h;
        res.e = l.c * r.a + l.d * r.e;
        res.f = l.c * r.b + l.d * r.f;
        res.g = l.c * r.c + l.d * r.g;
        res.h = l.c * r.d + l.d * r.h;
        this.m24Store.stack[this.m24Store.sp++] = res;
    }

    private final void mulM23M32() {
        M32Obj r = this.m32Store.stack[--this.m32Store.sp];
        M23Obj l = this.m23Store.stack[--this.m23Store.sp];
        M22Obj res = this.m22Store.heap[this.m22Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f;
        res.c = l.d * r.a + l.e * r.c + l.f * r.e;
        res.d = l.d * r.b + l.e * r.d + l.f * r.f;
        this.m22Store.stack[this.m22Store.sp++] = res;
    }

    private final void mulM23M33() {
        M33Obj r = this.m33Store.stack[--this.m33Store.sp];
        M23Obj l = this.m23Store.stack[--this.m23Store.sp];
        M23Obj res = this.m23Store.heap[this.m23Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i;
        res.d = l.d * r.a + l.e * r.d + l.f * r.g;
        res.e = l.d * r.b + l.e * r.e + l.f * r.h;
        res.f = l.d * r.c + l.e * r.f + l.f * r.i;
        this.m23Store.stack[this.m23Store.sp++] = res;
    }

    private final void mulM23M34() {
        M34Obj r = this.m34Store.stack[--this.m34Store.sp];
        M23Obj l = this.m23Store.stack[--this.m23Store.sp];
        M24Obj res = this.m24Store.heap[this.m24Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l;
        res.e = l.d * r.a + l.e * r.e + l.f * r.i;
        res.f = l.d * r.b + l.e * r.f + l.f * r.j;
        res.g = l.d * r.c + l.e * r.g + l.f * r.k;
        res.h = l.d * r.d + l.e * r.h + l.f * r.l;
        this.m24Store.stack[this.m24Store.sp++] = res;
    }

    private final void mulM24M42() {
        M42Obj r = this.m42Store.stack[--this.m42Store.sp];
        M24Obj l = this.m24Store.stack[--this.m24Store.sp];
        M22Obj res = this.m22Store.heap[this.m22Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e + l.d * r.g;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f + l.d * r.h;
        res.c = l.e * r.a + l.f * r.c + l.g * r.e + l.h * r.g;
        res.d = l.e * r.b + l.f * r.d + l.g * r.f + l.h * r.h;
        this.m22Store.stack[this.m22Store.sp++] = res;
    }

    private final void mulM24M43() {
        M43Obj r = this.m43Store.stack[--this.m43Store.sp];
        M24Obj l = this.m24Store.stack[--this.m24Store.sp];
        M23Obj res = this.m23Store.heap[this.m23Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g + l.d * r.j;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h + l.d * r.k;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i + l.d * r.l;
        res.d = l.e * r.a + l.f * r.d + l.g * r.g + l.h * r.j;
        res.e = l.e * r.b + l.f * r.e + l.g * r.h + l.h * r.k;
        res.f = l.e * r.c + l.f * r.f + l.g * r.i + l.h * r.l;
        this.m23Store.stack[this.m23Store.sp++] = res;
    }

    private final void mulM24M44() {
        M44Obj r = this.m44Store.stack[--this.m44Store.sp];
        M24Obj l = this.m24Store.stack[--this.m24Store.sp];
        M24Obj res = this.m24Store.heap[this.m24Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i + l.d * r.m;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j + l.d * r.n;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k + l.d * r.o;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l + l.d * r.p;
        res.e = l.e * r.a + l.f * r.e + l.g * r.i + l.h * r.m;
        res.f = l.e * r.b + l.f * r.f + l.g * r.j + l.h * r.n;
        res.g = l.e * r.c + l.f * r.g + l.g * r.k + l.h * r.o;
        res.h = l.e * r.d + l.f * r.h + l.g * r.l + l.h * r.p;
        this.m24Store.stack[this.m24Store.sp++] = res;
    }

    private final void mulM32M22() {
        M22Obj r = this.m22Store.stack[--this.m22Store.sp];
        M32Obj l = this.m32Store.stack[--this.m32Store.sp];
        M32Obj res = this.m32Store.heap[this.m32Store.hp++];
        res.a = l.a * r.a + l.b * r.c;
        res.b = l.a * r.b + l.b * r.d;
        res.c = l.c * r.a + l.d * r.c;
        res.d = l.c * r.b + l.d * r.d;
        res.e = l.e * r.a + l.f * r.c;
        res.f = l.e * r.b + l.f * r.d;
        this.m32Store.stack[this.m32Store.sp++] = res;
    }

    private final void mulM32M23() {
        M23Obj r = this.m23Store.stack[--this.m23Store.sp];
        M32Obj l = this.m32Store.stack[--this.m32Store.sp];
        M33Obj res = this.m33Store.heap[this.m33Store.hp++];
        res.a = l.a * r.a + l.b * r.d;
        res.b = l.a * r.b + l.b * r.e;
        res.c = l.a * r.c + l.b * r.f;
        res.d = l.c * r.a + l.d * r.d;
        res.e = l.c * r.b + l.d * r.e;
        res.f = l.c * r.c + l.d * r.f;
        res.g = l.e * r.a + l.f * r.d;
        res.h = l.e * r.b + l.f * r.e;
        res.i = l.e * r.c + l.f * r.f;
        this.m33Store.stack[this.m33Store.sp++] = res;
    }

    private final void mulM32M24() {
        M24Obj r = this.m24Store.stack[--this.m24Store.sp];
        M32Obj l = this.m32Store.stack[--this.m32Store.sp];
        M34Obj res = this.m34Store.heap[this.m34Store.hp++];
        res.a = l.a * r.a + l.b * r.e;
        res.b = l.a * r.b + l.b * r.f;
        res.c = l.a * r.c + l.b * r.g;
        res.d = l.a * r.d + l.b * r.h;
        res.e = l.c * r.a + l.d * r.e;
        res.f = l.c * r.b + l.d * r.f;
        res.g = l.c * r.c + l.d * r.g;
        res.h = l.c * r.d + l.d * r.h;
        res.i = l.e * r.a + l.f * r.e;
        res.j = l.e * r.b + l.f * r.f;
        res.k = l.e * r.c + l.f * r.g;
        res.l = l.e * r.d + l.f * r.h;
        this.m34Store.stack[this.m34Store.sp++] = res;
    }

    private final void mulM33M32() {
        M32Obj r = this.m32Store.stack[--this.m32Store.sp];
        M33Obj l = this.m33Store.stack[--this.m33Store.sp];
        M32Obj res = this.m32Store.heap[this.m32Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f;
        res.c = l.d * r.a + l.e * r.c + l.f * r.e;
        res.d = l.d * r.b + l.e * r.d + l.f * r.f;
        res.e = l.g * r.a + l.h * r.c + l.i * r.e;
        res.f = l.g * r.b + l.h * r.d + l.i * r.f;
        this.m32Store.stack[this.m32Store.sp++] = res;
    }

    private final void mulM33M33() {
        M33Obj r = this.m33Store.stack[--this.m33Store.sp];
        M33Obj l = this.m33Store.stack[--this.m33Store.sp];
        M33Obj res = this.m33Store.heap[this.m33Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i;
        res.d = l.d * r.a + l.e * r.d + l.f * r.g;
        res.e = l.d * r.b + l.e * r.e + l.f * r.h;
        res.f = l.d * r.c + l.e * r.f + l.f * r.i;
        res.g = l.g * r.a + l.h * r.d + l.i * r.g;
        res.h = l.g * r.b + l.h * r.e + l.i * r.h;
        res.i = l.g * r.c + l.h * r.f + l.i * r.i;
        this.m33Store.stack[this.m33Store.sp++] = res;
    }

    private final void mulM33M34() {
        M34Obj r = this.m34Store.stack[--this.m34Store.sp];
        M33Obj l = this.m33Store.stack[--this.m33Store.sp];
        M34Obj res = this.m34Store.heap[this.m34Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l;
        res.e = l.d * r.a + l.e * r.e + l.f * r.i;
        res.f = l.d * r.b + l.e * r.f + l.f * r.j;
        res.g = l.d * r.c + l.e * r.g + l.f * r.k;
        res.h = l.d * r.d + l.e * r.h + l.f * r.l;
        res.i = l.g * r.a + l.h * r.e + l.i * r.i;
        res.j = l.g * r.b + l.h * r.f + l.i * r.j;
        res.k = l.g * r.c + l.h * r.g + l.i * r.k;
        res.l = l.g * r.d + l.h * r.h + l.i * r.l;
        this.m34Store.stack[this.m34Store.sp++] = res;
    }

    private final void mulM34M42() {
        M42Obj r = this.m42Store.stack[--this.m42Store.sp];
        M34Obj l = this.m34Store.stack[--this.m34Store.sp];
        M32Obj res = this.m32Store.heap[this.m32Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e + l.d * r.g;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f + l.d * r.h;
        res.c = l.e * r.a + l.f * r.c + l.g * r.e + l.h * r.g;
        res.d = l.e * r.b + l.f * r.d + l.g * r.f + l.h * r.h;
        res.e = l.i * r.a + l.j * r.c + l.k * r.e + l.l * r.g;
        res.f = l.i * r.b + l.j * r.d + l.k * r.f + l.l * r.h;
        this.m32Store.stack[this.m32Store.sp++] = res;
    }

    private final void mulM34M43() {
        M43Obj r = this.m43Store.stack[--this.m43Store.sp];
        M34Obj l = this.m34Store.stack[--this.m34Store.sp];
        M33Obj res = this.m33Store.heap[this.m33Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g + l.d * r.j;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h + l.d * r.k;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i + l.d * r.l;
        res.d = l.e * r.a + l.f * r.d + l.g * r.g + l.h * r.j;
        res.e = l.e * r.b + l.f * r.e + l.g * r.h + l.h * r.k;
        res.f = l.e * r.c + l.f * r.f + l.g * r.i + l.h * r.l;
        res.g = l.i * r.a + l.j * r.d + l.k * r.g + l.l * r.j;
        res.h = l.i * r.b + l.j * r.e + l.k * r.h + l.l * r.k;
        res.i = l.i * r.c + l.j * r.f + l.k * r.i + l.l * r.l;
        this.m33Store.stack[this.m33Store.sp++] = res;
    }

    private final void mulM34M44() {
        M44Obj r = this.m44Store.stack[--this.m44Store.sp];
        M34Obj l = this.m34Store.stack[--this.m34Store.sp];
        M34Obj res = this.m34Store.heap[this.m34Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i + l.d * r.m;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j + l.d * r.n;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k + l.d * r.o;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l + l.d * r.p;
        res.e = l.e * r.a + l.f * r.e + l.g * r.i + l.h * r.m;
        res.f = l.e * r.b + l.f * r.f + l.g * r.j + l.h * r.n;
        res.g = l.e * r.c + l.f * r.g + l.g * r.k + l.h * r.o;
        res.h = l.e * r.d + l.f * r.h + l.g * r.l + l.h * r.p;
        res.i = l.i * r.a + l.j * r.e + l.k * r.i + l.l * r.m;
        res.j = l.i * r.b + l.j * r.f + l.k * r.j + l.l * r.n;
        res.k = l.i * r.c + l.j * r.g + l.k * r.k + l.l * r.o;
        res.l = l.i * r.d + l.j * r.h + l.k * r.l + l.l * r.p;
        this.m34Store.stack[this.m34Store.sp++] = res;
    }

    private final void mulM42M22() {
        M22Obj r = this.m22Store.stack[--this.m22Store.sp];
        M42Obj l = this.m42Store.stack[--this.m42Store.sp];
        M42Obj res = this.m42Store.heap[this.m42Store.hp++];
        res.a = l.a * r.a + l.b * r.c;
        res.b = l.a * r.b + l.b * r.d;
        res.c = l.c * r.a + l.d * r.c;
        res.d = l.c * r.b + l.d * r.d;
        res.e = l.e * r.a + l.f * r.c;
        res.f = l.e * r.b + l.f * r.d;
        res.g = l.g * r.a + l.h * r.c;
        res.h = l.g * r.b + l.h * r.d;
        this.m42Store.stack[this.m42Store.sp++] = res;
    }

    private final void mulM42M23() {
        M23Obj r = this.m23Store.stack[--this.m23Store.sp];
        M42Obj l = this.m42Store.stack[--this.m42Store.sp];
        M43Obj res = this.m43Store.heap[this.m43Store.hp++];
        res.a = l.a * r.a + l.b * r.d;
        res.b = l.a * r.b + l.b * r.e;
        res.c = l.a * r.c + l.b * r.f;
        res.d = l.c * r.a + l.d * r.d;
        res.e = l.c * r.b + l.d * r.e;
        res.f = l.c * r.c + l.d * r.f;
        res.g = l.e * r.a + l.f * r.d;
        res.h = l.e * r.b + l.f * r.e;
        res.i = l.e * r.c + l.f * r.f;
        res.j = l.g * r.a + l.h * r.d;
        res.k = l.g * r.b + l.h * r.e;
        res.l = l.g * r.c + l.h * r.f;
        this.m43Store.stack[this.m43Store.sp++] = res;
    }

    private final void mulM42M24() {
        M24Obj r = this.m24Store.stack[--this.m24Store.sp];
        M42Obj l = this.m42Store.stack[--this.m42Store.sp];
        M44Obj res = this.m44Store.heap[this.m44Store.hp++];
        res.a = l.a * r.a + l.b * r.e;
        res.b = l.a * r.b + l.b * r.f;
        res.c = l.a * r.c + l.b * r.g;
        res.d = l.a * r.d + l.b * r.h;
        res.e = l.c * r.a + l.d * r.e;
        res.f = l.c * r.b + l.d * r.f;
        res.g = l.c * r.c + l.d * r.g;
        res.h = l.c * r.d + l.d * r.h;
        res.i = l.e * r.a + l.f * r.e;
        res.j = l.e * r.b + l.f * r.f;
        res.k = l.e * r.c + l.f * r.g;
        res.l = l.e * r.d + l.f * r.h;
        res.m = l.g * r.a + l.h * r.e;
        res.n = l.g * r.b + l.h * r.f;
        res.o = l.g * r.c + l.h * r.g;
        res.p = l.g * r.d + l.h * r.h;
        this.m44Store.stack[this.m44Store.sp++] = res;
    }

    private final void mulM43M32() {
        M32Obj r = this.m32Store.stack[--this.m32Store.sp];
        M43Obj l = this.m43Store.stack[--this.m43Store.sp];
        M42Obj res = this.m42Store.heap[this.m42Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f;
        res.c = l.d * r.a + l.e * r.c + l.f * r.e;
        res.d = l.d * r.b + l.e * r.d + l.f * r.f;
        res.e = l.g * r.a + l.h * r.c + l.i * r.e;
        res.f = l.g * r.b + l.h * r.d + l.i * r.f;
        res.g = l.j * r.a + l.k * r.c + l.l * r.e;
        res.h = l.j * r.b + l.k * r.d + l.l * r.f;
        this.m42Store.stack[this.m42Store.sp++] = res;
    }

    private final void mulM43M33() {
        M33Obj r = this.m33Store.stack[--this.m33Store.sp];
        M43Obj l = this.m43Store.stack[--this.m43Store.sp];
        M43Obj res = this.m43Store.heap[this.m43Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i;
        res.d = l.d * r.a + l.e * r.d + l.f * r.g;
        res.e = l.d * r.b + l.e * r.e + l.f * r.h;
        res.f = l.d * r.c + l.e * r.f + l.f * r.i;
        res.g = l.g * r.a + l.h * r.d + l.i * r.g;
        res.h = l.g * r.b + l.h * r.e + l.i * r.h;
        res.i = l.g * r.c + l.h * r.f + l.i * r.i;
        res.j = l.j * r.a + l.k * r.d + l.l * r.g;
        res.k = l.j * r.b + l.k * r.e + l.l * r.h;
        res.l = l.j * r.c + l.k * r.f + l.l * r.i;
        this.m43Store.stack[this.m43Store.sp++] = res;
    }

    private final void mulM43M34() {
        M34Obj r = this.m34Store.stack[--this.m34Store.sp];
        M43Obj l = this.m43Store.stack[--this.m43Store.sp];
        M44Obj res = this.m44Store.heap[this.m44Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l;
        res.e = l.d * r.a + l.e * r.e + l.f * r.i;
        res.f = l.d * r.b + l.e * r.f + l.f * r.j;
        res.g = l.d * r.c + l.e * r.g + l.f * r.k;
        res.h = l.d * r.d + l.e * r.h + l.f * r.l;
        res.i = l.g * r.a + l.h * r.e + l.i * r.i;
        res.j = l.g * r.b + l.h * r.f + l.i * r.j;
        res.k = l.g * r.c + l.h * r.g + l.i * r.k;
        res.l = l.g * r.d + l.h * r.h + l.i * r.l;
        res.m = l.j * r.a + l.k * r.e + l.l * r.i;
        res.n = l.j * r.b + l.k * r.f + l.l * r.j;
        res.o = l.j * r.c + l.k * r.g + l.l * r.k;
        res.p = l.j * r.d + l.k * r.h + l.l * r.l;
        this.m44Store.stack[this.m44Store.sp++] = res;
    }

    private final void mulM44M42() {
        M42Obj r = this.m42Store.stack[--this.m42Store.sp];
        M44Obj l = this.m44Store.stack[--this.m44Store.sp];
        M42Obj res = this.m42Store.heap[this.m42Store.hp++];
        res.a = l.a * r.a + l.b * r.c + l.c * r.e + l.d * r.g;
        res.b = l.a * r.b + l.b * r.d + l.c * r.f + l.d * r.h;
        res.c = l.e * r.a + l.f * r.c + l.g * r.e + l.h * r.g;
        res.d = l.e * r.b + l.f * r.d + l.g * r.f + l.h * r.h;
        res.e = l.i * r.a + l.j * r.c + l.k * r.e + l.l * r.g;
        res.f = l.i * r.b + l.j * r.d + l.k * r.f + l.l * r.h;
        res.g = l.m * r.a + l.n * r.c + l.o * r.e + l.p * r.g;
        res.h = l.m * r.b + l.n * r.d + l.o * r.f + l.p * r.h;
        this.m42Store.stack[this.m42Store.sp++] = res;
    }

    private final void mulM44M43() {
        M43Obj r = this.m43Store.stack[--this.m43Store.sp];
        M44Obj l = this.m44Store.stack[--this.m44Store.sp];
        M43Obj res = this.m43Store.heap[this.m43Store.hp++];
        res.a = l.a * r.a + l.b * r.d + l.c * r.g + l.d * r.j;
        res.b = l.a * r.b + l.b * r.e + l.c * r.h + l.d * r.k;
        res.c = l.a * r.c + l.b * r.f + l.c * r.i + l.d * r.l;
        res.d = l.e * r.a + l.f * r.d + l.g * r.g + l.h * r.j;
        res.e = l.e * r.b + l.f * r.e + l.g * r.h + l.h * r.k;
        res.f = l.e * r.c + l.f * r.f + l.g * r.i + l.h * r.l;
        res.g = l.i * r.a + l.j * r.d + l.k * r.g + l.l * r.j;
        res.h = l.i * r.b + l.j * r.e + l.k * r.h + l.l * r.k;
        res.i = l.i * r.c + l.j * r.f + l.k * r.i + l.l * r.l;
        res.j = l.m * r.a + l.n * r.d + l.o * r.g + l.p * r.j;
        res.k = l.m * r.b + l.n * r.e + l.o * r.h + l.p * r.k;
        res.l = l.m * r.c + l.n * r.f + l.o * r.i + l.p * r.l;
        this.m43Store.stack[this.m43Store.sp++] = res;
    }

    private final void mulM44M44() {
        M44Obj r = this.m44Store.stack[--this.m44Store.sp];
        M44Obj l = this.m44Store.stack[--this.m44Store.sp];
        M44Obj res = this.m44Store.heap[this.m44Store.hp++];
        res.a = l.a * r.a + l.b * r.e + l.c * r.i + l.d * r.m;
        res.b = l.a * r.b + l.b * r.f + l.c * r.j + l.d * r.n;
        res.c = l.a * r.c + l.b * r.g + l.c * r.k + l.d * r.o;
        res.d = l.a * r.d + l.b * r.h + l.c * r.l + l.d * r.p;
        res.e = l.e * r.a + l.f * r.e + l.g * r.i + l.h * r.m;
        res.f = l.e * r.b + l.f * r.f + l.g * r.j + l.h * r.n;
        res.g = l.e * r.c + l.f * r.g + l.g * r.k + l.h * r.o;
        res.h = l.e * r.d + l.f * r.h + l.g * r.l + l.h * r.p;
        res.i = l.i * r.a + l.j * r.e + l.k * r.i + l.l * r.m;
        res.j = l.i * r.b + l.j * r.f + l.k * r.j + l.l * r.n;
        res.k = l.i * r.c + l.j * r.g + l.k * r.k + l.l * r.o;
        res.l = l.i * r.d + l.j * r.h + l.k * r.l + l.l * r.p;
        res.m = l.m * r.a + l.n * r.e + l.o * r.i + l.p * r.m;
        res.n = l.m * r.b + l.n * r.f + l.o * r.j + l.p * r.n;
        res.o = l.m * r.c + l.n * r.g + l.o * r.k + l.p * r.o;
        res.p = l.m * r.d + l.n * r.h + l.o * r.l + l.p * r.p;
        this.m44Store.stack[this.m44Store.sp++] = res;
    }

    private final void mulVnMnn(VecObj l, MatObj r) {
        double[] ldata = l.toArrayVec();
        double[][] rdata = r.toArrayMat();
        int rrows = rdata.length;
        int rcols = rdata[0].length;
        double[] res = new double[rcols];
        for (int j = 0; j < rcols; ++j) {
            double ele = ldata[0] * rdata[0][j];
            for (int k = 1; k < rrows; ++k) {
                ele += ldata[k] * rdata[k][j];
            }
            res[j] = ele;
        }
        this.pushVec(res);
    }

    private final void mulMnnVn(MatObj l, VecObj r) {
        double[][] ldata = l.toArrayMat();
        double[] rdata = r.toArrayVec();
        int lrows = ldata.length;
        int lcols = ldata[0].length;
        double[] res = new double[lrows];
        for (int i = 0; i < lrows; ++i) {
            double ele = ldata[i][0] * rdata[0];
            for (int k = 1; k < lcols; ++k) {
                ele += ldata[i][k] * rdata[k];
            }
            res[i] = ele;
        }
        this.pushVec(res);
    }

    private final void mulMnnMnn(MatObj l, MatObj r) {
        double[][] ldata = l.toArrayMat();
        double[][] rdata = r.toArrayMat();
        int lrows = ldata.length;
        int rrows = rdata.length;
        int rcols = rdata[0].length;
        double[][] res = new double[lrows][rcols];
        for (int i = 0; i < lrows; ++i) {
            for (int j = 0; j < rcols; ++j) {
                double ele = ldata[i][0] * rdata[0][j];
                for (int k = 1; k < rrows; ++k) {
                    ele += ldata[i][k] * rdata[k][j];
                }
                res[i][j] = ele;
            }
        }
        this.pushMat(res);
    }

    private final void pushVec(double[] vec) {
        switch (vec.length) {
            case 2: {
                V2Obj v2 = this.v2Store.heap[this.v2Store.hp++];
                v2.a = vec[0];
                v2.b = vec[1];
                this.v2Store.stack[this.v2Store.sp++] = v2;
                break;
            }
            case 3: {
                V3Obj v3 = this.v3Store.heap[this.v3Store.hp++];
                v3.a = vec[0];
                v3.b = vec[1];
                v3.c = vec[2];
                this.v3Store.stack[this.v3Store.sp++] = v3;
                break;
            }
            case 4: {
                V4Obj v4 = this.v4Store.heap[this.v4Store.hp++];
                v4.a = vec[0];
                v4.b = vec[1];
                v4.c = vec[2];
                v4.d = vec[3];
                this.v4Store.stack[this.v4Store.sp++] = v4;
                break;
            }
            default: {
                this.vnStore.stack[this.vnStore.sp++] = new VnObj(vec);
            }
        }
    }

    private final void pushMat(double[][] mat) {
        switch (mat.length) {
            case 2: {
                switch (mat[0].length) {
                    case 2: {
                        M22Obj m22 = this.m22Store.heap[this.m22Store.hp++];
                        m22.a = mat[0][0];
                        m22.b = mat[0][1];
                        m22.c = mat[1][0];
                        m22.d = mat[1][1];
                        this.m22Store.stack[this.m22Store.sp++] = m22;
                        return;
                    }
                    case 3: {
                        M23Obj m23 = this.m23Store.heap[this.m23Store.hp++];
                        m23.a = mat[0][0];
                        m23.b = mat[0][1];
                        m23.c = mat[0][2];
                        m23.d = mat[1][0];
                        m23.e = mat[1][1];
                        m23.f = mat[1][2];
                        this.m23Store.stack[this.m23Store.sp++] = m23;
                        return;
                    }
                    case 4: {
                        M24Obj m24 = this.m24Store.heap[this.m24Store.hp++];
                        m24.a = mat[0][0];
                        m24.b = mat[0][1];
                        m24.c = mat[0][2];
                        m24.d = mat[0][3];
                        m24.e = mat[1][0];
                        m24.f = mat[1][1];
                        m24.g = mat[1][2];
                        m24.h = mat[1][3];
                        this.m24Store.stack[this.m24Store.sp++] = m24;
                        return;
                    }
                }
                break;
            }
            case 3: {
                switch (mat[0].length) {
                    case 2: {
                        M32Obj m32 = this.m32Store.heap[this.m32Store.hp++];
                        m32.a = mat[0][0];
                        m32.b = mat[0][1];
                        m32.c = mat[1][0];
                        m32.d = mat[1][1];
                        m32.e = mat[2][0];
                        m32.f = mat[2][1];
                        this.m32Store.stack[this.m32Store.sp++] = m32;
                        return;
                    }
                    case 3: {
                        M33Obj m33 = this.m33Store.heap[this.m33Store.hp++];
                        m33.a = mat[0][0];
                        m33.b = mat[0][1];
                        m33.c = mat[0][2];
                        m33.d = mat[1][0];
                        m33.e = mat[1][1];
                        m33.f = mat[1][2];
                        m33.g = mat[2][0];
                        m33.h = mat[2][1];
                        m33.i = mat[2][2];
                        this.m33Store.stack[this.m33Store.sp++] = m33;
                        return;
                    }
                    case 4: {
                        M34Obj m34 = this.m34Store.heap[this.m34Store.hp++];
                        m34.a = mat[0][0];
                        m34.b = mat[0][1];
                        m34.c = mat[0][2];
                        m34.d = mat[0][3];
                        m34.e = mat[1][0];
                        m34.f = mat[1][1];
                        m34.g = mat[1][2];
                        m34.h = mat[1][3];
                        m34.i = mat[2][0];
                        m34.j = mat[2][1];
                        m34.k = mat[2][2];
                        m34.l = mat[2][3];
                        this.m34Store.stack[this.m34Store.sp++] = m34;
                        return;
                    }
                }
                break;
            }
            case 4: {
                switch (mat[0].length) {
                    case 2: {
                        M42Obj m42 = this.m42Store.heap[this.m42Store.hp++];
                        m42.a = mat[0][0];
                        m42.b = mat[0][1];
                        m42.c = mat[1][0];
                        m42.d = mat[1][1];
                        m42.e = mat[2][0];
                        m42.f = mat[2][1];
                        m42.g = mat[3][0];
                        m42.h = mat[3][1];
                        this.m42Store.stack[this.m42Store.sp++] = m42;
                        return;
                    }
                    case 3: {
                        M43Obj m43 = this.m43Store.heap[this.m43Store.hp++];
                        m43.a = mat[0][0];
                        m43.b = mat[0][1];
                        m43.c = mat[0][2];
                        m43.d = mat[1][0];
                        m43.e = mat[1][1];
                        m43.f = mat[1][2];
                        m43.g = mat[2][0];
                        m43.h = mat[2][1];
                        m43.i = mat[2][2];
                        m43.j = mat[3][0];
                        m43.k = mat[3][1];
                        m43.l = mat[3][2];
                        this.m43Store.stack[this.m43Store.sp++] = m43;
                        return;
                    }
                    case 4: {
                        M44Obj m44 = this.m44Store.heap[this.m44Store.hp++];
                        m44.a = mat[0][0];
                        m44.b = mat[0][1];
                        m44.c = mat[0][2];
                        m44.d = mat[0][3];
                        m44.e = mat[1][0];
                        m44.f = mat[1][1];
                        m44.g = mat[1][2];
                        m44.h = mat[1][3];
                        m44.i = mat[2][0];
                        m44.j = mat[2][1];
                        m44.k = mat[2][2];
                        m44.l = mat[2][3];
                        m44.m = mat[3][0];
                        m44.n = mat[3][1];
                        m44.o = mat[3][2];
                        m44.p = mat[3][3];
                        this.m44Store.stack[this.m44Store.sp++] = m44;
                        return;
                    }
                }
            }
        }
        this.mnnStore.stack[this.mnnStore.sp++] = new MnnObj(mat);
    }

    private final void unitaryFunction(short fun) {
        double r = this.scalerStore.stack[--this.scalerStore.sp];
        switch (fun) {
            case 1: {
                r = Math.sin(r);
                break;
            }
            case 2: {
                r = Math.cos(r);
                break;
            }
            case 3: {
                r = Math.tan(r);
                break;
            }
            case 4: {
                r = Math.asin(r);
                break;
            }
            case 5: {
                r = Math.acos(r);
                break;
            }
            case 6: {
                r = Math.atan(r);
                break;
            }
            case 7: {
                r = (Math.exp(r) - Math.exp(-r)) / 2.0;
                break;
            }
            case 8: {
                r = (Math.exp(r) + Math.exp(-r)) / 2.0;
                break;
            }
            case 9: {
                double ex = Math.exp(r * 2.0);
                r = (ex - 1.0) / (ex + 1.0);
                break;
            }
            case 10: {
                r = Math.log(r + Math.sqrt(1.0 + r * r));
                break;
            }
            case 11: {
                r = Math.log(r + Math.sqrt(r * r - 1.0));
                break;
            }
            case 12: {
                r = Math.log((1.0 + r) / (1.0 - r)) / 2.0;
                break;
            }
            case 13: {
                r = Math.abs(r);
                break;
            }
            case 14: {
                r = Math.exp(r);
                break;
            }
            case 15: {
                r = Math.log(r) / LOG10;
                break;
            }
            case 16: {
                r = Math.log(r);
                break;
            }
            case 17: {
                r = Math.sqrt(r);
                break;
            }
            case 18: {
                r = 1.0 / Math.cos(r);
                break;
            }
            case 19: {
                r = 1.0 / Math.sin(r);
                break;
            }
            case 20: {
                r = 1.0 / Math.tan(r);
            }
        }
        this.scalerStore.stack[this.scalerStore.sp++] = r;
    }

    public void cleanUp() {
        this.scalerStore.cleanUp();
        this.v2Store.cleanUp();
        this.v3Store.cleanUp();
        this.v4Store.cleanUp();
        this.vnStore.cleanUp();
        this.m22Store.cleanUp();
        this.m23Store.cleanUp();
        this.m24Store.cleanUp();
        this.m32Store.cleanUp();
        this.m33Store.cleanUp();
        this.m34Store.cleanUp();
        this.m42Store.cleanUp();
        this.m43Store.cleanUp();
        this.m44Store.cleanUp();
        this.mnnStore.cleanUp();
    }

    private final class MnnStore
    extends MatStore {
        MnnObj[] stack;
        MnnObj[] vars;

        private MnnStore() {
            this.vars = new MnnObj[0];
        }

        @Override
        final void alloc() {
            this.stack = new MnnObj[this.stackMax];
        }

        @Override
        final void expandVarArray(MatrixVariableI var) {
            MnnObj[] newvars = new MnnObj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            Dimensions dims = var.getDimensions();
            newvars[this.vars.length] = new MnnObj(dims.getFirstDim(), dims.getLastDim());
            this.vars = newvars;
        }

        @Override
        final void copyVar(int i, Matrix mat) {
            this.vars[i].fromMat(mat);
        }

        @Override
        final void add() {
            MnnObj r = this.stack[--this.sp];
            MnnObj l = this.stack[--this.sp];
            MnnObj res = new MnnObj(l.rows, l.cols);
            for (int i = 0; i < l.rows; ++i) {
                for (int j = 0; j < l.cols; ++j) {
                    res.data[i][j] = l.data[i][j] + r.data[i][j];
                }
            }
            this.stack[this.sp++] = res;
        }

        @Override
        final void sub() {
            MnnObj r = this.stack[--this.sp];
            MnnObj l = this.stack[--this.sp];
            MnnObj res = new MnnObj(l.rows, l.cols);
            for (int i = 0; i < l.rows; ++i) {
                for (int j = 0; j < l.cols; ++j) {
                    res.data[i][j] = l.data[i][j] - r.data[i][j];
                }
            }
            this.stack[this.sp++] = res;
        }

        @Override
        final void uminus() {
            MnnObj r = this.stack[--this.sp];
            MnnObj res = new MnnObj(r.rows, r.cols);
            for (int i = 0; i < r.rows; ++i) {
                for (int j = 0; j < r.cols; ++j) {
                    res.data[i][j] = -r.data[i][j];
                }
            }
            this.stack[this.sp++] = res;
        }

        @Override
        final void mulS() {
            MnnObj r = this.stack[--this.sp];
            double l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            MnnObj res = new MnnObj(r.rows, r.cols);
            for (int i = 0; i < r.rows; ++i) {
                for (int j = 0; j < r.cols; ++j) {
                    res.data[i][j] = l * r.data[i][j];
                }
            }
            this.stack[this.sp++] = res;
        }

        final void divS() {
            MnnObj l = this.stack[--this.sp];
            double r = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            MnnObj res = new MnnObj(l.rows, l.cols);
            for (int i = 0; i < l.rows; ++i) {
                for (int j = 0; j < l.cols; ++j) {
                    res.data[i][j] = l.data[i][j] / r;
                }
            }
            this.stack[this.sp++] = res;
        }

        final void makeList(int rows, int cols) {
            MnnObj res = new MnnObj(rows, cols);
            for (int i = rows - 1; i >= 0; --i) {
                for (int j = cols - 1; j >= 0; --j) {
                    res.data[i][j] = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
                }
            }
            this.stack[this.sp++] = res;
        }

        @Override
        final void makeList() {
            throw new UnsupportedOperationException("VnObj: makeList cannot be called with no arguments");
        }

        @Override
        final void assign(int k) {
            MnnObj r = this.stack[this.sp - 1];
            MnnObj res = this.vars[k];
            for (int i = 0; i < r.rows; ++i) {
                for (int j = 0; j < r.cols; ++j) {
                    res.data[i][j] = r.data[i][j];
                }
            }
        }

        final void eq() {
            MnnObj r = this.stack[--this.sp];
            MnnObj l = this.stack[--this.sp];
            for (int i = 0; i < r.rows; ++i) {
                for (int j = 0; j < r.cols; ++j) {
                    if (l.data[i][j] == r.data[i][j]) continue;
                    MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = 0.0;
                    return;
                }
            }
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = 1.0;
        }
    }

    private static final class MnnObj
    extends MatObj {
        double[][] data;
        int rows;
        int cols;

        MnnObj(int row, int col) {
            this.data = new double[row][col];
            this.rows = row;
            this.cols = col;
        }

        MnnObj(double[][] mat) {
            this.data = mat;
            this.rows = mat.length;
            this.cols = mat[0].length;
        }

        @Override
        public Dimensions getDims() {
            return Dimensions.valueOf(this.rows, this.cols);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[");
            for (int i = 0; i < this.rows; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append('[');
                for (int j = 0; j < this.cols; ++j) {
                    if (j > 0) {
                        sb.append(',');
                    }
                    sb.append(this.data[i][j]);
                }
                sb.append(']');
            }
            sb.append(']');
            return sb.toString();
        }

        public void fromMat(Matrix val) {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.cols; ++j) {
                    this.data[i][j] = (Double)val.getEle(i, j);
                }
            }
        }

        @Override
        public void copyToMat(Matrix val) {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.cols; ++j) {
                    val.setEle(i, j, new Double(this.data[i][j]));
                }
            }
        }

        @Override
        double[][] toArrayMat() {
            return this.data;
        }

        @Override
        public Object toArray() {
            double[][] res = new double[this.rows][this.cols];
            for (int i = 0; i < this.rows; ++i) {
                System.arraycopy(this.data[i], 0, res[i], 0, this.cols);
            }
            return res;
        }
    }

    private final class M44Store
    extends MatStore {
        M44Obj[] stack;
        M44Obj[] heap;
        M44Obj[] vars;

        private M44Store() {
            this.vars = new M44Obj[0];
        }

        @Override
        final void alloc() {
            int i;
            this.heap = new M44Obj[this.hp];
            for (i = 0; i < this.hp; ++i) {
                this.heap[i] = new M44Obj();
            }
            this.stack = new M44Obj[this.stackMax];
            for (i = 0; i < this.stackMax; ++i) {
                this.stack[i] = new M44Obj();
            }
            M44Obj[] newvars = new M44Obj[this.varRefs.size()];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            for (int i2 = this.vars.length; i2 < this.varRefs.size(); ++i2) {
                newvars[i2] = new M44Obj();
            }
            this.vars = newvars;
        }

        @Override
        final void expandVarArray(MatrixVariableI var) {
            M44Obj[] newvars = new M44Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            newvars[this.vars.length] = new M44Obj();
            this.vars = newvars;
        }

        @Override
        final void copyVar(int i, Matrix val) {
            this.vars[i].fromMat(val);
        }

        @Override
        final void add() {
            M44Obj r = this.stack[--this.sp];
            M44Obj l = this.stack[--this.sp];
            M44Obj res = this.heap[this.hp++];
            res.a = l.a + r.a;
            res.b = l.b + r.b;
            res.c = l.c + r.c;
            res.d = l.d + r.d;
            res.e = l.e + r.e;
            res.f = l.f + r.f;
            res.g = l.g + r.g;
            res.h = l.h + r.h;
            res.i = l.i + r.i;
            res.j = l.j + r.j;
            res.k = l.k + r.k;
            res.l = l.l + r.l;
            res.m = l.m + r.m;
            res.n = l.n + r.n;
            res.o = l.o + r.o;
            res.p = l.p + r.p;
            this.stack[this.sp++] = res;
        }

        @Override
        final void sub() {
            M44Obj r = this.stack[--this.sp];
            M44Obj l = this.stack[--this.sp];
            M44Obj res = this.heap[this.hp++];
            res.a = l.a - r.a;
            res.b = l.b - r.b;
            res.c = l.c - r.c;
            res.d = l.d - r.d;
            res.e = l.e - r.e;
            res.f = l.f - r.f;
            res.g = l.g - r.g;
            res.h = l.h - r.h;
            res.i = l.i - r.i;
            res.j = l.j - r.j;
            res.k = l.k - r.k;
            res.l = l.l - r.l;
            res.m = l.m - r.m;
            res.n = l.n - r.n;
            res.o = l.o - r.o;
            res.p = l.p - r.p;
            this.stack[this.sp++] = res;
        }

        @Override
        final void uminus() {
            M44Obj r = this.stack[--this.sp];
            M44Obj res = this.heap[this.hp++];
            res.a = -r.a;
            res.b = -r.b;
            res.c = -r.c;
            res.d = -r.d;
            res.e = -r.e;
            res.f = -r.f;
            res.g = -r.g;
            res.h = -r.h;
            res.i = -r.i;
            res.j = -r.j;
            res.k = -r.k;
            res.l = -r.l;
            res.m = -r.m;
            res.n = -r.n;
            res.o = -r.o;
            res.p = -r.p;
            this.stack[this.sp++] = res;
        }

        @Override
        final void mulS() {
            M44Obj r = this.stack[--this.sp];
            double l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M44Obj res = this.heap[this.hp++];
            res.a = l * r.a;
            res.b = l * r.b;
            res.c = l * r.c;
            res.d = l * r.d;
            res.e = l * r.e;
            res.f = l * r.f;
            res.g = l * r.g;
            res.h = l * r.h;
            res.i = l * r.i;
            res.j = l * r.j;
            res.k = l * r.k;
            res.l = l * r.l;
            res.m = l * r.m;
            res.n = l * r.n;
            res.o = l * r.o;
            res.p = l * r.p;
            this.stack[this.sp++] = res;
        }

        final void divS() {
            M44Obj l = this.stack[--this.sp];
            double r = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M44Obj res = this.heap[this.hp++];
            res.a = l.a / r;
            res.b = l.b / r;
            res.c = l.c / r;
            res.d = l.d / r;
            res.e = l.e / r;
            res.f = l.f / r;
            res.g = l.g / r;
            res.h = l.h / r;
            res.i = l.i / r;
            res.j = l.j / r;
            res.k = l.k / r;
            res.l = l.l / r;
            res.m = l.m / r;
            res.n = l.n / r;
            res.o = l.o / r;
            res.p = l.p / r;
            this.stack[this.sp++] = res;
        }

        @Override
        final void makeList() {
            M44Obj res = this.heap[this.hp++];
            res.p = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.o = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.n = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.m = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.k = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.j = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.i = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.h = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.g = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = res;
        }

        @Override
        final void assign(int i) {
            M44Obj r = this.stack[this.sp - 1];
            M44Obj res = this.vars[i];
            res.a = r.a;
            res.b = r.b;
            res.c = r.c;
            res.d = r.d;
            res.e = r.e;
            res.f = r.f;
            res.g = r.g;
            res.h = r.h;
            res.i = r.i;
            res.j = r.j;
            res.k = r.k;
            res.l = r.l;
            res.m = r.m;
            res.n = r.n;
            res.o = r.o;
            res.p = r.p;
        }

        final void eq() {
            M44Obj r = this.stack[--this.sp];
            M44Obj l = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = l.a == r.a && l.b == r.b && l.c == r.c && l.d == r.d && l.e == r.e && l.f == r.f && l.g == r.g && l.h == r.h && l.i == r.i && l.j == r.j && l.k == r.k && l.l == r.l && l.m == r.m && l.n == r.n && l.o == r.o && l.p == r.p ? 1.0 : 0.0;
        }
    }

    private static final class M44Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        double g;
        double h;
        double i;
        double j;
        double k;
        double l;
        double m;
        double n;
        double o;
        double p;
        private static Dimensions dims = Dimensions.valueOf(4, 4);

        private M44Obj() {
        }

        @Override
        public Dimensions getDims() {
            return dims;
        }

        @Override
        public void copyToMat(Matrix val) {
            val.setEle(0, 0, new Double(this.a));
            val.setEle(0, 1, new Double(this.b));
            val.setEle(0, 2, new Double(this.c));
            val.setEle(0, 3, new Double(this.d));
            val.setEle(1, 0, new Double(this.e));
            val.setEle(1, 1, new Double(this.f));
            val.setEle(1, 2, new Double(this.g));
            val.setEle(1, 3, new Double(this.h));
            val.setEle(2, 0, new Double(this.i));
            val.setEle(2, 1, new Double(this.j));
            val.setEle(2, 2, new Double(this.k));
            val.setEle(2, 3, new Double(this.l));
            val.setEle(3, 0, new Double(this.m));
            val.setEle(3, 1, new Double(this.n));
            val.setEle(3, 2, new Double(this.o));
            val.setEle(3, 3, new Double(this.p));
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "," + this.c + "," + this.d + "],[" + this.e + "," + this.f + "," + this.g + "," + this.h + "],[" + this.i + "," + this.j + "," + this.k + "," + this.l + "],[" + this.m + "," + this.n + "," + this.o + "," + this.p + "]]";
        }

        final void fromMat(Matrix val) {
            this.a = (Double)val.getEle(0, 0);
            this.b = (Double)val.getEle(0, 1);
            this.c = (Double)val.getEle(0, 2);
            this.d = (Double)val.getEle(0, 3);
            this.e = (Double)val.getEle(1, 0);
            this.f = (Double)val.getEle(1, 1);
            this.g = (Double)val.getEle(1, 2);
            this.h = (Double)val.getEle(1, 3);
            this.i = (Double)val.getEle(2, 0);
            this.j = (Double)val.getEle(2, 1);
            this.k = (Double)val.getEle(2, 2);
            this.l = (Double)val.getEle(2, 3);
            this.m = (Double)val.getEle(3, 0);
            this.n = (Double)val.getEle(3, 1);
            this.o = (Double)val.getEle(3, 2);
            this.p = (Double)val.getEle(3, 3);
        }

        @Override
        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b, this.c, this.d}, {this.e, this.f, this.g, this.h}, {this.i, this.j, this.k, this.l}, {this.m, this.n, this.o, this.p}};
        }
    }

    private final class M43Store
    extends MatStore {
        M43Obj[] stack;
        M43Obj[] heap;
        M43Obj[] vars;

        private M43Store() {
            this.vars = new M43Obj[0];
        }

        @Override
        final void alloc() {
            int i;
            this.heap = new M43Obj[this.hp];
            for (i = 0; i < this.hp; ++i) {
                this.heap[i] = new M43Obj();
            }
            this.stack = new M43Obj[this.stackMax];
            for (i = 0; i < this.stackMax; ++i) {
                this.stack[i] = new M43Obj();
            }
        }

        @Override
        final void expandVarArray(MatrixVariableI var) {
            M43Obj[] newvars = new M43Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            newvars[this.vars.length] = new M43Obj();
            this.vars = newvars;
        }

        @Override
        final void copyVar(int i, Matrix val) {
            this.vars[i].fromMat(val);
        }

        @Override
        final void add() {
            M43Obj r = this.stack[--this.sp];
            M43Obj l = this.stack[--this.sp];
            M43Obj res = this.heap[this.hp++];
            res.a = l.a + r.a;
            res.b = l.b + r.b;
            res.c = l.c + r.c;
            res.d = l.d + r.d;
            res.e = l.e + r.e;
            res.f = l.f + r.f;
            res.g = l.g + r.g;
            res.h = l.h + r.h;
            res.i = l.i + r.i;
            res.j = l.j + r.j;
            res.k = l.k + r.k;
            res.l = l.l + r.l;
            this.stack[this.sp++] = res;
        }

        @Override
        final void sub() {
            M43Obj r = this.stack[--this.sp];
            M43Obj l = this.stack[--this.sp];
            M43Obj res = this.heap[this.hp++];
            res.a = l.a - r.a;
            res.b = l.b - r.b;
            res.c = l.c - r.c;
            res.d = l.d - r.d;
            res.e = l.e - r.e;
            res.f = l.f - r.f;
            res.g = l.g - r.g;
            res.h = l.h - r.h;
            res.i = l.i - r.i;
            res.j = l.j - r.j;
            res.k = l.k - r.k;
            res.l = l.l - r.l;
            this.stack[this.sp++] = res;
        }

        @Override
        final void uminus() {
            M43Obj r = this.stack[--this.sp];
            M43Obj res = this.heap[this.hp++];
            res.a = -r.a;
            res.b = -r.b;
            res.c = -r.c;
            res.d = -r.d;
            res.e = -r.e;
            res.f = -r.f;
            res.g = -r.g;
            res.h = -r.h;
            res.i = -r.i;
            res.j = -r.j;
            res.k = -r.k;
            res.l = -r.l;
            this.stack[this.sp++] = res;
        }

        @Override
        final void mulS() {
            M43Obj r = this.stack[--this.sp];
            double l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M43Obj res = this.heap[this.hp++];
            res.a = l * r.a;
            res.b = l * r.b;
            res.c = l * r.c;
            res.d = l * r.d;
            res.e = l * r.e;
            res.f = l * r.f;
            res.g = l * r.g;
            res.h = l * r.h;
            res.i = l * r.i;
            res.j = l * r.j;
            res.k = l * r.k;
            res.l = l * r.l;
            this.stack[this.sp++] = res;
        }

        final void divS() {
            M43Obj l = this.stack[--this.sp];
            double r = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M43Obj res = this.heap[this.hp++];
            res.a = l.a / r;
            res.b = l.b / r;
            res.c = l.c / r;
            res.d = l.d / r;
            res.e = l.e / r;
            res.f = l.f / r;
            res.g = l.g / r;
            res.h = l.h / r;
            res.i = l.i / r;
            res.j = l.j / r;
            res.k = l.k / r;
            res.l = l.l / r;
            this.stack[this.sp++] = res;
        }

        @Override
        final void makeList() {
            M43Obj res = this.heap[this.hp++];
            res.l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.k = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.j = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.i = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.h = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.g = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = res;
        }

        @Override
        final void assign(int i) {
            M43Obj r = this.stack[this.sp - 1];
            M43Obj res = this.vars[i];
            res.a = r.a;
            res.b = r.b;
            res.c = r.c;
            res.d = r.d;
            res.e = r.e;
            res.f = r.f;
            res.g = r.g;
            res.h = r.h;
            res.i = r.i;
            res.j = r.j;
            res.k = r.k;
            res.l = r.l;
        }

        final void eq() {
            M43Obj r = this.stack[--this.sp];
            M43Obj l = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = l.a == r.a && l.b == r.b && l.c == r.c && l.d == r.d && l.e == r.e && l.f == r.f && l.g == r.g && l.h == r.h && l.i == r.i && l.j == r.j && l.k == r.k && l.l == r.l ? 1.0 : 0.0;
        }
    }

    private static final class M43Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        double g;
        double h;
        double i;
        double j;
        double k;
        double l;
        private static Dimensions dims = Dimensions.valueOf(4, 3);

        private M43Obj() {
        }

        @Override
        public Dimensions getDims() {
            return dims;
        }

        @Override
        public void copyToMat(Matrix val) {
            val.setEle(0, 0, new Double(this.a));
            val.setEle(0, 1, new Double(this.b));
            val.setEle(0, 2, new Double(this.c));
            val.setEle(1, 0, new Double(this.d));
            val.setEle(1, 1, new Double(this.e));
            val.setEle(1, 2, new Double(this.f));
            val.setEle(2, 0, new Double(this.g));
            val.setEle(2, 1, new Double(this.h));
            val.setEle(2, 2, new Double(this.i));
            val.setEle(3, 0, new Double(this.j));
            val.setEle(3, 1, new Double(this.k));
            val.setEle(3, 2, new Double(this.l));
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "," + this.c + "],[" + this.d + "," + this.e + "," + this.f + "],[" + this.g + "," + this.h + "," + this.i + "],[" + this.j + "," + this.k + "," + this.l + "]]";
        }

        final void fromMat(Matrix val) {
            this.a = (Double)val.getEle(0, 0);
            this.b = (Double)val.getEle(0, 1);
            this.c = (Double)val.getEle(0, 2);
            this.d = (Double)val.getEle(1, 0);
            this.e = (Double)val.getEle(1, 1);
            this.f = (Double)val.getEle(1, 2);
            this.g = (Double)val.getEle(2, 0);
            this.h = (Double)val.getEle(2, 1);
            this.i = (Double)val.getEle(2, 2);
            this.j = (Double)val.getEle(3, 0);
            this.k = (Double)val.getEle(3, 1);
            this.l = (Double)val.getEle(3, 2);
        }

        @Override
        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b, this.c}, {this.d, this.e, this.f}, {this.g, this.h, this.i}, {this.j, this.k, this.l}};
        }
    }

    private final class M42Store
    extends MatStore {
        M42Obj[] stack;
        M42Obj[] heap;
        M42Obj[] vars;

        private M42Store() {
            this.vars = new M42Obj[0];
        }

        @Override
        final void alloc() {
            int i;
            this.heap = new M42Obj[this.hp];
            for (i = 0; i < this.hp; ++i) {
                this.heap[i] = new M42Obj();
            }
            this.stack = new M42Obj[this.stackMax];
            for (i = 0; i < this.stackMax; ++i) {
                this.stack[i] = new M42Obj();
            }
        }

        @Override
        final void expandVarArray(MatrixVariableI var) {
            M42Obj[] newvars = new M42Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            newvars[this.vars.length] = new M42Obj();
            this.vars = newvars;
        }

        @Override
        final void copyVar(int i, Matrix val) {
            this.vars[i].fromMat(val);
        }

        @Override
        final void add() {
            M42Obj r = this.stack[--this.sp];
            M42Obj l = this.stack[--this.sp];
            M42Obj res = this.heap[this.hp++];
            res.a = l.a + r.a;
            res.b = l.b + r.b;
            res.c = l.c + r.c;
            res.d = l.d + r.d;
            res.e = l.e + r.e;
            res.f = l.f + r.f;
            res.g = l.g + r.g;
            res.h = l.h + r.h;
            this.stack[this.sp++] = res;
        }

        @Override
        final void sub() {
            M42Obj r = this.stack[--this.sp];
            M42Obj l = this.stack[--this.sp];
            M42Obj res = this.heap[this.hp++];
            res.a = l.a - r.a;
            res.b = l.b - r.b;
            res.c = l.c - r.c;
            res.d = l.d - r.d;
            res.e = l.e - r.e;
            res.f = l.f - r.f;
            res.g = l.g - r.g;
            res.h = l.h - r.h;
            this.stack[this.sp++] = res;
        }

        @Override
        final void uminus() {
            M42Obj r = this.stack[--this.sp];
            M42Obj res = this.heap[this.hp++];
            res.a = -r.a;
            res.b = -r.b;
            res.c = -r.c;
            res.d = -r.d;
            res.e = -r.e;
            res.f = -r.f;
            res.g = -r.g;
            res.h = -r.h;
            this.stack[this.sp++] = res;
        }

        @Override
        final void mulS() {
            M42Obj r = this.stack[--this.sp];
            double l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M42Obj res = this.heap[this.hp++];
            res.a = l * r.a;
            res.b = l * r.b;
            res.c = l * r.c;
            res.d = l * r.d;
            res.e = l * r.e;
            res.f = l * r.f;
            res.g = l * r.g;
            res.h = l * r.h;
            this.stack[this.sp++] = res;
        }

        final void divS() {
            M42Obj l = this.stack[--this.sp];
            double r = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M42Obj res = this.heap[this.hp++];
            res.a = l.a / r;
            res.b = l.b / r;
            res.c = l.c / r;
            res.d = l.d / r;
            res.e = l.e / r;
            res.f = l.f / r;
            res.g = l.g / r;
            res.h = l.h / r;
            this.stack[this.sp++] = res;
        }

        @Override
        final void makeList() {
            M42Obj res = this.heap[this.hp++];
            res.h = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.g = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = res;
        }

        @Override
        final void assign(int i) {
            M42Obj r = this.stack[this.sp - 1];
            M42Obj res = this.vars[i];
            res.a = r.a;
            res.b = r.b;
            res.c = r.c;
            res.d = r.d;
            res.e = r.e;
            res.f = r.f;
            res.g = r.g;
            res.h = r.h;
        }

        final void eq() {
            M42Obj r = this.stack[--this.sp];
            M42Obj l = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = l.a == r.a && l.b == r.b && l.c == r.c && l.d == r.d && l.e == r.e && l.f == r.f && l.g == r.g && l.h == r.h ? 1.0 : 0.0;
        }
    }

    private static final class M42Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        double g;
        double h;
        private static Dimensions dims = Dimensions.valueOf(4, 2);

        private M42Obj() {
        }

        @Override
        public Dimensions getDims() {
            return dims;
        }

        @Override
        public void copyToMat(Matrix val) {
            val.setEle(0, 0, new Double(this.a));
            val.setEle(0, 1, new Double(this.b));
            val.setEle(1, 0, new Double(this.c));
            val.setEle(1, 1, new Double(this.d));
            val.setEle(2, 0, new Double(this.e));
            val.setEle(2, 1, new Double(this.f));
            val.setEle(3, 0, new Double(this.g));
            val.setEle(3, 1, new Double(this.h));
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "],[" + this.c + "," + this.d + "],[" + this.e + "," + this.f + "],[" + this.g + "," + this.h + "]]";
        }

        final void fromMat(Matrix val) {
            this.a = (Double)val.getEle(0, 0);
            this.b = (Double)val.getEle(0, 1);
            this.c = (Double)val.getEle(1, 0);
            this.d = (Double)val.getEle(1, 1);
            this.e = (Double)val.getEle(2, 0);
            this.f = (Double)val.getEle(2, 1);
            this.g = (Double)val.getEle(3, 0);
            this.h = (Double)val.getEle(3, 1);
        }

        @Override
        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b}, {this.c, this.d}, {this.e, this.f}, {this.g, this.h}};
        }
    }

    private final class M34Store
    extends MatStore {
        M34Obj[] stack;
        M34Obj[] heap;
        M34Obj[] vars;

        private M34Store() {
            this.vars = new M34Obj[0];
        }

        @Override
        final void alloc() {
            int i;
            this.heap = new M34Obj[this.hp];
            for (i = 0; i < this.hp; ++i) {
                this.heap[i] = new M34Obj();
            }
            this.stack = new M34Obj[this.stackMax];
            for (i = 0; i < this.stackMax; ++i) {
                this.stack[i] = new M34Obj();
            }
        }

        @Override
        final void expandVarArray(MatrixVariableI var) {
            M34Obj[] newvars = new M34Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            newvars[this.vars.length] = new M34Obj();
            this.vars = newvars;
        }

        @Override
        final void copyVar(int i, Matrix val) {
            this.vars[i].fromMat(val);
        }

        @Override
        final void add() {
            M34Obj r = this.stack[--this.sp];
            M34Obj l = this.stack[--this.sp];
            M34Obj res = this.heap[this.hp++];
            res.a = l.a + r.a;
            res.b = l.b + r.b;
            res.c = l.c + r.c;
            res.d = l.d + r.d;
            res.e = l.e + r.e;
            res.f = l.f + r.f;
            res.g = l.g + r.g;
            res.h = l.h + r.h;
            res.i = l.i + r.i;
            res.j = l.j + r.j;
            res.k = l.k + r.k;
            res.l = l.l + r.l;
            this.stack[this.sp++] = res;
        }

        @Override
        final void sub() {
            M34Obj r = this.stack[--this.sp];
            M34Obj l = this.stack[--this.sp];
            M34Obj res = this.heap[this.hp++];
            res.a = l.a - r.a;
            res.b = l.b - r.b;
            res.c = l.c - r.c;
            res.d = l.d - r.d;
            res.e = l.e - r.e;
            res.f = l.f - r.f;
            res.g = l.g - r.g;
            res.h = l.h - r.h;
            res.i = l.i - r.i;
            res.j = l.j - r.j;
            res.k = l.k - r.k;
            res.l = l.l - r.l;
            this.stack[this.sp++] = res;
        }

        @Override
        final void uminus() {
            M34Obj r = this.stack[--this.sp];
            M34Obj res = this.heap[this.hp++];
            res.a = -r.a;
            res.b = -r.b;
            res.c = -r.c;
            res.d = -r.d;
            res.e = -r.e;
            res.f = -r.f;
            res.g = -r.g;
            res.h = -r.h;
            res.i = -r.i;
            res.j = -r.j;
            res.k = -r.k;
            res.l = -r.l;
            this.stack[this.sp++] = res;
        }

        @Override
        final void mulS() {
            M34Obj r = this.stack[--this.sp];
            double l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M34Obj res = this.heap[this.hp++];
            res.a = l * r.a;
            res.b = l * r.b;
            res.c = l * r.c;
            res.d = l * r.d;
            res.e = l * r.e;
            res.f = l * r.f;
            res.g = l * r.g;
            res.h = l * r.h;
            res.i = l * r.i;
            res.j = l * r.j;
            res.k = l * r.k;
            res.l = l * r.l;
            this.stack[this.sp++] = res;
        }

        final void divS() {
            M34Obj l = this.stack[--this.sp];
            double r = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M34Obj res = this.heap[this.hp++];
            res.a = l.a / r;
            res.b = l.b / r;
            res.c = l.c / r;
            res.d = l.d / r;
            res.e = l.e / r;
            res.f = l.f / r;
            res.g = l.g / r;
            res.h = l.h / r;
            res.i = l.i / r;
            res.j = l.j / r;
            res.k = l.k / r;
            res.l = l.l / r;
            this.stack[this.sp++] = res;
        }

        @Override
        final void makeList() {
            M34Obj res = this.heap[this.hp++];
            res.l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.k = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.j = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.i = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.h = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.g = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = res;
        }

        @Override
        final void assign(int i) {
            M34Obj r = this.stack[this.sp - 1];
            M34Obj res = this.vars[i];
            res.a = r.a;
            res.b = r.b;
            res.c = r.c;
            res.d = r.d;
            res.e = r.e;
            res.f = r.f;
            res.g = r.g;
            res.h = r.h;
            res.i = r.i;
            res.j = r.j;
            res.k = r.k;
            res.l = r.l;
        }

        final void eq() {
            M34Obj r = this.stack[--this.sp];
            M34Obj l = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = l.a == r.a && l.b == r.b && l.c == r.c && l.d == r.d && l.e == r.e && l.f == r.f && l.g == r.g && l.h == r.h && l.i == r.i && l.j == r.j && l.k == r.k && l.l == r.l ? 1.0 : 0.0;
        }
    }

    private static final class M34Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        double g;
        double h;
        double i;
        double j;
        double k;
        double l;
        private static Dimensions dims = Dimensions.valueOf(3, 4);

        private M34Obj() {
        }

        @Override
        public Dimensions getDims() {
            return dims;
        }

        @Override
        public void copyToMat(Matrix val) {
            val.setEle(0, 0, new Double(this.a));
            val.setEle(0, 1, new Double(this.b));
            val.setEle(0, 2, new Double(this.c));
            val.setEle(0, 3, new Double(this.d));
            val.setEle(1, 0, new Double(this.e));
            val.setEle(1, 1, new Double(this.f));
            val.setEle(1, 2, new Double(this.g));
            val.setEle(1, 3, new Double(this.h));
            val.setEle(2, 0, new Double(this.i));
            val.setEle(2, 1, new Double(this.j));
            val.setEle(2, 2, new Double(this.k));
            val.setEle(2, 3, new Double(this.l));
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "," + this.c + "," + this.d + "],[" + this.e + "," + this.f + "," + this.g + "," + this.h + "],[" + this.i + "," + this.j + "," + this.k + "," + this.l + "]]";
        }

        final void fromMat(Matrix val) {
            this.a = (Double)val.getEle(0, 0);
            this.b = (Double)val.getEle(0, 1);
            this.c = (Double)val.getEle(0, 2);
            this.d = (Double)val.getEle(0, 3);
            this.e = (Double)val.getEle(1, 0);
            this.f = (Double)val.getEle(1, 1);
            this.g = (Double)val.getEle(1, 2);
            this.h = (Double)val.getEle(1, 3);
            this.i = (Double)val.getEle(2, 0);
            this.j = (Double)val.getEle(2, 1);
            this.k = (Double)val.getEle(2, 2);
            this.l = (Double)val.getEle(2, 3);
        }

        @Override
        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b, this.c, this.d}, {this.e, this.f, this.g, this.h}, {this.i, this.j, this.k, this.l}};
        }
    }

    private final class M33Store
    extends MatStore {
        M33Obj[] stack;
        M33Obj[] heap;
        M33Obj[] vars;

        private M33Store() {
            this.vars = new M33Obj[0];
        }

        @Override
        final void alloc() {
            int i;
            this.heap = new M33Obj[this.hp];
            for (i = 0; i < this.hp; ++i) {
                this.heap[i] = new M33Obj();
            }
            this.stack = new M33Obj[this.stackMax];
            for (i = 0; i < this.stackMax; ++i) {
                this.stack[i] = new M33Obj();
            }
        }

        @Override
        final void expandVarArray(MatrixVariableI var) {
            M33Obj[] newvars = new M33Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            newvars[this.vars.length] = new M33Obj();
            this.vars = newvars;
        }

        @Override
        final void copyVar(int i, Matrix val) {
            this.vars[i].fromMat(val);
        }

        @Override
        final void add() {
            M33Obj r = this.stack[--this.sp];
            M33Obj l = this.stack[--this.sp];
            M33Obj res = this.heap[this.hp++];
            res.a = l.a + r.a;
            res.b = l.b + r.b;
            res.c = l.c + r.c;
            res.d = l.d + r.d;
            res.e = l.e + r.e;
            res.f = l.f + r.f;
            res.g = l.g + r.g;
            res.h = l.h + r.h;
            res.i = l.i + r.i;
            this.stack[this.sp++] = res;
        }

        @Override
        final void sub() {
            M33Obj r = this.stack[--this.sp];
            M33Obj l = this.stack[--this.sp];
            M33Obj res = this.heap[this.hp++];
            res.a = l.a - r.a;
            res.b = l.b - r.b;
            res.c = l.c - r.c;
            res.d = l.d - r.d;
            res.e = l.e - r.e;
            res.f = l.f - r.f;
            res.g = l.g - r.g;
            res.h = l.h - r.h;
            res.i = l.i - r.i;
            this.stack[this.sp++] = res;
        }

        @Override
        final void uminus() {
            M33Obj r = this.stack[--this.sp];
            M33Obj res = this.heap[this.hp++];
            res.a = -r.a;
            res.b = -r.b;
            res.c = -r.c;
            res.d = -r.d;
            res.e = -r.e;
            res.f = -r.f;
            res.g = -r.g;
            res.h = -r.h;
            res.i = -r.i;
            this.stack[this.sp++] = res;
        }

        @Override
        final void mulS() {
            M33Obj r = this.stack[--this.sp];
            double l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M33Obj res = this.heap[this.hp++];
            res.a = l * r.a;
            res.b = l * r.b;
            res.c = l * r.c;
            res.d = l * r.d;
            res.e = l * r.e;
            res.f = l * r.f;
            res.g = l * r.g;
            res.h = l * r.h;
            res.i = l * r.i;
            this.stack[this.sp++] = res;
        }

        final void divS() {
            M33Obj l = this.stack[--this.sp];
            double r = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M33Obj res = this.heap[this.hp++];
            res.a = l.a / r;
            res.b = l.b / r;
            res.c = l.c / r;
            res.d = l.d / r;
            res.e = l.e / r;
            res.f = l.f / r;
            res.g = l.g / r;
            res.h = l.h / r;
            res.i = l.i / r;
            this.stack[this.sp++] = res;
        }

        @Override
        final void makeList() {
            M33Obj res = this.heap[this.hp++];
            res.i = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.h = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.g = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = res;
        }

        @Override
        final void assign(int i) {
            M33Obj r = this.stack[this.sp - 1];
            M33Obj res = this.vars[i];
            res.a = r.a;
            res.b = r.b;
            res.c = r.c;
            res.d = r.d;
            res.e = r.e;
            res.f = r.f;
            res.g = r.g;
            res.h = r.h;
            res.i = r.i;
        }

        final void eq() {
            M33Obj r = this.stack[--this.sp];
            M33Obj l = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = l.a == r.a && l.b == r.b && l.c == r.c && l.d == r.d && l.e == r.e && l.f == r.f && l.g == r.g && l.h == r.h && l.i == r.i ? 1.0 : 0.0;
        }
    }

    private static final class M33Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        double g;
        double h;
        double i;
        static Dimensions dims = Dimensions.valueOf(3, 3);

        private M33Obj() {
        }

        @Override
        public Dimensions getDims() {
            return dims;
        }

        @Override
        public void copyToMat(Matrix val) {
            val.setEle(0, 0, new Double(this.a));
            val.setEle(0, 1, new Double(this.b));
            val.setEle(0, 2, new Double(this.c));
            val.setEle(1, 0, new Double(this.d));
            val.setEle(1, 1, new Double(this.e));
            val.setEle(1, 2, new Double(this.f));
            val.setEle(2, 0, new Double(this.g));
            val.setEle(2, 1, new Double(this.h));
            val.setEle(2, 2, new Double(this.i));
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "," + this.c + "],[" + this.d + "," + this.e + "," + this.f + "],[" + this.g + "," + this.h + "," + this.i + "]]";
        }

        final void fromMat(Matrix val) {
            this.a = (Double)val.getEle(0, 0);
            this.b = (Double)val.getEle(0, 1);
            this.c = (Double)val.getEle(0, 2);
            this.d = (Double)val.getEle(1, 0);
            this.e = (Double)val.getEle(1, 1);
            this.f = (Double)val.getEle(1, 2);
            this.g = (Double)val.getEle(2, 0);
            this.h = (Double)val.getEle(2, 1);
            this.i = (Double)val.getEle(2, 2);
        }

        @Override
        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b, this.c}, {this.d, this.e, this.f}, {this.g, this.h, this.i}};
        }
    }

    private final class M32Store
    extends MatStore {
        M32Obj[] stack;
        M32Obj[] heap;
        M32Obj[] vars;

        private M32Store() {
            this.vars = new M32Obj[0];
        }

        @Override
        final void alloc() {
            int i;
            this.heap = new M32Obj[this.hp];
            for (i = 0; i < this.hp; ++i) {
                this.heap[i] = new M32Obj();
            }
            this.stack = new M32Obj[this.stackMax];
            for (i = 0; i < this.stackMax; ++i) {
                this.stack[i] = new M32Obj();
            }
        }

        @Override
        final void expandVarArray(MatrixVariableI var) {
            M32Obj[] newvars = new M32Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            newvars[this.vars.length] = new M32Obj();
            this.vars = newvars;
        }

        @Override
        final void copyVar(int i, Matrix val) {
            this.vars[i].fromMat(val);
        }

        @Override
        final void add() {
            M32Obj r = this.stack[--this.sp];
            M32Obj l = this.stack[--this.sp];
            M32Obj res = this.heap[this.hp++];
            res.a = l.a + r.a;
            res.b = l.b + r.b;
            res.c = l.c + r.c;
            res.d = l.d + r.d;
            res.e = l.e + r.e;
            res.f = l.f + r.f;
            this.stack[this.sp++] = res;
        }

        @Override
        final void sub() {
            M32Obj r = this.stack[--this.sp];
            M32Obj l = this.stack[--this.sp];
            M32Obj res = this.heap[this.hp++];
            res.a = l.a - r.a;
            res.b = l.b - r.b;
            res.c = l.c - r.c;
            res.d = l.d - r.d;
            res.e = l.e - r.e;
            res.f = l.f - r.f;
            this.stack[this.sp++] = res;
        }

        @Override
        final void uminus() {
            M32Obj r = this.stack[--this.sp];
            M32Obj res = this.heap[this.hp++];
            res.a = -r.a;
            res.b = -r.b;
            res.c = -r.c;
            res.d = -r.d;
            res.e = -r.e;
            res.f = -r.f;
            this.stack[this.sp++] = res;
        }

        @Override
        final void mulS() {
            M32Obj r = this.stack[--this.sp];
            double l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M32Obj res = this.heap[this.hp++];
            res.a = l * r.a;
            res.b = l * r.b;
            res.c = l * r.c;
            res.d = l * r.d;
            res.e = l * r.e;
            res.f = l * r.f;
            this.stack[this.sp++] = res;
        }

        final void divS() {
            M32Obj l = this.stack[--this.sp];
            double r = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M32Obj res = this.heap[this.hp++];
            res.a = l.a / r;
            res.b = l.b / r;
            res.c = l.c / r;
            res.d = l.d / r;
            res.e = l.e / r;
            res.f = l.f / r;
            this.stack[this.sp++] = res;
        }

        @Override
        final void makeList() {
            M32Obj res = this.heap[this.hp++];
            res.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = res;
        }

        @Override
        final void assign(int i) {
            M32Obj r = this.stack[this.sp - 1];
            M32Obj res = this.vars[i];
            res.a = r.a;
            res.b = r.b;
            res.c = r.c;
            res.d = r.d;
            res.e = r.e;
            res.f = r.f;
        }

        final void eq() {
            M32Obj r = this.stack[--this.sp];
            M32Obj l = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = l.a == r.a && l.b == r.b && l.c == r.c && l.d == r.d && l.e == r.e && l.f == r.f ? 1.0 : 0.0;
        }
    }

    private static final class M32Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        static Dimensions dims = Dimensions.valueOf(3, 2);

        private M32Obj() {
        }

        @Override
        public Dimensions getDims() {
            return dims;
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "],[" + this.c + "," + this.d + "],[" + this.e + "," + this.f + "]]";
        }

        final void fromMat(Matrix val) {
            this.a = (Double)val.getEle(0, 0);
            this.b = (Double)val.getEle(0, 1);
            this.c = (Double)val.getEle(1, 0);
            this.d = (Double)val.getEle(1, 1);
            this.e = (Double)val.getEle(2, 0);
            this.f = (Double)val.getEle(2, 1);
        }

        @Override
        public void copyToMat(Matrix val) {
            val.setEle(0, 0, new Double(this.a));
            val.setEle(0, 1, new Double(this.b));
            val.setEle(1, 0, new Double(this.c));
            val.setEle(1, 1, new Double(this.d));
            val.setEle(2, 0, new Double(this.e));
            val.setEle(2, 1, new Double(this.f));
        }

        @Override
        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b}, {this.c, this.d}, {this.e, this.f}};
        }
    }

    private final class M24Store
    extends MatStore {
        M24Obj[] stack;
        M24Obj[] heap;
        M24Obj[] vars;

        private M24Store() {
            this.vars = new M24Obj[0];
        }

        @Override
        final void alloc() {
            int i;
            this.heap = new M24Obj[this.hp];
            for (i = 0; i < this.hp; ++i) {
                this.heap[i] = new M24Obj();
            }
            this.stack = new M24Obj[this.stackMax];
            for (i = 0; i < this.stackMax; ++i) {
                this.stack[i] = new M24Obj();
            }
        }

        @Override
        final void expandVarArray(MatrixVariableI var) {
            M24Obj[] newvars = new M24Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            newvars[this.vars.length] = new M24Obj();
            this.vars = newvars;
        }

        @Override
        final void copyVar(int i, Matrix val) {
            this.vars[i].fromMat(val);
        }

        @Override
        final void add() {
            M24Obj r = this.stack[--this.sp];
            M24Obj l = this.stack[--this.sp];
            M24Obj res = this.heap[this.hp++];
            res.a = l.a + r.a;
            res.b = l.b + r.b;
            res.c = l.c + r.c;
            res.d = l.d + r.d;
            res.e = l.e + r.e;
            res.f = l.f + r.f;
            res.g = l.g + r.g;
            res.h = l.h + r.h;
            this.stack[this.sp++] = res;
        }

        @Override
        final void sub() {
            M24Obj r = this.stack[--this.sp];
            M24Obj l = this.stack[--this.sp];
            M24Obj res = this.heap[this.hp++];
            res.a = l.a - r.a;
            res.b = l.b - r.b;
            res.c = l.c - r.c;
            res.d = l.d - r.d;
            res.e = l.e - r.e;
            res.f = l.f - r.f;
            res.g = l.g - r.g;
            res.h = l.h - r.h;
            this.stack[this.sp++] = res;
        }

        @Override
        final void uminus() {
            M24Obj r = this.stack[--this.sp];
            M24Obj res = this.heap[this.hp++];
            res.a = -r.a;
            res.b = -r.b;
            res.c = -r.c;
            res.d = -r.d;
            res.e = -r.e;
            res.f = -r.f;
            res.g = -r.g;
            res.h = -r.h;
            this.stack[this.sp++] = res;
        }

        @Override
        final void mulS() {
            M24Obj r = this.stack[--this.sp];
            double l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M24Obj res = this.heap[this.hp++];
            res.a = l * r.a;
            res.b = l * r.b;
            res.c = l * r.c;
            res.d = l * r.d;
            res.e = l * r.e;
            res.f = l * r.f;
            res.g = l * r.g;
            res.h = l * r.h;
            this.stack[this.sp++] = res;
        }

        final void divS() {
            M24Obj l = this.stack[--this.sp];
            double r = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M24Obj res = this.heap[this.hp++];
            res.a = l.a / r;
            res.b = l.b / r;
            res.c = l.c / r;
            res.d = l.d / r;
            res.e = l.e / r;
            res.f = l.f / r;
            res.g = l.g / r;
            res.h = l.h / r;
            this.stack[this.sp++] = res;
        }

        @Override
        final void makeList() {
            M24Obj res = this.heap[this.hp++];
            res.h = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.g = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = res;
        }

        @Override
        final void assign(int i) {
            M24Obj r = this.stack[this.sp - 1];
            M24Obj res = this.vars[i];
            res.a = r.a;
            res.b = r.b;
            res.c = r.c;
            res.d = r.d;
            res.e = r.e;
            res.f = r.f;
            res.g = r.g;
            res.h = r.h;
        }

        final void eq() {
            M24Obj r = this.stack[--this.sp];
            M24Obj l = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = l.a == r.a && l.b == r.b && l.c == r.c && l.d == r.d && l.e == r.e && l.f == r.f && l.g == r.g && l.h == r.h ? 1.0 : 0.0;
        }
    }

    private static final class M24Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        double g;
        double h;
        static Dimensions dims = Dimensions.valueOf(2, 4);

        private M24Obj() {
        }

        @Override
        public Dimensions getDims() {
            return dims;
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "," + this.c + "," + this.d + "],[" + this.e + "," + this.f + "," + this.g + "," + this.h + "]]";
        }

        final void fromMat(Matrix val) {
            this.a = (Double)val.getEle(0, 0);
            this.b = (Double)val.getEle(0, 1);
            this.c = (Double)val.getEle(0, 2);
            this.d = (Double)val.getEle(0, 3);
            this.e = (Double)val.getEle(1, 0);
            this.f = (Double)val.getEle(1, 1);
            this.g = (Double)val.getEle(1, 2);
            this.h = (Double)val.getEle(1, 3);
        }

        @Override
        public void copyToMat(Matrix val) {
            val.setEle(0, 0, new Double(this.a));
            val.setEle(0, 1, new Double(this.b));
            val.setEle(0, 2, new Double(this.c));
            val.setEle(0, 3, new Double(this.d));
            val.setEle(1, 0, new Double(this.e));
            val.setEle(1, 1, new Double(this.f));
            val.setEle(1, 2, new Double(this.g));
            val.setEle(1, 3, new Double(this.h));
        }

        @Override
        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b, this.c, this.d}, {this.e, this.f, this.g, this.h}};
        }
    }

    private final class M23Store
    extends MatStore {
        M23Obj[] stack;
        M23Obj[] heap;
        M23Obj[] vars;

        private M23Store() {
            this.vars = new M23Obj[0];
        }

        @Override
        final void alloc() {
            int i;
            this.heap = new M23Obj[this.hp];
            for (i = 0; i < this.hp; ++i) {
                this.heap[i] = new M23Obj();
            }
            this.stack = new M23Obj[this.stackMax];
            for (i = 0; i < this.stackMax; ++i) {
                this.stack[i] = new M23Obj();
            }
        }

        @Override
        final void expandVarArray(MatrixVariableI var) {
            M23Obj[] newvars = new M23Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            newvars[this.vars.length] = new M23Obj();
            this.vars = newvars;
        }

        @Override
        final void copyVar(int i, Matrix val) {
            this.vars[i].fromMat(val);
        }

        @Override
        final void add() {
            M23Obj r = this.stack[--this.sp];
            M23Obj l = this.stack[--this.sp];
            M23Obj res = this.heap[this.hp++];
            res.a = l.a + r.a;
            res.b = l.b + r.b;
            res.c = l.c + r.c;
            res.d = l.d + r.d;
            res.e = l.e + r.e;
            res.f = l.f + r.f;
            this.stack[this.sp++] = res;
        }

        @Override
        final void sub() {
            M23Obj r = this.stack[--this.sp];
            M23Obj l = this.stack[--this.sp];
            M23Obj res = this.heap[this.hp++];
            res.a = l.a - r.a;
            res.b = l.b - r.b;
            res.c = l.c - r.c;
            res.d = l.d - r.d;
            res.e = l.e - r.e;
            res.f = l.f - r.f;
            this.stack[this.sp++] = res;
        }

        @Override
        final void uminus() {
            M23Obj r = this.stack[--this.sp];
            M23Obj res = this.heap[this.hp++];
            res.a = -r.a;
            res.b = -r.b;
            res.c = -r.c;
            res.d = -r.d;
            res.e = -r.e;
            res.f = -r.f;
            this.stack[this.sp++] = res;
        }

        @Override
        final void mulS() {
            M23Obj r = this.stack[--this.sp];
            double l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M23Obj res = this.heap[this.hp++];
            res.a = l * r.a;
            res.b = l * r.b;
            res.c = l * r.c;
            res.d = l * r.d;
            res.e = l * r.e;
            res.f = l * r.f;
            this.stack[this.sp++] = res;
        }

        final void divS() {
            M23Obj l = this.stack[--this.sp];
            double r = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M23Obj res = this.heap[this.hp++];
            res.a = l.a / r;
            res.b = l.b / r;
            res.c = l.c / r;
            res.d = l.d / r;
            res.e = l.e / r;
            res.f = l.f / r;
            this.stack[this.sp++] = res;
        }

        @Override
        final void makeList() {
            M23Obj res = this.heap[this.hp++];
            res.f = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.e = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = res;
        }

        @Override
        final void assign(int i) {
            M23Obj r = this.stack[this.sp - 1];
            M23Obj res = this.vars[i];
            res.a = r.a;
            res.b = r.b;
            res.c = r.c;
            res.d = r.d;
            res.e = r.e;
            res.f = r.f;
        }

        final void eq() {
            M23Obj r = this.stack[--this.sp];
            M23Obj l = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = l.a == r.a && l.b == r.b && l.c == r.c && l.d == r.d && l.e == r.e && l.f == r.f ? 1.0 : 0.0;
        }
    }

    private static final class M23Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        double e;
        double f;
        static Dimensions dims = Dimensions.valueOf(2, 3);

        private M23Obj() {
        }

        @Override
        public Dimensions getDims() {
            return dims;
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "," + this.c + "],[" + this.d + "," + this.e + "," + this.f + "]]";
        }

        final void fromMat(Matrix val) {
            this.a = (Double)val.getEle(0, 0);
            this.b = (Double)val.getEle(0, 1);
            this.c = (Double)val.getEle(0, 2);
            this.d = (Double)val.getEle(1, 0);
            this.e = (Double)val.getEle(1, 1);
            this.f = (Double)val.getEle(1, 2);
        }

        @Override
        public void copyToMat(Matrix val) {
            val.setEle(0, 0, new Double(this.a));
            val.setEle(0, 1, new Double(this.b));
            val.setEle(0, 2, new Double(this.c));
            val.setEle(1, 0, new Double(this.d));
            val.setEle(1, 1, new Double(this.e));
            val.setEle(1, 2, new Double(this.f));
        }

        @Override
        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b, this.c}, {this.d, this.e, this.f}};
        }
    }

    private final class M22Store
    extends MatStore {
        M22Obj[] stack;
        M22Obj[] heap;
        M22Obj[] vars;

        private M22Store() {
            this.vars = new M22Obj[0];
        }

        @Override
        final void alloc() {
            int i;
            this.heap = new M22Obj[this.hp];
            for (i = 0; i < this.hp; ++i) {
                this.heap[i] = new M22Obj();
            }
            this.stack = new M22Obj[this.stackMax];
            for (i = 0; i < this.stackMax; ++i) {
                this.stack[i] = new M22Obj();
            }
        }

        @Override
        final void expandVarArray(MatrixVariableI var) {
            M22Obj[] newvars = new M22Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            newvars[this.vars.length] = new M22Obj();
            this.vars = newvars;
        }

        @Override
        final void copyVar(int i, Matrix val) {
            this.vars[i].fromMat(val);
        }

        @Override
        final void add() {
            M22Obj r = this.stack[--this.sp];
            M22Obj l = this.stack[--this.sp];
            M22Obj res = this.heap[this.hp++];
            res.a = l.a + r.a;
            res.b = l.b + r.b;
            res.c = l.c + r.c;
            res.d = l.d + r.d;
            this.stack[this.sp++] = res;
        }

        @Override
        final void sub() {
            M22Obj r = this.stack[--this.sp];
            M22Obj l = this.stack[--this.sp];
            M22Obj res = this.heap[this.hp++];
            res.a = l.a - r.a;
            res.b = l.b - r.b;
            res.c = l.c - r.c;
            res.d = l.d - r.d;
            this.stack[this.sp++] = res;
        }

        @Override
        final void uminus() {
            M22Obj r = this.stack[--this.sp];
            M22Obj res = this.heap[this.hp++];
            res.a = -r.a;
            res.b = -r.b;
            res.c = -r.c;
            res.d = -r.d;
            this.stack[this.sp++] = res;
        }

        @Override
        final void mulS() {
            M22Obj r = this.stack[--this.sp];
            double l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M22Obj res = this.heap[this.hp++];
            res.a = l * r.a;
            res.b = l * r.b;
            res.c = l * r.c;
            res.d = l * r.d;
            this.stack[this.sp++] = res;
        }

        final void divS() {
            M22Obj l = this.stack[--this.sp];
            double r = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            M22Obj res = this.heap[this.hp++];
            res.a = l.a / r;
            res.b = l.b / r;
            res.c = l.c / r;
            res.d = l.d / r;
            this.stack[this.sp++] = res;
        }

        @Override
        final void assign(int i) {
            M22Obj r = this.stack[--this.sp];
            ++this.sp;
            M22Obj res = this.vars[i];
            res.a = r.a;
            res.b = r.b;
            res.c = r.c;
            res.d = r.d;
        }

        @Override
        final void makeList() {
            M22Obj res = this.heap[this.hp++];
            res.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = res;
        }

        final void eq() {
            M22Obj r = this.stack[--this.sp];
            M22Obj l = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = l.a == r.a && l.b == r.b && l.c == r.c && l.d == r.d ? 1.0 : 0.0;
        }
    }

    private static final class M22Obj
    extends MatObj {
        double a;
        double b;
        double c;
        double d;
        static Dimensions dims = Dimensions.valueOf(2, 2);

        private M22Obj() {
        }

        @Override
        public Dimensions getDims() {
            return dims;
        }

        public String toString() {
            return "[[" + this.a + "," + this.b + "],[" + this.c + "," + this.d + "]]";
        }

        public void fromMat(Matrix val) {
            this.a = (Double)val.getEle(0, 0);
            this.b = (Double)val.getEle(0, 1);
            this.c = (Double)val.getEle(1, 0);
            this.d = (Double)val.getEle(1, 1);
        }

        @Override
        public void copyToMat(Matrix val) {
            val.setEle(0, 0, new Double(this.a));
            val.setEle(0, 1, new Double(this.b));
            val.setEle(1, 0, new Double(this.c));
            val.setEle(1, 1, new Double(this.d));
        }

        @Override
        public double[][] toArrayMat() {
            return new double[][]{{this.a, this.b}, {this.c, this.d}};
        }
    }

    private static abstract class MatStore
    extends ObjStore {
        private MatStore() {
        }

        abstract void copyVar(int var1, Matrix var2);

        @Override
        final void copyFromVar(MatrixVariableI var, int i) {
            if (var.hasValidValue()) {
                Matrix val = (Matrix)((MatrixVariable)var).getMValue();
                this.copyVar(i, val);
            }
        }

        @Override
        public final void setVarValue(int ref, MatrixValueI val) {
            this.copyVar(ref, (Matrix)val);
        }
    }

    private final class VnStore
    extends VecStore {
        VnObj[] stack;
        VnObj[] vars;

        private VnStore() {
            this.vars = new VnObj[0];
        }

        @Override
        final void alloc() {
            this.stack = new VnObj[this.stackMax];
        }

        @Override
        final void expandVarArray(MatrixVariableI var) {
            VnObj[] newvars = new VnObj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            newvars[this.vars.length] = new VnObj(var.getDimensions().getFirstDim());
            this.vars = newvars;
        }

        @Override
        final void copyVar(int i, MVector vec) {
            this.vars[i].fromVec(vec);
        }

        @Override
        final void add() {
            VnObj r = this.stack[--this.sp];
            VnObj l = this.stack[--this.sp];
            VnObj res = new VnObj(l.data.length);
            for (int i = 0; i < l.data.length; ++i) {
                res.data[i] = l.data[i] + r.data[i];
            }
            this.stack[this.sp++] = res;
        }

        @Override
        final void sub() {
            VnObj r = this.stack[--this.sp];
            VnObj l = this.stack[--this.sp];
            VnObj res = new VnObj(l.data.length);
            for (int i = 0; i < l.data.length; ++i) {
                res.data[i] = l.data[i] - r.data[i];
            }
            this.stack[this.sp++] = res;
        }

        @Override
        final void uminus() {
            VnObj r = this.stack[--this.sp];
            VnObj res = new VnObj(r.data.length);
            for (int i = 0; i < r.data.length; ++i) {
                res.data[i] = -r.data[i];
            }
            this.stack[this.sp++] = res;
        }

        @Override
        final void mulS() {
            VnObj r = this.stack[--this.sp];
            double l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            VnObj res = new VnObj(r.data.length);
            for (int i = 0; i < r.data.length; ++i) {
                res.data[i] = l * r.data[i];
            }
            this.stack[this.sp++] = res;
        }

        final void divS() {
            VnObj l = this.stack[--this.sp];
            double r = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            VnObj res = new VnObj(l.data.length);
            for (int i = 0; i < l.data.length; ++i) {
                res.data[i] = l.data[i] / r;
            }
            this.stack[this.sp++] = res;
        }

        final void makeList(int num) {
            VnObj res = new VnObj(num);
            for (int i = num - 1; i >= 0; --i) {
                res.data[i] = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            }
            this.stack[this.sp++] = res;
        }

        @Override
        final void makeList() {
            throw new UnsupportedOperationException("VnObj: makeList cannot be called with no arguments");
        }

        @Override
        final void assign(int j) {
            VnObj r = this.stack[this.sp - 1];
            VnObj res = this.vars[j];
            for (int i = 0; i < r.data.length; ++i) {
                res.data[i] = r.data[i];
            }
        }

        final void eq() {
            VnObj r = this.stack[--this.sp];
            VnObj l = this.stack[--this.sp];
            for (int i = 0; i < r.data.length; ++i) {
                if (l.data[i] == r.data[i]) continue;
                MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = 0.0;
                return;
            }
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = 1.0;
        }
    }

    private static final class VnObj
    extends VecObj {
        double[] data;

        VnObj(int len) {
            this.data = new double[len];
        }

        VnObj(double[] vec) {
            this.data = vec;
        }

        @Override
        public Dimensions getDims() {
            return Dimensions.valueOf(this.data.length);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("[");
            for (int i = 0; i < this.data.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.data[i]);
            }
            sb.append("]");
            return sb.toString();
        }

        public void fromVec(MVector val) {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = (Double)val.getEle(i);
            }
        }

        @Override
        public void copyToVec(MVector val) {
            for (int i = 0; i < this.data.length; ++i) {
                val.setEle(i, new Double(this.data[i]));
            }
        }

        @Override
        double[] toArrayVec() {
            return this.data;
        }

        @Override
        public Object toArray() {
            double[] res = new double[this.data.length];
            System.arraycopy(this.data, 0, res, 0, this.data.length);
            return res;
        }
    }

    private final class V4Store
    extends VecStore {
        V4Obj[] stack;
        V4Obj[] heap;
        V4Obj[] vars;

        private V4Store() {
            this.vars = new V4Obj[0];
        }

        @Override
        final void alloc() {
            int i;
            this.heap = new V4Obj[this.hp];
            for (i = 0; i < this.hp; ++i) {
                this.heap[i] = new V4Obj();
            }
            this.stack = new V4Obj[this.stackMax];
            for (i = 0; i < this.stackMax; ++i) {
                this.stack[i] = new V4Obj();
            }
        }

        @Override
        final void expandVarArray(MatrixVariableI var) {
            V4Obj[] newvars = new V4Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            newvars[this.vars.length] = new V4Obj();
            this.vars = newvars;
        }

        @Override
        final void copyVar(int i, MVector vec) {
            this.vars[i].fromVec(vec);
        }

        @Override
        final void add() {
            V4Obj r = this.stack[--this.sp];
            V4Obj l = this.stack[--this.sp];
            V4Obj res = this.heap[this.hp++];
            res.a = l.a + r.a;
            res.b = l.b + r.b;
            res.c = l.c + r.c;
            res.d = l.d + r.d;
            this.stack[this.sp++] = res;
        }

        @Override
        final void sub() {
            V4Obj r = this.stack[--this.sp];
            V4Obj l = this.stack[--this.sp];
            V4Obj res = this.heap[this.hp++];
            res.a = l.a - r.a;
            res.b = l.b - r.b;
            res.c = l.c - r.c;
            res.d = l.d - r.d;
            this.stack[this.sp++] = res;
        }

        @Override
        final void uminus() {
            V4Obj r = this.stack[--this.sp];
            V4Obj res = this.heap[this.hp++];
            res.a = -r.a;
            res.b = -r.b;
            res.c = -r.c;
            res.d = -r.d;
            this.stack[this.sp++] = res;
        }

        @Override
        final void mulS() {
            V4Obj r = this.stack[--this.sp];
            double l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            V4Obj res = this.heap[this.hp++];
            res.a = l * r.a;
            res.b = l * r.b;
            res.c = l * r.c;
            res.d = l * r.d;
            this.stack[this.sp++] = res;
        }

        final void divS() {
            V4Obj l = this.stack[--this.sp];
            double r = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            V4Obj res = this.heap[this.hp++];
            res.a = l.a / r;
            res.b = l.b / r;
            res.c = l.c / r;
            res.d = l.d / r;
            this.stack[this.sp++] = res;
        }

        @Override
        final void makeList() {
            V4Obj res = this.heap[this.hp++];
            res.d = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = res;
        }

        @Override
        final void assign(int i) {
            V4Obj r = this.stack[--this.sp];
            ++this.sp;
            V4Obj res = this.vars[i];
            res.a = r.a;
            res.b = r.b;
            res.c = r.c;
            res.d = r.d;
        }

        final void eq() {
            V4Obj r = this.stack[--this.sp];
            V4Obj l = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = l.a == r.a && l.b == r.b && l.c == r.c && l.d == r.d ? 1.0 : 0.0;
        }
    }

    private static final class V4Obj
    extends VecObj {
        double a;
        double b;
        double c;
        double d;
        private static Dimensions dims = Dimensions.valueOf(4);

        private V4Obj() {
        }

        @Override
        public Dimensions getDims() {
            return dims;
        }

        public String toString() {
            return "[" + this.a + "," + this.b + "," + this.c + "," + this.d + "]";
        }

        public void fromVec(MVector val) {
            this.a = (Double)val.getEle(0);
            this.b = (Double)val.getEle(1);
            this.c = (Double)val.getEle(2);
            this.d = (Double)val.getEle(3);
        }

        @Override
        public void copyToVec(MVector val) {
            val.setEle(0, new Double(this.a));
            val.setEle(1, new Double(this.b));
            val.setEle(2, new Double(this.c));
            val.setEle(3, new Double(this.d));
        }

        @Override
        public double[] toArrayVec() {
            return new double[]{this.a, this.b, this.c, this.d};
        }
    }

    private final class V3Store
    extends VecStore {
        V3Obj[] stack;
        V3Obj[] heap;
        V3Obj[] vars;

        private V3Store() {
            this.vars = new V3Obj[0];
        }

        @Override
        final void alloc() {
            int i;
            this.heap = new V3Obj[this.hp];
            for (i = 0; i < this.hp; ++i) {
                this.heap[i] = new V3Obj();
            }
            this.stack = new V3Obj[this.stackMax];
            for (i = 0; i < this.stackMax; ++i) {
                this.stack[i] = new V3Obj();
            }
        }

        @Override
        final void expandVarArray(MatrixVariableI var) {
            V3Obj[] newvars = new V3Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            newvars[this.vars.length] = new V3Obj();
            this.vars = newvars;
        }

        @Override
        final void copyVar(int i, MVector vec) {
            this.vars[i].fromVec(vec);
        }

        @Override
        final void add() {
            V3Obj r = this.stack[--this.sp];
            V3Obj l = this.stack[--this.sp];
            V3Obj res = this.heap[this.hp++];
            res.a = l.a + r.a;
            res.b = l.b + r.b;
            res.c = l.c + r.c;
            this.stack[this.sp++] = res;
        }

        @Override
        final void sub() {
            V3Obj r = this.stack[--this.sp];
            V3Obj l = this.stack[--this.sp];
            V3Obj res = this.heap[this.hp++];
            res.a = l.a - r.a;
            res.b = l.b - r.b;
            res.c = l.c - r.c;
            this.stack[this.sp++] = res;
        }

        @Override
        final void uminus() {
            V3Obj r = this.stack[--this.sp];
            V3Obj res = this.heap[this.hp++];
            res.a = -r.a;
            res.b = -r.b;
            res.c = -r.c;
            this.stack[this.sp++] = res;
        }

        @Override
        final void mulS() {
            V3Obj r = this.stack[--this.sp];
            double l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            V3Obj res = this.heap[this.hp++];
            res.a = l * r.a;
            res.b = l * r.b;
            res.c = l * r.c;
            this.stack[this.sp++] = res;
        }

        final void divS() {
            V3Obj l = this.stack[--this.sp];
            double r = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            V3Obj res = this.heap[this.hp++];
            res.a = l.a / r;
            res.b = l.b / r;
            res.c = l.c / r;
            this.stack[this.sp++] = res;
        }

        @Override
        final void makeList() {
            V3Obj res = this.heap[this.hp++];
            res.c = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = res;
        }

        @Override
        final void assign(int i) {
            V3Obj r = this.stack[--this.sp];
            ++this.sp;
            V3Obj res = this.vars[i];
            res.a = r.a;
            res.b = r.b;
            res.c = r.c;
        }

        final void eq() {
            V3Obj r = this.stack[--this.sp];
            V3Obj l = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = l.a == r.a && l.b == r.b && l.c == r.c ? 1.0 : 0.0;
        }
    }

    private static final class V3Obj
    extends VecObj {
        double a;
        double b;
        double c;
        private static Dimensions dims = Dimensions.THREE;

        private V3Obj() {
        }

        @Override
        public Dimensions getDims() {
            return dims;
        }

        public String toString() {
            return "[" + this.a + "," + this.b + "," + this.c + "]";
        }

        public void fromVec(MVector val) {
            this.a = (Double)val.getEle(0);
            this.b = (Double)val.getEle(1);
            this.c = (Double)val.getEle(2);
        }

        @Override
        public void copyToVec(MVector val) {
            val.setEle(0, new Double(this.a));
            val.setEle(1, new Double(this.b));
            val.setEle(2, new Double(this.c));
        }

        @Override
        public double[] toArrayVec() {
            return new double[]{this.a, this.b, this.c};
        }
    }

    private final class V2Store
    extends VecStore {
        V2Obj[] stack;
        V2Obj[] heap;
        V2Obj[] vars;

        private V2Store() {
            this.vars = new V2Obj[0];
        }

        @Override
        final void alloc() {
            int i;
            this.heap = new V2Obj[this.hp];
            for (i = 0; i < this.hp; ++i) {
                this.heap[i] = new V2Obj();
            }
            this.stack = new V2Obj[this.stackMax];
            for (i = 0; i < this.stackMax; ++i) {
                this.stack[i] = new V2Obj();
            }
        }

        @Override
        final void expandVarArray(MatrixVariableI var) {
            V2Obj[] newvars = new V2Obj[this.vars.length + 1];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            newvars[this.vars.length] = new V2Obj();
            this.vars = newvars;
        }

        @Override
        final void copyVar(int i, MVector vec) {
            this.vars[i].fromVec(vec);
        }

        @Override
        final void add() {
            V2Obj r = this.stack[--this.sp];
            V2Obj l = this.stack[--this.sp];
            V2Obj res = this.heap[this.hp++];
            res.a = l.a + r.a;
            res.b = l.b + r.b;
            this.stack[this.sp++] = res;
        }

        @Override
        final void sub() {
            V2Obj r = this.stack[--this.sp];
            V2Obj l = this.stack[--this.sp];
            V2Obj res = this.heap[this.hp++];
            res.a = l.a - r.a;
            res.b = l.b - r.b;
            this.stack[this.sp++] = res;
        }

        @Override
        final void uminus() {
            V2Obj r = this.stack[--this.sp];
            V2Obj res = this.heap[this.hp++];
            res.a = -r.a;
            res.b = -r.b;
            this.stack[this.sp++] = res;
        }

        @Override
        final void mulS() {
            V2Obj r = this.stack[--this.sp];
            double l = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            V2Obj res = this.heap[this.hp++];
            res.a = l * r.a;
            res.b = l * r.b;
            this.stack[this.sp++] = res;
        }

        final void divS() {
            V2Obj l = this.stack[--this.sp];
            double r = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            V2Obj res = this.heap[this.hp++];
            res.a = l.a / r;
            res.b = l.b / r;
            this.stack[this.sp++] = res;
        }

        final void mulV2() {
            V2Obj r = this.stack[--this.sp];
            V2Obj l = this.stack[--this.sp];
            V2Obj res = this.heap[this.hp++];
            res.a = l.a * r.a - l.a * r.b;
            res.b = l.a * r.b + l.b * r.a;
            this.stack[this.sp++] = res;
        }

        @Override
        final void makeList() {
            V2Obj res = this.heap[this.hp++];
            res.b = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            res.a = MRpEval.this.scalerStore.stack[--MRpEval.this.scalerStore.sp];
            this.stack[this.sp++] = res;
        }

        @Override
        final void assign(int i) {
            V2Obj r = this.stack[--this.sp];
            ++this.sp;
            V2Obj res = this.vars[i];
            res.a = r.a;
            res.b = r.b;
        }

        final void eq() {
            V2Obj r = this.stack[--this.sp];
            V2Obj l = this.stack[--this.sp];
            MRpEval.this.scalerStore.stack[MRpEval.this.scalerStore.sp++] = l.a == r.a && l.b == r.b ? 1.0 : 0.0;
        }
    }

    private static final class V2Obj
    extends VecObj {
        double a;
        double b;
        private static Dimensions dims = Dimensions.TWO;

        private V2Obj() {
        }

        @Override
        public Dimensions getDims() {
            return dims;
        }

        public String toString() {
            return "[" + this.a + "," + this.b + "]";
        }

        public void fromVec(MVector val) {
            this.a = (Double)val.getEle(0);
            this.b = (Double)val.getEle(1);
        }

        @Override
        public void copyToVec(MVector val) {
            val.setEle(0, new Double(this.a));
            val.setEle(1, new Double(this.b));
        }

        @Override
        public double[] toArrayVec() {
            return new double[]{this.a, this.b};
        }
    }

    private abstract class VecStore
    extends ObjStore {
        private VecStore() {
        }

        abstract void copyVar(int var1, MVector var2);

        @Override
        final void copyFromVar(MatrixVariableI var, int i) {
            if (var.hasValidValue()) {
                MVector val = (MVector)((MatrixVariable)var).getMValue();
                this.copyVar(i, val);
            }
        }

        @Override
        public final void setVarValue(int ref, MatrixValueI val) {
            this.copyVar(ref, (MVector)val);
        }
    }

    private final class ScalerStore
    extends ObjStore {
        double[] stack;
        double[] vars;

        private ScalerStore() {
            this.stack = new double[0];
            this.vars = new double[0];
        }

        @Override
        final void alloc() {
            this.stack = new double[this.stackMax];
        }

        @Override
        final void expandVarArray(MatrixVariableI var) {
            double[] newvars = new double[this.vars.length + 1];
            System.arraycopy(this.vars, 0, newvars, 0, this.vars.length);
            this.vars = newvars;
        }

        @Override
        final void copyFromVar(MatrixVariableI var, int i) {
            if (var.hasValidValue()) {
                Scaler val = (Scaler)var.getMValue();
                this.vars[i] = val.doubleValue();
            }
        }

        public void setVarValue(int ref, double val) {
            this.vars[ref] = val;
        }

        @Override
        public final void setVarValue(int ref, MatrixValueI val) {
            this.vars[ref] = ((Scaler)val).doubleValue();
        }

        @Override
        final void add() {
            double r = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] + r;
        }

        @Override
        final void sub() {
            double r = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] - r;
        }

        @Override
        final void uminus() {
            double r = this.stack[--this.sp];
            this.stack[this.sp++] = -r;
        }

        @Override
        final void mulS() {
            double r = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] * r;
        }

        final void divS() {
            double r = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] / r;
        }

        final void mod() {
            double r = this.stack[--this.sp];
            int n = this.sp - 1;
            this.stack[n] = this.stack[n] % r;
        }

        final void pow() {
            double r = this.stack[--this.sp];
            double l = this.stack[--this.sp];
            this.stack[this.sp++] = Math.pow(l, r);
        }

        final void powN(int n) {
            double r = this.stack[--this.sp];
            switch (n) {
                case 0: {
                    r = 1.0;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    r *= r;
                    break;
                }
                case 3: {
                    r *= r * r;
                    break;
                }
                case 4: {
                    r *= r * r * r;
                    break;
                }
                case 5: {
                    r *= r * r * r * r;
                    break;
                }
                default: {
                    r = Math.pow(r, n);
                }
            }
            this.stack[this.sp++] = r;
        }

        @Override
        final void makeList() {
        }

        @Override
        final void assign(int i) {
            this.vars[i] = this.stack[--this.sp];
            ++this.sp;
        }

        final void and() {
            double l;
            double r = this.stack[--this.sp];
            this.stack[this.sp++] = (l = this.stack[--this.sp]) != 0.0 && r != 0.0 ? 1.0 : 0.0;
        }

        final void or() {
            double l;
            double r = this.stack[--this.sp];
            this.stack[this.sp++] = (l = this.stack[--this.sp]) != 0.0 || r != 0.0 ? 1.0 : 0.0;
        }

        final void not() {
            double r;
            this.stack[this.sp++] = (r = this.stack[--this.sp]) == 0.0 ? 1.0 : 0.0;
        }

        final void lt() {
            double r;
            double l;
            this.stack[this.sp++] = (l = this.stack[--this.sp]) < (r = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void gt() {
            double r;
            double l;
            this.stack[this.sp++] = (l = this.stack[--this.sp]) > (r = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void le() {
            double r;
            double l;
            this.stack[this.sp++] = (l = this.stack[--this.sp]) <= (r = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void ge() {
            double r;
            double l;
            this.stack[this.sp++] = (l = this.stack[--this.sp]) >= (r = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void eq() {
            double r;
            double l;
            this.stack[this.sp++] = (l = this.stack[--this.sp]) == (r = this.stack[--this.sp]) ? 1.0 : 0.0;
        }

        final void neq() {
            double r;
            double l;
            this.stack[this.sp++] = (l = this.stack[--this.sp]) != (r = this.stack[--this.sp]) ? 1.0 : 0.0;
        }
    }

    private static abstract class ObjStore
    implements Observer {
        Hashtable varRefs = new Hashtable();
        int sp = 0;
        int stackMax = 0;
        int hp = 0;

        private ObjStore() {
        }

        final void incStack() {
            ++this.sp;
            if (this.sp > this.stackMax) {
                this.stackMax = this.sp;
            }
        }

        final void incHeap() {
            ++this.hp;
        }

        final void decStack() throws ParseException {
            --this.sp;
            if (this.sp < 0) {
                throw new ParseException("RPEval: stack error");
            }
        }

        final void reset() {
            this.sp = 0;
            this.hp = 0;
        }

        final int addVar(MatrixVariableI var) {
            Object index = this.varRefs.get(var);
            if (index == null) {
                int size = this.varRefs.size();
                this.expandVarArray(var);
                this.varRefs.put(var, new Integer(size));
                this.copyFromVar(var, size);
                ((Variable)((Object)var)).addObserver(this);
                return size;
            }
            return (Integer)index;
        }

        @Override
        public final void update(Observable obs, Object arg1) {
            MatrixVariableI var = (MatrixVariableI)((Object)obs);
            Object index = this.varRefs.get(var);
            this.copyFromVar(var, (Integer)index);
        }

        public abstract void setVarValue(int var1, MatrixValueI var2);

        abstract void alloc();

        final void cleanUp() {
            Enumeration e = this.varRefs.keys();
            while (e.hasMoreElements()) {
                Variable var = (Variable)e.nextElement();
                var.deleteObserver(this);
            }
            this.varRefs.clear();
        }

        abstract void copyFromVar(MatrixVariableI var1, int var2);

        abstract void expandVarArray(MatrixVariableI var1);

        abstract void add();

        abstract void sub();

        abstract void uminus();

        abstract void mulS();

        abstract void makeList();

        abstract void assign(int var1);
    }

    private static abstract class MatObj
    extends MRpRes {
        private MatObj() {
        }

        @Override
        public final void copyToVecMat(MatrixValueI res) throws ParseException {
            if (!this.getDims().equals(res.getDim())) {
                throw new ParseException("CopyToVecMat: dimension of argument " + res.getDim() + " is not equal to dimension of object " + this.getDims());
            }
            this.copyToMat((Matrix)res);
        }

        public abstract void copyToMat(Matrix var1);

        abstract double[][] toArrayMat();

        @Override
        public Object toArray() {
            return this.toArrayMat();
        }
    }

    private static abstract class VecObj
    extends MRpRes {
        private VecObj() {
        }

        @Override
        public final void copyToVecMat(MatrixValueI res) throws ParseException {
            if (!this.getDims().equals(res.getDim())) {
                throw new ParseException("CopyToVecMat: dimension of argument " + res.getDim() + " is not equal to dimension of object " + this.getDims());
            }
            this.copyToVec((MVector)res);
        }

        public abstract void copyToVec(MVector var1);

        abstract double[] toArrayVec();

        @Override
        public Object toArray() {
            return this.toArrayVec();
        }
    }

    private static final class ScalerObj
    extends MRpRes {
        double a;

        private ScalerObj(double val) {
            this.a = val;
        }

        @Override
        public final Dimensions getDims() {
            return Dimensions.ONE;
        }

        @Override
        public final void copyToVecMat(MatrixValueI res) throws ParseException {
            if (!res.getDim().is0D()) {
                throw new ParseException("CopyToVecMat: dimension of argument " + res.getDim() + " is not equal to dimension of object " + this.getDims());
            }
            res.setEle(0, new Double(this.a));
        }

        public final String toString() {
            return String.valueOf(this.a);
        }

        @Override
        public Object toArray() {
            return new double[]{this.a};
        }
    }
}

