/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.xjep.PrintVisitor;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class DiffExample {
    public static void main(String[] args) {
        DJep j = new DJep();
        j.addStandardConstants();
        j.addStandardFunctions();
        j.addComplex();
        j.setAllowUndeclared(true);
        j.setAllowAssignment(true);
        j.setImplicitMul(true);
        j.addStandardDiffRules();
        try {
            Node node = j.parse("sin(x^2)");
            Node diff = j.differentiate(node, "x");
            j.println(diff);
            Node simp = j.simplify(diff);
            j.println(simp);
            Node node2 = j.parse("diff(cos(x^3),x)");
            Node processed = j.preprocess(node2);
            j.println(processed);
            Node simp2 = j.simplify(processed);
            j.println(simp2);
            Node node3 = j.parse("y=x^5");
            j.preprocess(node3);
            Node node4 = j.parse("diff(y^2+x,x)");
            Node simp3 = j.simplify(j.preprocess(node4));
            j.println(simp3);
            PrintVisitor pv = j.getPrintVisitor();
            pv.setMode(16, false);
            j.println(simp3);
            pv.setMode(16, true);
            pv.setMode(32, true);
            j.println(simp3);
            pv.setMode(32, false);
            j.getSymbolTable().setVarValue("x", new Double(5.0));
            System.out.println(j.evaluate(simp3));
            j.evaluate(node3);
            System.out.println(j.getSymbolTable().getVar("y").getValue());
            j.getSymbolTable().setVarValue("x", new Double(0.0));
            System.out.println(j.evaluate(simp));
            Node node10 = j.parse("x=3");
            Node node11 = j.preprocess(node10);
            System.out.println(j.evaluate(node11));
            Node node12 = j.parse("y=x^2");
            Node node13 = j.preprocess(node12);
            System.out.println(j.evaluate(node13));
            Node node14 = j.parse("z=diff(y,x)");
            Node node15 = j.simplify(j.preprocess(node14));
            System.out.println(j.evaluate(node15));
            j.setVarValue("x", new Double(4.0));
            System.out.println(j.evaluate(node13));
            System.out.println(j.evaluate(node15));
            System.out.println("z: " + j.getVarValue("z").toString());
            j.setVarValue("x", new Double(5.0));
            System.out.println("j.setVarValue(\"x\",new Double(5));");
            System.out.println("j.findVarValue(y): " + j.calcVarValue("y").toString());
            System.out.println("j.findVarValue(z): " + j.calcVarValue("z").toString());
            j.getSymbolTable().clearValues();
            j.setVarValue("x", new Double(6.0));
            System.out.println("j.setVarValue(\"x\",new Double(6));");
            System.out.println("j.findVarValue(z): " + j.calcVarValue("z").toString());
            j.getSymbolTable().clearValues();
            j.setVarValue("x", new Double(7.0));
            System.out.println(j.evaluate(node15));
            System.out.println("z: " + j.getVarValue("z").toString());
        }
        catch (ParseException e) {
            System.out.println("Error with parsing");
        }
        catch (Exception e) {
            System.out.println("Error with evaluation");
        }
    }
}

