/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.core;

import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import org.fuin.ddd4j.core.AggregateRootId;
import org.fuin.ddd4j.core.EntityType;
import org.fuin.objects4j.common.Contract;

public abstract class AbstractAggregateException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String id;

    public AbstractAggregateException(@NotEmpty String message, @NotNull EntityType type, @NotNull AggregateRootId id) {
        super(message);
        Contract.requireArgNotEmpty((String)"message", (String)message);
        Contract.requireArgNotNull((String)"aggregateType", (Object)type);
        Contract.requireArgNotNull((String)"aggregateId", (Object)id);
        this.type = type.asString();
        this.id = id.asString();
    }

    public AbstractAggregateException(@NotEmpty String message, @NotEmpty String type, @NotEmpty String id) {
        super(message);
        Contract.requireArgNotEmpty((String)"message", (String)message);
        Contract.requireArgNotNull((String)"aggregateType", (Object)type);
        Contract.requireArgNotNull((String)"aggregateId", (Object)id);
        this.type = type;
        this.id = id;
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }
}

