/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.core;

import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.fuin.ddd4j.core.EntityId;
import org.fuin.ddd4j.core.EntityIdPath;
import org.fuin.objects4j.common.ExceptionShortIdentifable;

public final class DuplicateEntityException
extends Exception
implements ExceptionShortIdentifable {
    public static final String ELEMENT_NAME = "duplicate-entity-exception";
    private static final long serialVersionUID = 1L;
    public static final String SHORT_ID = "DDD4J-DUPLICATE_ENTITY";
    private final String parentIdPath;
    private final String entityId;

    public DuplicateEntityException(@NotNull EntityIdPath parentIdPath, @NotNull EntityId entityId) {
        this(parentIdPath.asString(), entityId.asTypedString());
    }

    public DuplicateEntityException(@NotNull EntityIdPath entityIdPath) {
        this(Objects.requireNonNull(entityIdPath.parent(), "entityIdPath has not parent"), (EntityId)entityIdPath.last());
    }

    public DuplicateEntityException(@NotNull String parentIdPath, @NotNull String entityId) {
        super(entityId + " already exists in " + parentIdPath);
        this.parentIdPath = parentIdPath;
        this.entityId = entityId;
    }

    public final String getShortId() {
        return SHORT_ID;
    }

    public final String getParentIdPath() {
        return this.parentIdPath;
    }

    public final String getEntityId() {
        return this.entityId;
    }
}

