/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.core;

import jakarta.validation.constraints.NotEmpty;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.ExceptionShortIdentifable;

public final class EncryptionKeyVersionUnknownException
extends Exception
implements ExceptionShortIdentifable {
    public static final String ELEMENT_NAME = "encryption-key-version-unknown-exception";
    private static final long serialVersionUID = 1L;
    public static final String SHORT_ID = "DDD4J-ENCRYPTION_KEY_VERSION_UNKNOWN";
    private final String keyVersion;

    public EncryptionKeyVersionUnknownException(@NotEmpty String keyVersion) {
        super("Unknown keyVersion: " + keyVersion);
        Contract.requireArgNotEmpty((String)"keyVersion", (String)keyVersion);
        this.keyVersion = keyVersion;
    }

    public final String getShortId() {
        return SHORT_ID;
    }

    @NotEmpty
    public final String getKeyVersion() {
        return this.keyVersion;
    }
}

