/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.core;

import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import org.fuin.ddd4j.core.EntityIdFactory;
import org.fuin.ddd4j.core.EntityType;
import org.fuin.ddd4j.core.TechnicalId;
import org.fuin.objects4j.common.AsStringCapable;
import org.fuin.objects4j.common.ConstraintViolationException;

public interface EntityId
extends TechnicalId,
AsStringCapable {
    public EntityType getType();

    public String asString();

    public String asTypedString();

    public static boolean isValid(@NotNull EntityIdFactory factory, @Nullable String value) {
        if (value == null) {
            return true;
        }
        int p = value.indexOf(32);
        if (p == -1) {
            return false;
        }
        String type = value.substring(0, p);
        String id = value.substring(p + 1);
        if (!factory.containsType(type)) {
            return false;
        }
        return factory.isValid(type, id);
    }

    public static void requireArgValid(@NotNull EntityIdFactory factory, @NotNull String name, @Nullable String value) throws ConstraintViolationException {
        if (!EntityId.isValid(factory, value)) {
            throw new ConstraintViolationException("The argument '" + name + "' is not valid: '" + value + "'");
        }
    }

    public static EntityId valueOf(@NotNull EntityIdFactory factory, @Nullable String value) {
        if (value == null) {
            return null;
        }
        int p = value.indexOf(32);
        if (p == -1) {
            return null;
        }
        String type = value.substring(0, p);
        String id = value.substring(p + 1);
        return factory.createEntityId(type, id);
    }
}

