/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.core;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.fuin.ddd4j.core.EntityType;
import org.fuin.ddd4j.core.HasEntityTypeConstant;

public class HasEntityTypeConstantValidator
implements ConstraintValidator<HasEntityTypeConstant, Object> {
    private String name;

    public void initialize(HasEntityTypeConstant annotation) {
        this.name = annotation.value();
    }

    public boolean isValid(Object obj, ConstraintValidatorContext context) {
        try {
            Field field = obj.getClass().getField(this.name);
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                this.error(context, "Field '" + this.name + "' is not static (#1)");
                return false;
            }
            if (field.getType() != EntityType.class) {
                this.error(context, "Expected constant '" + this.name + "' to be of type '" + EntityType.class.getName() + "', but was: " + field.getType().getName() + " (#3)");
                return false;
            }
            Object value = field.get(obj);
            if (value == null) {
                this.error(context, "Constant '" + this.name + "' is expected to be a non-null value (#4)");
                return false;
            }
            if (!Modifier.isFinal(modifiers)) {
                this.error(context, "Constant '" + this.name + "' is not not final (#5)");
                return false;
            }
            return true;
        }
        catch (NoSuchFieldException ex) {
            this.error(context, "The field '" + this.name + "' is undefined or it is not public (#2)");
            return false;
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Failed to execute method", ex);
        }
    }

    private void error(ConstraintValidatorContext context, String message) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
    }

    private static Result analyze(Class<?> clasz, String name) {
        try {
            Field field = clasz.getField(name);
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers)) {
                return new Result("Field '" + name + "' is not static (#1)", null);
            }
            if (field.getType() != EntityType.class) {
                return new Result("Expected constant '" + name + "' to be of type '" + EntityType.class.getName() + "', but was: " + field.getType().getName() + " (#3)", null);
            }
            Object value = field.get(clasz);
            if (value == null) {
                return new Result("Constant '" + name + "' is expected to be a non-null value (#4)", null);
            }
            if (!Modifier.isFinal(modifiers)) {
                return new Result("Constant '" + name + "' is not not final (#5)", null);
            }
            return new Result(null, (EntityType)value);
        }
        catch (NoSuchFieldException ex) {
            return new Result("The field '" + name + "' is undefined or it is not public (#2)", null);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Failed to execute method", ex);
        }
    }

    public static EntityType extractValue(Class<?> clasz, String fieldName) {
        Result result = HasEntityTypeConstantValidator.analyze(clasz, fieldName);
        if (result.message() == null) {
            return result.value();
        }
        throw new IllegalArgumentException(result.message());
    }

    private record Result(String message, EntityType value) {
    }
}

