/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.core;

import jakarta.validation.constraints.NotNull;
import org.fuin.ddd4j.core.EntityId;
import org.fuin.ddd4j.core.EntityType;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.ValueObjectWithBaseType;

public abstract class IntegerEntityId
implements EntityId,
Comparable<IntegerEntityId>,
ValueObjectWithBaseType<Integer> {
    private static final long serialVersionUID = 1000L;
    private final EntityType entityType;
    private final Integer id;

    public IntegerEntityId(@NotNull EntityType entityType, @NotNull Integer id) {
        Contract.requireArgNotNull((String)"entityType", (Object)entityType);
        Contract.requireArgNotNull((String)"id", (Object)id);
        this.entityType = entityType;
        this.id = id;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.entityType.asString().hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegerEntityId)) {
            return false;
        }
        IntegerEntityId other = (IntegerEntityId)obj;
        if (!this.entityType.asString().equals(other.entityType.asString())) {
            return false;
        }
        return this.id.equals(other.id);
    }

    @Override
    public final int compareTo(IntegerEntityId other) {
        int c = this.entityType.asString().compareTo(other.entityType.asString());
        if (c != 0) {
            return c;
        }
        return this.id.compareTo(other.id);
    }

    public final String toString() {
        return this.id.toString();
    }

    @Override
    public final String asString() {
        return this.toString();
    }

    @Override
    public final String asTypedString() {
        return String.valueOf(this.entityType) + " " + this.id;
    }

    @Override
    public final EntityType getType() {
        return this.entityType;
    }

    public final Class<Integer> getBaseType() {
        return Integer.class;
    }

    public final Integer asBaseType() {
        return this.id;
    }
}

