/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.core;

import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.fuin.ddd4j.core.EntityId;
import org.fuin.ddd4j.core.EntityIdFactory;
import org.fuin.objects4j.common.ConstraintViolationException;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.core.AbstractStringValueObject;
import org.fuin.objects4j.ui.Label;
import org.fuin.objects4j.ui.Prompt;
import org.fuin.objects4j.ui.ShortLabel;
import org.fuin.objects4j.ui.Tooltip;

@Label(value="Entity identifier path")
@ShortLabel(value="EntityIdPath")
@Tooltip(value="An ordered list of entity identifiers that is separated by '/'. An aggregate root will be the first entry if it's contained in the list.")
@Prompt(value="Customer deb2317d-5b3a-4d56-a9df-689f4c4ff982/Person 123")
public final class EntityIdPath
extends AbstractStringValueObject
implements Serializable {
    private static final long serialVersionUID = 1000L;
    public static final String PATH_SEPARATOR = "/";
    private final List<EntityId> entityIds;

    public EntityIdPath(EntityId ... entityIds) {
        Contract.requireArgNotNull((String)"entityIds", (Object)entityIds);
        if (entityIds.length == 0) {
            throw new ConstraintViolationException("Identifier array cannot be empty");
        }
        for (EntityId entityId : entityIds) {
            if (entityId != null) continue;
            throw new ConstraintViolationException("Identifiers in the array cannot be null");
        }
        this.entityIds = new ArrayList<EntityId>();
        this.entityIds.addAll(Arrays.asList(entityIds));
    }

    public EntityIdPath(List<EntityId> ids) {
        Contract.requireArgNotNull((String)"ids", ids);
        if (ids.isEmpty()) {
            throw new ConstraintViolationException("Identifier list cannot be empty");
        }
        for (EntityId entityId : ids) {
            if (entityId != null) continue;
            throw new ConstraintViolationException("Identifiers in the list cannot be null");
        }
        this.entityIds = new ArrayList<EntityId>();
        this.entityIds.addAll(ids);
    }

    public final Iterator<EntityId> iterator() {
        return new ArrayList<EntityId>(this.entityIds).iterator();
    }

    public final <T extends EntityId> T first() {
        return (T)this.entityIds.get(0);
    }

    public final <T extends EntityId> T last() {
        return (T)this.entityIds.get(this.entityIds.size() - 1);
    }

    public final EntityIdPath rest() {
        if (this.entityIds.size() == 1) {
            return null;
        }
        ArrayList<EntityId> list = new ArrayList<EntityId>();
        for (int i = 1; i < this.entityIds.size(); ++i) {
            list.add(this.entityIds.get(i));
        }
        return new EntityIdPath(list);
    }

    public EntityIdPath parent() {
        if (this.entityIds.size() == 1) {
            return null;
        }
        ArrayList<EntityId> list = new ArrayList<EntityId>();
        for (int i = 0; i < this.entityIds.size() - 1; ++i) {
            list.add(this.entityIds.get(i));
        }
        return new EntityIdPath(list);
    }

    public final int size() {
        return this.entityIds.size();
    }

    public final String asBaseType() {
        StringBuilder sb = new StringBuilder();
        for (EntityId entityId : this.entityIds) {
            if (!sb.isEmpty()) {
                sb.append(PATH_SEPARATOR);
            }
            sb.append(entityId.asTypedString());
        }
        return sb.toString();
    }

    public final String toString() {
        return this.asBaseType();
    }

    @Nullable
    public static EntityIdPath valueOf(@NotNull EntityIdFactory factory, @Nullable String str) {
        Contract.requireArgNotNull((String)"factory", (Object)factory);
        if (str == null) {
            return null;
        }
        List<String> entryList = EntityIdPath.entries(str);
        if (entryList.isEmpty()) {
            throw new IllegalArgumentException("Invalid entity path: '" + str + "'");
        }
        ArrayList<EntityId> ids = new ArrayList<EntityId>();
        for (String entry : entryList) {
            ids.add(EntityId.valueOf(factory, entry));
        }
        return new EntityIdPath(ids);
    }

    public static boolean isValid(@NotNull EntityIdFactory factory, @Nullable String value) {
        Contract.requireArgNotNull((String)"factory", (Object)factory);
        if (value == null) {
            return true;
        }
        if (value.isEmpty()) {
            return false;
        }
        List<String> entryList = EntityIdPath.entries(value);
        if (entryList.isEmpty()) {
            return false;
        }
        for (String entry : entryList) {
            if (EntityId.isValid(factory, entry)) continue;
            return false;
        }
        return true;
    }

    public static void requireArgValid(@NotNull EntityIdFactory factory, @NotNull String name, @Nullable String value) throws ConstraintViolationException {
        Contract.requireArgNotNull((String)"factory", (Object)factory);
        Contract.requireArgNotNull((String)"name", (Object)name);
        if (!EntityIdPath.isValid(factory, value)) {
            throw new ConstraintViolationException("The argument '" + name + "' is not valid: '" + value + "'");
        }
    }

    private static List<String> entries(String value) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(value, PATH_SEPARATOR);
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            list.add(str);
        }
        return list;
    }
}

