/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.core;

import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.fuin.ddd4j.core.EntityId;
import org.fuin.ddd4j.core.EntityIdPath;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.ExceptionShortIdentifable;

public final class EntityNotFoundException
extends Exception
implements ExceptionShortIdentifable {
    public static final String ELEMENT_NAME = "entity-not-found-exception";
    private static final long serialVersionUID = 1L;
    public static final String SHORT_ID = "DDD4J-ENTITY_NOT_FOUND";
    private final String parentIdPath;
    private final String entityId;

    public EntityNotFoundException(@Nullable EntityIdPath parentIdPath, @NotNull EntityId entityId) {
        this(parentIdPath == null ? null : parentIdPath.asString(), entityId.asTypedString());
    }

    public EntityNotFoundException(@NotNull EntityIdPath entityIdPath) {
        this(Objects.requireNonNull(entityIdPath, "entityIdPath==null").parent(), (EntityId)entityIdPath.last());
    }

    public EntityNotFoundException(@Nullable String parentIdPath, @NotNull String entityId) {
        super(parentIdPath == null ? entityId + " not found" : entityId + " not found in " + parentIdPath);
        Contract.requireArgNotNull((String)"entityId", (Object)entityId);
        this.parentIdPath = parentIdPath;
        this.entityId = entityId;
    }

    public String getShortId() {
        return SHORT_ID;
    }

    @Nullable
    public String getParentIdPath() {
        return this.parentIdPath;
    }

    @NotNull
    public String getEntityId() {
        return this.entityId;
    }
}

