/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.core;

import jakarta.annotation.Nullable;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.UUID;
import javax.annotation.concurrent.Immutable;
import org.fuin.objects4j.common.AsStringCapable;
import org.fuin.objects4j.common.Contract;
import org.fuin.objects4j.common.HasPublicStaticIsValidMethod;
import org.fuin.objects4j.common.HasPublicStaticValueOfMethod;
import org.fuin.objects4j.core.AbstractUuidValueObject;
import org.fuin.objects4j.ui.Label;
import org.fuin.objects4j.ui.Prompt;
import org.fuin.objects4j.ui.ShortLabel;
import org.fuin.objects4j.ui.Tooltip;
import org.fuin.utils4j.TechnicalId;

@Label(value="Event Identifier")
@ShortLabel(value="EventID")
@Tooltip(value="Identifies an event universally unique")
@Prompt(value="bb05f34d-4eac-4f6a-b3c2-5c89269720f3")
@HasPublicStaticValueOfMethod
@HasPublicStaticIsValidMethod
@Immutable
public final class EventId
extends AbstractUuidValueObject
implements TechnicalId,
AsStringCapable,
Serializable {
    private static final long serialVersionUID = 1000L;
    private final UUID uuid;

    public EventId() {
        this.uuid = UUID.randomUUID();
    }

    public EventId(@NotNull UUID uuid) {
        Contract.requireArgNotNull((String)"uuid", (Object)uuid);
        this.uuid = uuid;
    }

    public UUID asBaseType() {
        return this.uuid;
    }

    public String asString() {
        return this.uuid.toString();
    }

    public String toString() {
        return this.uuid.toString();
    }

    public static EventId valueOf(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return new EventId(UUID.fromString(value));
    }
}

