/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.core;

import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.fuin.ddd4j.core.AggregateRootId;
import org.fuin.ddd4j.core.EntityId;
import org.fuin.ddd4j.core.EntityIdFactory;
import org.fuin.ddd4j.core.EntityType;
import org.fuin.ddd4j.core.HasEntityTypeConstant;
import org.fuin.ddd4j.core.HasEntityTypeConstantValidator;
import org.fuin.objects4j.common.HasPublicStaticIsValidMethod;
import org.fuin.objects4j.common.HasPublicStaticIsValidMethodValidator;
import org.fuin.objects4j.common.HasPublicStaticValueOfMethod;
import org.fuin.objects4j.common.HasPublicStaticValueOfMethodValidator;
import org.fuin.utils4j.jandex.JandexIndexFileReader;
import org.fuin.utils4j.jandex.JandexUtils;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JandexEntityIdFactory
implements EntityIdFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JandexEntityIdFactory.class);
    private final List<File> classesDirs;
    private final Map<String, Function<String, EntityId>> valueOfMap;
    private final Map<String, Function<String, Boolean>> isValidMap;
    private final List<Class<?>> idClasses;

    public JandexEntityIdFactory() {
        this(new File("target/classes"));
    }

    public JandexEntityIdFactory(File ... classesDirs) {
        this.classesDirs = Arrays.asList(classesDirs);
        this.valueOfMap = new HashMap<String, Function<String, EntityId>>();
        this.isValidMap = new HashMap<String, Function<String, Boolean>>();
        this.idClasses = this.scanForEntityIdClasses();
        for (Class<?> entityIdClass : this.idClasses) {
            this.valueOfMap.put(this.typeConstant(entityIdClass).asString(), this.valueOfMethod(entityIdClass));
            this.isValidMap.put(this.typeConstant(entityIdClass).asString(), this.isValidMethod(entityIdClass));
        }
    }

    @Override
    public EntityId createEntityId(String type, String id) {
        Function<String, EntityId> factory = this.valueOfMap.get(type);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown type: " + type + " (Known types are: " + String.valueOf(this.getIdClasses()) + ")");
        }
        return factory.apply(id);
    }

    @Override
    public boolean containsType(String type) {
        return this.valueOfMap.containsKey(type);
    }

    @Override
    public boolean isValid(String type, String id) {
        Function<String, Boolean> func = this.isValidMap.get(type);
        if (func == null) {
            return false;
        }
        return func.apply(id);
    }

    public List<Class<?>> getIdClasses() {
        return Collections.unmodifiableList(this.idClasses);
    }

    private List<Class<?>> scanForEntityIdClasses() {
        ArrayList<IndexView> indexes = new ArrayList<IndexView>();
        indexes.add(new JandexIndexFileReader.Builder().addDefaultResource().build().loadR());
        indexes.add(this.indexClassesDirs());
        return JandexEntityIdFactory.findEntityIdClasses((IndexView)CompositeIndex.create(indexes));
    }

    private IndexView indexClassesDirs() {
        Indexer indexer = new Indexer();
        ArrayList knownClassFiles = new ArrayList();
        for (File classesDir : this.classesDirs) {
            JandexUtils.indexDir((Indexer)indexer, knownClassFiles, (File)classesDir);
        }
        return indexer.complete();
    }

    private static List<Class<?>> findEntityIdClasses(IndexView index) {
        ArrayList classes = new ArrayList();
        HashSet classInfos = new HashSet();
        classInfos.addAll(index.getAllKnownImplementors(DotName.createSimple(EntityId.class)));
        classInfos.addAll(index.getAllKnownImplementors(DotName.createSimple(AggregateRootId.class)));
        for (ClassInfo classInfo : classInfos) {
            if (Modifier.isAbstract(classInfo.flags()) || Modifier.isInterface(classInfo.flags())) continue;
            Class clasz = JandexUtils.loadClass((DotName)classInfo.name());
            boolean include = true;
            if (clasz.getAnnotation(HasPublicStaticIsValidMethod.class) == null) {
                LOG.warn("Missing annotation @{} on {} class: {}", new Object[]{HasPublicStaticIsValidMethod.class.getSimpleName(), EntityId.class.getSimpleName(), clasz.getName()});
                include = false;
            }
            if (clasz.getAnnotation(HasPublicStaticValueOfMethod.class) == null) {
                LOG.warn("Missing annotation @{} on {} class: {}", new Object[]{HasPublicStaticValueOfMethod.class.getSimpleName(), EntityId.class.getSimpleName(), clasz.getName()});
                include = false;
            }
            if (clasz.getAnnotation(HasEntityTypeConstant.class) == null) {
                LOG.warn("Missing annotation @{} on {} class: {}", new Object[]{HasEntityTypeConstant.class.getSimpleName(), EntityId.class.getSimpleName(), clasz.getName()});
                include = false;
            }
            if (include) {
                classes.add(clasz);
                LOG.info("Added {} class to {}: {}", new Object[]{EntityId.class.getSimpleName(), JandexEntityIdFactory.class.getSimpleName(), clasz.getName()});
                continue;
            }
            LOG.debug("Ignored {} class: {}", (Object)EntityId.class.getSimpleName(), (Object)clasz.getName());
        }
        return classes;
    }

    public EntityType typeConstant(Class<?> entityIdClass) {
        HasEntityTypeConstant annotation = entityIdClass.getAnnotation(HasEntityTypeConstant.class);
        return HasEntityTypeConstantValidator.extractValue(entityIdClass, annotation.value());
    }

    private Function<String, Boolean> isValidMethod(Class<?> entityIdClass) {
        HasPublicStaticIsValidMethod annotation = entityIdClass.getAnnotation(HasPublicStaticIsValidMethod.class);
        return HasPublicStaticIsValidMethodValidator.findFunction(entityIdClass, (String)annotation.method(), (Class)annotation.param());
    }

    private Function<String, EntityId> valueOfMethod(Class<?> entityIdClass) {
        HasPublicStaticValueOfMethod annotation = entityIdClass.getAnnotation(HasPublicStaticValueOfMethod.class);
        return HasPublicStaticValueOfMethodValidator.findFunction(entityIdClass, (String)annotation.method(), (Class)annotation.param());
    }
}

