/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.core;

import jakarta.validation.constraints.NotNull;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.fuin.ddd4j.core.AbstractAggregateRoot;
import org.fuin.objects4j.common.Contract;

@ThreadSafe
public final class MethodExecutor {
    public final <T> T invokeDeclaredAnnotatedMethod(@NotNull Object obj, @NotNull Class<? extends Annotation> annotationType, Class<?>[] argumentTypes, Object[] arguments) {
        Contract.requireArgNotNull((String)"obj", (Object)obj);
        Contract.requireArgNotNull((String)"annotationType", annotationType);
        this.requireValid(argumentTypes, arguments);
        Method method = this.findDeclaredAnnotatedMethod(obj, annotationType, argumentTypes);
        if (method == null) {
            throw new IllegalArgumentException("Cannot find a method annotated with '" + annotationType.getSimpleName() + "' and arguments '" + String.valueOf(Arrays.asList(argumentTypes)) + "' in class '" + obj.getClass().getName() + "'");
        }
        return this.invoke(method, obj, arguments);
    }

    public final Method findDeclaredAnnotatedMethod(@NotNull Object obj, @NotNull Class<? extends Annotation> annotationType, Class<?> ... expectedArgumentTypes) {
        Contract.requireArgNotNull((String)"obj", (Object)obj);
        Contract.requireArgNotNull((String)"annotationType", annotationType);
        List<Method> methods = this.getDeclaredMethodsIncludingSuperClasses(obj.getClass(), AbstractAggregateRoot.class);
        for (Method method : methods) {
            Class<?>[] types;
            if (method.getAnnotation(annotationType) == null || !this.same(expectedArgumentTypes, types = method.getParameterTypes())) continue;
            return method;
        }
        return null;
    }

    public final List<Method> getDeclaredMethodsIncludingSuperClasses(@NotNull Class<?> clasz, Class<?> ... stopParents) {
        Contract.requireArgNotNull((String)"clasz", clasz);
        Contract.requireArgNotNull((String)"stopParents", stopParents);
        ArrayList stopList = new ArrayList(Arrays.asList(stopParents));
        if (!stopList.contains(Object.class)) {
            stopList.add(Object.class);
        }
        ArrayList<Method> list = new ArrayList<Method>();
        Class<?> toInspect = clasz;
        while (!stopList.contains(toInspect)) {
            Method[] methods = toInspect.getDeclaredMethods();
            list.addAll(Arrays.asList(methods));
            toInspect = toInspect.getSuperclass();
        }
        return list;
    }

    public final <T> T invoke(@NotNull Method method, @NotNull Object target, Object ... args) {
        Contract.requireArgNotNull((String)"method", (Object)method);
        Contract.requireArgNotNull((String)"target", (Object)target);
        try {
            if (!method.canAccess(target)) {
                method.setAccessible(true);
            }
            return (T)method.invoke(target, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new RuntimeException(this.createInvokeErrMsg(target, method, args), ex);
        }
    }

    private String createInvokeErrMsg(Object target, Method method, Object ... args) {
        if (args == null || args.length == 0) {
            return "Failed to call method '" + String.valueOf(method) + "' on '" + target.getClass().getSimpleName();
        }
        return "Failed to call method '" + String.valueOf(method) + "' on '" + target.getClass().getSimpleName() + "' with arguments: " + String.valueOf(Arrays.asList(args));
    }

    public final boolean same(Class<?>[] expected, Class<?>[] actual) {
        if (expected == null) {
            return actual == null;
        }
        if (actual == null) {
            return false;
        }
        if (expected.length != actual.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[0] == actual[i]) continue;
            return false;
        }
        return true;
    }

    private void requireValid(Class<?>[] argumentTypes, Object[] arguments) {
        if (argumentTypes == null && arguments != null) {
            throw new IllegalArgumentException("Argument type array is null, but arguments array is not: " + String.valueOf(Arrays.asList(arguments)));
        }
        if (arguments == null && argumentTypes != null) {
            throw new IllegalArgumentException("Arguments array is null, but argument types array is not: " + String.valueOf(Arrays.asList(argumentTypes)));
        }
        if (argumentTypes != null && argumentTypes.length != arguments.length) {
            throw new IllegalArgumentException("Types and arguments have different length: Types=" + String.valueOf(Arrays.asList(argumentTypes)) + ", Args=" + String.valueOf(Arrays.asList(arguments)));
        }
    }
}

