/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.esc;

import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.fuin.ddd4j.core.AggregateRootId;
import org.fuin.ddd4j.core.EntityType;
import org.fuin.esc.api.StreamId;
import org.fuin.objects4j.core.KeyValue;

@Immutable
public final class AggregateStreamId
implements StreamId {
    private static final long serialVersionUID = 1000L;
    @NotNull
    private final EntityType type;
    @NotNull
    private final String paramName;
    @NotNull
    private final AggregateRootId paramValue;
    private transient List<KeyValue> params;

    public AggregateStreamId(EntityType type, String paramName, AggregateRootId paramValue) {
        this.type = Objects.requireNonNull(type, "type==null");
        this.paramName = Objects.requireNonNull(paramName, "paramName==null");
        this.paramValue = Objects.requireNonNull(paramValue, "paramValue==null");
    }

    public String getName() {
        return this.type.asString();
    }

    public boolean isProjection() {
        return false;
    }

    public <T> T getSingleParamValue() {
        return (T)this.paramValue.asString();
    }

    public List<KeyValue> getParameters() {
        if (this.params == null) {
            this.params = List.of(new KeyValue(this.paramName, (Object)this.paramValue.asString()));
        }
        return this.params;
    }

    public String asString() {
        return String.valueOf(this.type) + "-" + this.paramValue.asString();
    }

    public int hashCode() {
        return this.asString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggregateStreamId other = (AggregateStreamId)obj;
        return this.asString().equals(other.asString());
    }

    public String toString() {
        return this.asString();
    }
}

