/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.ddd4j.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import org.fuin.ddd4j.core.EntityNotFoundException;
import org.fuin.ddd4j.core.ExceptionData;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EntityNotFoundExceptionData
implements ExceptionData<EntityNotFoundException> {
    private static final long serialVersionUID = 1000L;
    @JsonProperty(value="msg")
    private String message;
    @JsonProperty(value="sid")
    private String sid;
    @JsonProperty(value="parent-id-path")
    private String parentIdPath;
    @JsonProperty(value="entity-id")
    private String entityId;

    protected EntityNotFoundExceptionData() {
    }

    public EntityNotFoundExceptionData(@NotNull EntityNotFoundException ex) {
        this.message = ex.getMessage();
        this.sid = ex.getShortId();
        this.parentIdPath = ex.getParentIdPath();
        this.entityId = ex.getEntityId();
    }

    @JsonIgnore
    public final String getMessage() {
        return this.message;
    }

    @JsonIgnore
    public String getDataElement() {
        return "entity-not-found-exception";
    }

    @JsonIgnore
    public String getShortId() {
        return this.sid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entityId == null ? 0 : this.entityId.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.parentIdPath == null ? 0 : this.parentIdPath.hashCode());
        result = 31 * result + (this.sid == null ? 0 : this.sid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityNotFoundExceptionData other = (EntityNotFoundExceptionData)obj;
        if (this.entityId == null ? other.entityId != null : !this.entityId.equals(other.entityId)) {
            return false;
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.parentIdPath == null ? other.parentIdPath != null : !this.parentIdPath.equals(other.parentIdPath)) {
            return false;
        }
        return !(this.sid == null ? other.sid != null : !this.sid.equals(other.sid));
    }

    public String toString() {
        return "EntityNotFoundExceptionData [message=" + this.message + ", sid=" + this.sid + ", parentIdPath=" + this.parentIdPath + ", entityId=" + this.entityId + "]";
    }

    public EntityNotFoundException toException() {
        return new EntityNotFoundException(this.parentIdPath, this.entityId);
    }
}

