/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esmp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.OS;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.fuin.esmp.AbstractEventStoreMojo;
import org.fuin.esmp.FileMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventStoreDownloadMojo
extends AbstractEventStoreMojo {
    private static final Logger LOG = LoggerFactory.getLogger(EventStoreDownloadMojo.class);
    private static final int MB = 0x100000;

    @Override
    protected final void executeGoal() throws MojoExecutionException {
        if (this.getEventStoreDir().exists()) {
            LOG.info("Events store directory already exists: " + this.getEventStoreDir());
        } else {
            File archive = this.downloadEventStoreArchive();
            this.unpack(archive);
        }
    }

    public final File getDownloadFile() throws MojoExecutionException {
        String name = FilenameUtils.getName((String)this.getDownloadUrl());
        return new File(this.getEventStoreDir().getParentFile(), name);
    }

    private URL createDownloadURL() throws MojoExecutionException {
        try {
            return new URL(this.getDownloadUrl());
        }
        catch (MalformedURLException ex) {
            throw new MojoExecutionException("Failed to construct download URL for the event store", (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadEventStoreArchive() throws MojoExecutionException {
        URL url = this.createDownloadURL();
        try {
            final File file = this.getDownloadFile();
            if (file.exists()) {
                LOG.info("Archive already exists in target directory: " + file);
            } else {
                LOG.info("Dowloading archive: " + url);
                CountingInputStream in = new CountingInputStream(url.openStream()){
                    private int called;
                    {
                        super(x0);
                        this.called = 0;
                    }

                    protected final void afterRead(int n) {
                        super.afterRead(n);
                        ++this.called;
                        if (this.called % 1000 == 0) {
                            LOG.info("{} - {} bytes", (Object)file.getName(), (Object)this.getCount());
                        }
                    }
                };
                try {
                    FileUtils.copyInputStreamToFile((InputStream)in, (File)file);
                }
                finally {
                    in.close();
                }
                LOG.info("Archive saved to: " + file);
            }
            return file;
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error downloading event store archive: " + url, (Exception)ex);
        }
    }

    private void unpack(File archive) throws MojoExecutionException {
        File destDir = this.getEventStoreDir().getParentFile();
        LOG.info("Unzip event store to target directory: " + this.getEventStoreDir());
        if (archive.getName().endsWith(".zip")) {
            this.unzip(archive, destDir);
        } else if (archive.getName().endsWith(".tar.gz")) {
            this.unTarGz(archive, destDir);
        } else {
            throw new MojoExecutionException("Cannot unpack file: " + archive.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzip(File zipFile, File destDir) throws MojoExecutionException {
        try {
            ZipFile zip = new ZipFile(zipFile);
            try {
                Enumeration<? extends ZipEntry> enu = zip.entries();
                while (enu.hasMoreElements()) {
                    ZipEntry entry = enu.nextElement();
                    File file = new File(entry.getName());
                    if (file.isAbsolute()) {
                        throw new IllegalArgumentException("Only relative path entries are allowed! [" + entry.getName() + "]");
                    }
                    if (entry.isDirectory()) {
                        File dir = new File(destDir, entry.getName());
                        EventStoreDownloadMojo.createIfNecessary(dir);
                        continue;
                    }
                    File outFile = new File(destDir, entry.getName());
                    EventStoreDownloadMojo.createIfNecessary(outFile.getParentFile());
                    BufferedInputStream in = new BufferedInputStream(zip.getInputStream(entry));
                    try {
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
                        try {
                            int len;
                            byte[] buf = new byte[4096];
                            while ((len = ((InputStream)in).read(buf)) > 0) {
                                ((OutputStream)out).write(buf, 0, len);
                            }
                        }
                        finally {
                            ((OutputStream)out).close();
                        }
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
            }
            finally {
                zip.close();
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error unzipping event store archive: " + zipFile, (Exception)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unTarGz(File archive, File destDir) throws MojoExecutionException {
        try {
            TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(new FileInputStream(archive))));
            try {
                TarArchiveEntry entry;
                while ((entry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
                    LOG.info("Extracting: " + entry.getName());
                    File file = new File(destDir, entry.getName());
                    if (entry.isDirectory()) {
                        EventStoreDownloadMojo.createIfNecessary(file);
                    } else {
                        byte[] data = new byte[0x100000];
                        FileOutputStream fos = new FileOutputStream(file);
                        BufferedOutputStream dest = new BufferedOutputStream(fos, 0x100000);
                        try {
                            int count;
                            while ((count = tarIn.read(data, 0, 0x100000)) != -1) {
                                dest.write(data, 0, count);
                            }
                        }
                        finally {
                            dest.close();
                        }
                        entry.getMode();
                    }
                    this.applyFileMode(file, new FileMode(entry.getMode()));
                }
            }
            finally {
                tarIn.close();
            }
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error uncompressing event store archive: " + archive, (Exception)ex);
        }
    }

    private static void createIfNecessary(File dir) throws IOException {
        if (dir.exists()) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new IOException("Error creating directory '" + dir + "'!");
        }
    }

    private void applyFileMode(File file, FileMode fileMode) throws MojoExecutionException {
        block4: {
            if (OS.isFamilyUnix() || OS.isFamilyMac()) {
                String smode = fileMode.toChmodStringFull();
                CommandLine cmdLine = new CommandLine("chmod");
                cmdLine.addArgument(smode);
                cmdLine.addArgument(file.getAbsolutePath());
                DefaultExecutor executor = new DefaultExecutor();
                try {
                    int result = executor.execute(cmdLine);
                    if (result != 0) {
                        throw new MojoExecutionException("Error # " + result + " while trying to set mode \"" + smode + "\" for file: " + file.getAbsolutePath());
                    }
                    break block4;
                }
                catch (IOException ex) {
                    throw new MojoExecutionException("Error while trying to set mode \"" + smode + "\" for file: " + file.getAbsolutePath(), (Exception)ex);
                }
            }
            file.setReadable(fileMode.isUr() || fileMode.isGr() || fileMode.isOr());
            file.setWritable(fileMode.isUw() || fileMode.isGw() || fileMode.isOw());
            file.setExecutable(fileMode.isUx() || fileMode.isGx() || fileMode.isOx());
        }
    }
}

