/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esmp;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DaemonExecutor;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.fuin.esmp.AbstractEventStoreMojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventStoreStartMojo
extends AbstractEventStoreMojo {
    private static final Logger LOG = LoggerFactory.getLogger(EventStoreStartMojo.class);
    private static final String UP_MSG = "HTTP server is up and listening";
    private String command;
    private String[] arguments;
    private int maxWaitCycles = 20;
    private int sleepMillis = 500;

    @Override
    protected final void executeGoal() throws MojoExecutionException {
        this.init();
        LOG.info("command={}", (Object)this.command);
        LOG.info("arguments={}", (Object)Arrays.toString(this.arguments));
        if (OS.isFamilyUnix() || OS.isFamilyMac()) {
            File execFile = new File(this.getEventStoreDir(), this.command);
            execFile.setExecutable(true);
        }
        CommandLine cmdLine = this.createCommandLine();
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        DaemonExecutor executor = new DaemonExecutor();
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PumpStreamHandler psh = new PumpStreamHandler((OutputStream)bos);
            executor.setStreamHandler((ExecuteStreamHandler)psh);
            executor.setWorkingDirectory(this.getEventStoreDir());
            executor.execute(cmdLine, (ExecuteResultHandler)resultHandler);
            List<String> messages = this.waitForHttpServer(bos);
            this.logDebug(messages);
            String pid = this.extractPid(messages);
            LOG.info("Event store process ID: {}", (Object)pid);
            this.writePid(pid);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error executing the command line: " + cmdLine, (Exception)ex);
        }
    }

    private List<String> waitForHttpServer(ByteArrayOutputStream bos) throws MojoExecutionException {
        int wait = 0;
        while (wait++ < this.maxWaitCycles) {
            this.sleep(this.sleepMillis);
            String str = bos.toString();
            if (!str.contains(UP_MSG)) continue;
            return this.asList(str);
        }
        throw new MojoExecutionException("Waited too long for the server to start!");
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ex) {
            LOG.info("Interrupted while sleeping", (Throwable)ex);
        }
    }

    private String extractPid(List<String> messages) throws MojoExecutionException {
        if (messages.size() == 0) {
            throw new MojoExecutionException("Starting the event store didn't return any messages");
        }
        String first = messages.get(0);
        int p0 = first.indexOf(91);
        if (p0 == -1) {
            throw new MojoExecutionException("Couldn't locate the starting bracket '[': " + first);
        }
        int p1 = first.indexOf(44, p0 + 1);
        if (p1 == -1) {
            throw new MojoExecutionException("Couldn't locate the ending comma ',': " + first);
        }
        return first.substring(p0 + 1, p1);
    }

    private void init() throws MojoExecutionException {
        if (OS.isFamilyWindows()) {
            if (this.command == null) {
                this.command = "EventStore.ClusterNode.Exe";
            }
        } else if (OS.isFamilyUnix()) {
            if (this.command == null) {
                this.command = "./run-node.sh";
            }
        } else if (OS.isFamilyMac()) {
            if (this.command == null) {
                this.command = "./run-node.sh";
            }
        } else if (this.command == null) {
            throw new MojoExecutionException("Unknown OS - You must use the 'command' parameter");
        }
        if (this.arguments == null) {
            this.arguments = new String[1];
            this.arguments[0] = "--mem-db=TRUE";
        }
    }

    private CommandLine createCommandLine() throws MojoExecutionException {
        CommandLine cmdLine = new CommandLine(this.command);
        if (this.arguments != null) {
            for (String argument : this.arguments) {
                cmdLine.addArgument(argument);
            }
        }
        return cmdLine;
    }

    public final String getCommand() {
        return this.command;
    }

    public final void setCommand(String command) {
        this.command = command;
    }

    public final String[] getArguments() {
        return this.arguments;
    }

    public final void setArguments(String[] arguments) {
        this.arguments = arguments;
    }
}

