/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esmp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.OS;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.fuin.esmp.AbstractEventStoreMojo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventStoreStopMojo
extends AbstractEventStoreMojo {
    private static final Logger LOG = LoggerFactory.getLogger(EventStoreStopMojo.class);
    private String command;

    @Override
    protected final void executeGoal() throws MojoExecutionException {
        this.init();
        LOG.info("command={}", (Object)this.command);
        CommandLine cmdLine = this.createCommandLine();
        DefaultExecutor executor = new DefaultExecutor();
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PumpStreamHandler psh = new PumpStreamHandler((OutputStream)bos);
            executor.setStreamHandler((ExecuteStreamHandler)psh);
            executor.setWorkingDirectory(this.getEventStoreDir());
            int result = executor.execute(cmdLine);
            if (result != 0) {
                throw new MojoExecutionException("Error stopping the event store: " + result);
            }
            List<String> messages = this.asList(bos.toString());
            this.logDebug(messages);
            this.deletePid();
            LOG.info("Event store successfully stopped");
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error executing the command line: " + cmdLine, (Exception)ex);
        }
    }

    private CommandLine createCommandLine() throws MojoExecutionException {
        CommandLine cmdLine = new CommandLine(this.command);
        if (OS.isFamilyWindows()) {
            cmdLine.addArgument("/PID");
            cmdLine.addArgument(this.readPid());
            cmdLine.addArgument("/F");
        } else if (OS.isFamilyUnix() || OS.isFamilyMac()) {
            cmdLine.addArgument("-SIGKILL");
            cmdLine.addArgument(this.readPid());
        } else {
            throw new MojoExecutionException("Unknown OS - Cannot kill the process");
        }
        return cmdLine;
    }

    private void init() throws MojoExecutionException {
        if (OS.isFamilyWindows()) {
            if (this.command == null) {
                this.command = "taskkill";
            }
        } else if (OS.isFamilyUnix() || OS.isFamilyMac()) {
            if (this.command == null) {
                this.command = "kill";
            }
        } else if (this.command == null) {
            throw new MojoExecutionException("Unknown OS - You must use the 'command' parameter");
        }
    }

    public final String getCommand() {
        return this.command;
    }

    public final void setCommand(String command) {
        this.command = command;
    }
}

