/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esmp;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.exec.OS;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public abstract class AbstractEventStoreMojo
extends AbstractMojo {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEventStoreMojo.class);
    private static final String PID_FILE_NAME = "event-store-pid";
    private String downloadUrl;
    private String baseUrl = "http://download.geteventstore.com/binaries/";
    private String archiveName;
    private String archiveVersion = "3.0.5";
    private String archiveExtension;
    private File targetDir = new File("./target");
    private File eventStoreDir;

    protected final void checkNotNull(String name, Object value) throws MojoExecutionException {
        if (value == null) {
            throw new MojoExecutionException(name + " cannot be null!");
        }
    }

    public final void execute() throws MojoExecutionException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        this.init();
        LOG.info("download-url={}", (Object)this.downloadUrl);
        LOG.info("base-url={}", (Object)this.baseUrl);
        LOG.info("archive-name={}", (Object)this.archiveName);
        LOG.info("archive-version={}", (Object)this.archiveVersion);
        LOG.info("archive-extension={}", (Object)this.archiveExtension);
        LOG.info("target-dir={}", (Object)this.targetDir);
        LOG.info("event-store-dir={}", (Object)this.eventStoreDir);
        this.executeGoal();
    }

    private void init() throws MojoExecutionException {
        if (this.downloadUrl == null) {
            if (!this.baseUrl.endsWith("/")) {
                this.baseUrl = this.baseUrl + "/";
            }
            if (OS.isFamilyWindows()) {
                if (this.archiveName == null) {
                    this.archiveName = "EventStore-OSS-Win";
                }
                if (this.archiveExtension == null) {
                    this.archiveExtension = "zip";
                }
            } else if (OS.isFamilyMac()) {
                if (this.archiveName == null) {
                    this.archiveName = "EventStore-OSS-Mac";
                }
                if (this.archiveExtension == null) {
                    this.archiveExtension = "tar.gz";
                }
            } else if (OS.isFamilyUnix()) {
                if (this.archiveName == null) {
                    this.archiveName = "EventStore-OSS-Linux";
                }
                if (this.archiveExtension == null) {
                    this.archiveExtension = "tar.gz";
                }
            } else {
                if (this.archiveName == null) {
                    throw new MojoExecutionException("Unknown OS - You must use the 'archive-name' parameter");
                }
                if (this.archiveExtension == null) {
                    throw new MojoExecutionException("Unknown OS - You must use the 'archive-ext' parameter");
                }
            }
            this.downloadUrl = this.baseUrl + this.archiveName + "-v" + this.archiveVersion + "." + this.archiveExtension;
        }
        if (this.eventStoreDir == null) {
            if (this.downloadUrl.endsWith(".zip")) {
                this.eventStoreDir = new File(this.canonicalFile(this.targetDir), FilenameUtils.getBaseName((String)this.downloadUrl));
            } else if (this.downloadUrl.endsWith(".tar.gz")) {
                this.eventStoreDir = new File(this.canonicalFile(this.targetDir), FilenameUtils.getBaseName((String)FilenameUtils.getBaseName((String)this.downloadUrl)));
            } else {
                throw new MojoExecutionException("Cannot handle archive with this extension: " + this.downloadUrl);
            }
        }
    }

    private File canonicalFile(File file) throws MojoExecutionException {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error creating canonical file: " + file, (Exception)ex);
        }
    }

    public final String getDownloadUrl() throws MojoExecutionException {
        if (this.downloadUrl == null) {
            this.init();
        }
        return this.downloadUrl;
    }

    public final void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public final String getBaseUrl() throws MojoExecutionException {
        if (this.baseUrl == null) {
            this.init();
        }
        return this.baseUrl;
    }

    public final void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public final String getArchiveName() throws MojoExecutionException {
        if (this.archiveName == null) {
            this.init();
        }
        return this.archiveName;
    }

    public final void setArchiveName(String archiveName) {
        this.archiveName = archiveName;
    }

    public final String getArchiveVersion() {
        return this.archiveVersion;
    }

    public final void setArchiveVersion(String archiveVersion) {
        this.archiveVersion = archiveVersion;
    }

    public final String getArchiveExtension() throws MojoExecutionException {
        if (this.archiveExtension == null) {
            this.init();
        }
        return this.archiveExtension;
    }

    public final void setArchiveExtension(String archiveExtension) {
        this.archiveExtension = archiveExtension;
    }

    public final File getEventStoreDir() throws MojoExecutionException {
        if (this.eventStoreDir == null) {
            this.init();
        }
        return this.eventStoreDir;
    }

    public final void setEventStoreDir(File eventStoreDir) {
        this.eventStoreDir = eventStoreDir;
    }

    public final File getTargetDir() {
        return this.targetDir;
    }

    public final void setTargetDir(File targetDir) {
        this.targetDir = targetDir;
    }

    protected final void writePid(String pid) throws MojoExecutionException {
        try {
            FileUtils.write((File)this.getPidFile(), (CharSequence)pid);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Couldn't write the PID '" + pid + "' to file: " + this.getPidFile(), (Exception)ex);
        }
    }

    protected final String readPid() throws MojoExecutionException {
        try {
            return FileUtils.readFileToString((File)this.getPidFile());
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Couldn't read the PID from file: " + this.getPidFile(), (Exception)ex);
        }
    }

    protected final void deletePid() throws MojoExecutionException {
        boolean ok = this.getPidFile().delete();
        if (!ok) {
            throw new MojoExecutionException("Couldn't delete the PID file: " + this.getPidFile());
        }
    }

    protected final File getPidFile() {
        return new File(this.getTargetDir(), PID_FILE_NAME);
    }

    protected final List<String> asList(String str) throws MojoExecutionException {
        try {
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            LineNumberReader reader = new LineNumberReader(new StringReader(str));
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            return lines;
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error creating string list", (Exception)ex);
        }
    }

    protected final void logDebug(List<String> messages) {
        if (LOG.isDebugEnabled()) {
            for (String message : messages) {
                LOG.debug(message);
            }
        }
    }

    protected final void logError(List<String> messages) {
        if (LOG.isErrorEnabled()) {
            for (String message : messages) {
                LOG.error(message);
            }
        }
    }

    protected abstract void executeGoal() throws MojoExecutionException;
}

