/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esmp;

import java.util.List;
import org.fuin.esmp.DownloadVersion;

public final class DownloadOS
implements Comparable<DownloadOS> {
    private final String os;
    private final String currentVersion;
    private final List<DownloadVersion> versions;

    public DownloadOS(String os) {
        this(os, null, null);
    }

    public DownloadOS(String os, String currentVersion, List<DownloadVersion> versions) {
        if (os == null) {
            throw new IllegalArgumentException("os == null");
        }
        this.os = os;
        this.currentVersion = currentVersion;
        this.versions = versions;
    }

    public final String getOS() {
        return this.os;
    }

    public final String getCurrentVersion() {
        return this.currentVersion;
    }

    public final List<DownloadVersion> getVersions() {
        return this.versions;
    }

    public final DownloadVersion getLatestVersion() {
        return this.findVersion(this.currentVersion);
    }

    public DownloadVersion findVersion(String number) {
        if (number == null) {
            throw new IllegalArgumentException("number == null");
        }
        if (this.versions == null) {
            return null;
        }
        int idx = this.versions.indexOf(new DownloadVersion(number, "-"));
        if (idx < 0) {
            return null;
        }
        return this.versions.get(idx);
    }

    public final int hashCode() {
        return this.os.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DownloadOS other = (DownloadOS)obj;
        return this.os.equals(other.os);
    }

    @Override
    public final int compareTo(DownloadOS other) {
        return this.os.compareTo(other.os);
    }

    public final String toString() {
        return this.os;
    }
}

