/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esmp;

import java.net.MalformedURLException;
import java.net.URL;

public final class DownloadVersion
implements Comparable<DownloadVersion> {
    private final String version;
    private final String url;

    public DownloadVersion(String version, String url) {
        if (version == null) {
            throw new IllegalArgumentException("version == null");
        }
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        this.version = version;
        this.url = url;
    }

    public final String getVersion() {
        return this.version;
    }

    public final String getUrl() {
        return this.url;
    }

    public final URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Cannot convert URL: " + this.url, ex);
        }
    }

    public final int hashCode() {
        return this.version.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DownloadVersion other = (DownloadVersion)obj;
        return this.version.equals(other.version);
    }

    public final String toString() {
        return this.version;
    }

    @Override
    public final int compareTo(DownloadVersion other) {
        return this.version.compareTo(other.version);
    }
}

