/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esmp;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.io.FileUtils;
import org.fuin.esmp.DownloadOS;
import org.fuin.esmp.DownloadVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Downloads {
    private static final Logger LOG = LoggerFactory.getLogger(Downloads.class);
    private static final String VERSION_URL = "https://geteventstore.com/downloads/downloads.json";
    private static final int TIMEOUT_30_SECONDS = 30000;
    private final File jsonDownloadsFile;
    private final List<DownloadOS> osList;

    public Downloads(File jsonDownloadsFile) throws IOException {
        this.jsonDownloadsFile = jsonDownloadsFile;
        this.osList = new ArrayList<DownloadOS>();
        if (!jsonDownloadsFile.exists()) {
            LOG.info("Download version file: https://geteventstore.com/downloads/downloads.json");
            FileUtils.copyURLToFile((URL)new URL(VERSION_URL), (File)jsonDownloadsFile, (int)30000, (int)30000);
        }
        LOG.info("Local version file: " + jsonDownloadsFile);
    }

    public DownloadOS findOS(String name) {
        if (this.osList == null) {
            return null;
        }
        int idx = this.osList.indexOf(new DownloadOS(name));
        if (idx < 0) {
            return null;
        }
        return this.osList.get(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parse() throws IOException {
        try (FileReader reader = new FileReader(this.jsonDownloadsFile);){
            JsonReader jsonReader = Json.createReader((Reader)reader);
            JsonArray osArray = jsonReader.readArray();
            for (int i = 0; i < osArray.size(); ++i) {
                JsonObject osObj = (JsonObject)osArray.get(i);
                String os = osObj.getString("os");
                String currentVersion = osObj.getString("currentVersion");
                JsonArray downloadsArray = osObj.getJsonArray("downloads");
                ArrayList<DownloadVersion> versions = new ArrayList<DownloadVersion>();
                for (int j = 0; j < downloadsArray.size(); ++j) {
                    JsonObject downloadObj = (JsonObject)downloadsArray.get(j);
                    String version = downloadObj.getString("version");
                    String url = downloadObj.getString("url");
                    versions.add(new DownloadVersion(version, url));
                }
                Collections.sort(versions);
                this.osList.add(new DownloadOS(os, currentVersion, versions));
            }
            Collections.sort(this.osList);
        }
        for (DownloadOS os : this.osList) {
            LOG.info("Latest '" + os + "': " + os.getLatestVersion() + " (Versions: " + os.getVersions().size() + ")");
        }
    }

    public final File getJsonDownloadsFile() {
        return this.jsonDownloadsFile;
    }

    public List<DownloadOS> getOsList() {
        return Collections.unmodifiableList(this.osList);
    }
}

