/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.esmp;

import org.codehaus.plexus.util.StringUtils;

public class FileMode {
    private boolean dircetory = false;
    private boolean setUid = false;
    private boolean setGid = false;
    private boolean stickyBit = false;
    private boolean userRead = false;
    private boolean userWrite = false;
    private boolean userExecute = false;
    private boolean groupRead = false;
    private boolean groupWrite = false;
    private boolean groupExecute = false;
    private boolean otherRead = false;
    private boolean otherWrite = false;
    private boolean otherExecute = false;

    public FileMode(int mode) {
        String smodeBin = StringUtils.leftPad((String)Integer.toBinaryString(mode), (int)16, (String)"0");
        if (mode >= 65536) {
            throw new AssertionError((Object)("Unexpected file mode: " + Integer.toString(mode)));
        }
        String modes = smodeBin.substring(4, 7);
        this.setUid = this.isR(modes);
        this.setGid = this.isW(modes);
        this.stickyBit = this.isX(modes);
        String modeu = smodeBin.substring(7, 10);
        this.userRead = this.isR(modeu);
        this.userWrite = this.isW(modeu);
        this.userExecute = this.isX(modeu);
        String modeg = smodeBin.substring(10, 13);
        this.groupRead = this.isR(modeg);
        this.groupWrite = this.isW(modeg);
        this.groupExecute = this.isX(modeg);
        String modeo = smodeBin.substring(13, 16);
        this.otherRead = this.isR(modeo);
        this.otherWrite = this.isW(modeo);
        this.otherExecute = this.isX(modeo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(9);
        sb.append(this.userRead ? (char)'r' : '-');
        sb.append(this.userWrite ? (char)'w' : '-');
        sb.append(this.userExecute ? (char)'x' : '-');
        sb.append(this.groupRead ? (char)'r' : '-');
        sb.append(this.groupWrite ? (char)'w' : '-');
        sb.append(this.groupExecute ? (char)'x' : '-');
        sb.append(this.otherRead ? (char)'r' : '-');
        sb.append(this.otherWrite ? (char)'w' : '-');
        sb.append(this.otherExecute ? (char)'x' : '-');
        return sb.toString();
    }

    public String toChmodStringBasic() {
        StringBuilder sb = new StringBuilder(3);
        sb.append(Integer.toString(this.toOctal(this.userRead, this.userWrite, this.userExecute)));
        sb.append(Integer.toString(this.toOctal(this.groupRead, this.groupWrite, this.groupExecute)));
        sb.append(Integer.toString(this.toOctal(this.otherRead, this.otherWrite, this.otherExecute)));
        return sb.toString();
    }

    public String toChmodStringFull() {
        StringBuilder sb = new StringBuilder(4);
        sb.append(Integer.toString(this.toOctal(this.setUid, this.setGid, this.stickyBit)));
        sb.append(Integer.toString(this.toOctal(this.userRead, this.userWrite, this.userExecute)));
        sb.append(Integer.toString(this.toOctal(this.groupRead, this.groupWrite, this.groupExecute)));
        sb.append(Integer.toString(this.toOctal(this.otherRead, this.otherWrite, this.otherExecute)));
        return sb.toString();
    }

    private int toOctal(boolean r, boolean w, boolean x) {
        int octal = 0;
        if (r) {
            octal += 4;
        }
        if (w) {
            octal += 2;
        }
        if (x) {
            ++octal;
        }
        return octal;
    }

    private boolean isR(String modePart) {
        return modePart.substring(0, 1).equals("1");
    }

    private boolean isW(String modePart) {
        return modePart.substring(1, 2).equals("1");
    }

    private boolean isX(String modePart) {
        return modePart.substring(2, 3).equals("1");
    }

    public boolean isDircetory() {
        return this.dircetory;
    }

    public boolean isUr() {
        return this.userRead;
    }

    public boolean isUw() {
        return this.userWrite;
    }

    public boolean isUx() {
        return this.userExecute;
    }

    public boolean isGr() {
        return this.groupRead;
    }

    public boolean isGw() {
        return this.groupWrite;
    }

    public boolean isGx() {
        return this.groupExecute;
    }

    public boolean isOr() {
        return this.otherRead;
    }

    public boolean isOw() {
        return this.otherWrite;
    }

    public boolean isOx() {
        return this.otherExecute;
    }
}

