/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ErrorPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private CloseListener closeListener = null;
    private JPanel panelHeader;
    private JLabel labelTitle;
    private JPanel panelFooter;
    private JButton buttonOK;
    private JScrollPane scrollPaneMessage;
    private JTextArea textAreaMessage;

    public ErrorPanel() {
        this.initComponents();
    }

    public void setMessage(final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.textAreaMessage.setText(message);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ErrorPanel.this.textAreaMessage.setText(message);
                }
            });
        }
    }

    public void setCloseListener(CloseListener listener) {
        this.closeListener = listener;
    }

    private void buttonOKActionPerformed() {
        this.closeListener.onClose(this);
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("org.fuin.kickstart4j.messages");
        this.panelHeader = new JPanel();
        this.labelTitle = new JLabel();
        this.panelFooter = new JPanel();
        this.buttonOK = new JButton();
        this.scrollPaneMessage = new JScrollPane();
        this.textAreaMessage = new JTextArea();
        this.setLayout(new BorderLayout());
        this.panelHeader.setLayout(new FlowLayout());
        this.labelTitle.setText(bundle.getString("ErrorPanel.labelTitle.text"));
        this.labelTitle.setFont(this.labelTitle.getFont().deriveFont(this.labelTitle.getFont().getStyle() | 1, (float)this.labelTitle.getFont().getSize() + 3.0f));
        this.panelHeader.add(this.labelTitle);
        this.add((Component)this.panelHeader, "North");
        this.panelFooter.setLayout(new FlowLayout(1, 5, 10));
        this.buttonOK.setText(bundle.getString("ErrorPanel.buttonOK.text"));
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ErrorPanel.this.buttonOKActionPerformed();
            }
        });
        this.panelFooter.add(this.buttonOK);
        this.add((Component)this.panelFooter, "South");
        this.textAreaMessage.setEditable(false);
        this.scrollPaneMessage.setViewportView(this.textAreaMessage);
        this.add((Component)this.scrollPaneMessage, "Center");
    }

    public static interface CloseListener {
        public void onClose(ErrorPanel var1);
    }
}

