/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.net.MalformedURLException;
import java.net.URL;
import org.fuin.utils4j.Utils4J;

public final class RemoteFile {
    private final URL srcFileUrl;
    private final String destPath;
    private final String destFilename;
    private final boolean errorIfNotFound;
    private final String md5Hash;
    private final long length;

    public RemoteFile(String srcFileUrlStr, String destPath, String destFilename, boolean errorIfNotFound) throws MalformedURLException {
        this(new URL(srcFileUrlStr), destPath, destFilename, errorIfNotFound);
    }

    public RemoteFile(URL srcFileUrl, String destPath, String destFilename, boolean errorIfNotFound) {
        this(srcFileUrl, destPath, destFilename, errorIfNotFound, null, 0L);
    }

    public RemoteFile(URL srcFileUrl, String destPath, String destFilename, boolean errorIfNotFound, String md5Hash, long length) {
        Utils4J.checkNotNull((String)"srcFileUrl", (Object)srcFileUrl);
        Utils4J.checkNotNull((String)"destPath", (Object)destPath);
        Utils4J.checkNotNull((String)"destFilename", (Object)destFilename);
        this.srcFileUrl = srcFileUrl;
        this.destPath = destPath;
        this.destFilename = destFilename;
        this.errorIfNotFound = errorIfNotFound;
        this.md5Hash = md5Hash;
        this.length = length;
    }

    public final URL getSrcFileUrl() {
        return this.srcFileUrl;
    }

    public final String getDestPath() {
        return this.destPath;
    }

    public final String getDestSlashPath() {
        return this.destPath;
    }

    public final String getDestFilename() {
        return this.destFilename;
    }

    public final String getMd5Hash() {
        return this.md5Hash;
    }

    public final long getLength() {
        return this.length;
    }

    public final boolean isErrorIfNotFound() {
        return this.errorIfNotFound;
    }
}

