/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.fuin.kickstart4j.Utils;
import org.fuin.utils4j.ToDebugStringCapable;
import org.fuin.utils4j.Utils4J;

public final class SrcDir
implements ToDebugStringCapable {
    private final String path;
    private final String srcPathUrl;

    public SrcDir(String path, String srcPathUrl) {
        this.path = path == null ? "" : path.replace('/', File.separatorChar);
        Utils4J.checkNotNull((String)"srcPathUrl", (Object)srcPathUrl);
        this.srcPathUrl = srcPathUrl;
    }

    public final String getPath() {
        return this.path;
    }

    public final String getSrcPathUrl() {
        return this.srcPathUrl;
    }

    public final URL getSrcFileURL(String filename) {
        Utils4J.checkNotNull((String)"filename", (Object)filename);
        if (this.srcPathUrl == null) {
            return null;
        }
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("filename", filename);
        try {
            return new URL(Utils4J.replaceVars((String)this.srcPathUrl, vars));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final String getCanonicalPathAndFilename(File baseDir, String filename) {
        try {
            File dir = new File(baseDir, this.path);
            File destFile = new File(dir, filename);
            return destFile.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final String getRelativeSlashPathAndFilename(String filename) {
        return this.getSlashPath() + "/" + filename;
    }

    public final String getSlashPath() {
        return this.path.replace(File.separatorChar, '/');
    }

    public final File getDestFile(File baseDir, String filename) {
        String name = this.getCanonicalPathAndFilename(baseDir, filename);
        return new File(name);
    }

    public final String toXML() {
        return "<dir path=\"" + this.getSlashPath() + "\" srcPathUrl=\"" + Utils.escapeXml(this.srcPathUrl) + "\"" + "/>";
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SrcDir other = (SrcDir)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public final String toDebugString() {
        StringBuffer sb = new StringBuffer();
        sb.append("path=" + this.path + ", ");
        sb.append("srcPathUrl=" + this.srcPathUrl);
        return sb.toString();
    }

    public final String toString() {
        return this.getSlashPath();
    }
}

