/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.io.IOException;
import org.fuin.utils4j.Utils4J;

public abstract class AbstractFile {
    private final String filename;
    private final String path;
    private final String md5Hash;

    public AbstractFile(File baseDir, File file) {
        this(Utils4J.getRelativePath((File)baseDir, (File)file.getParentFile()).replace(File.separatorChar, '/'), file.getName(), Utils4J.createHashMD5((File)file));
    }

    public AbstractFile(String path, String filename, String md5Hash) {
        this.path = path == null ? "" : path.replace('/', File.separatorChar);
        if (filename == null) {
            throw new IllegalArgumentException("The argument 'filename' cannot be null!");
        }
        this.filename = filename;
        if (md5Hash == null) {
            throw new IllegalArgumentException("The argument 'md5Hash' cannot be null!");
        }
        this.md5Hash = md5Hash;
    }

    public final String getPath() {
        return this.path;
    }

    public final String getFilename() {
        return this.filename;
    }

    public final String getMd5Hash() {
        return this.md5Hash;
    }

    public final String getCanonicalPathAndFilename(File baseDir) {
        try {
            File dir = new File(baseDir, this.path);
            File destFile = new File(dir, this.filename);
            return destFile.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final String getRelativeSlashPathAndFilename() {
        return this.getSlashPath() + "/" + this.getFilename();
    }

    public final String getSlashPath() {
        return this.path.replace(File.separatorChar, '/');
    }

    public final File getDestFile(File baseDir) {
        String name = this.getCanonicalPathAndFilename(baseDir);
        return new File(name);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractFile other = (AbstractFile)obj;
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

