/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JFrame;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.fuin.kickstart4j.Config;
import org.fuin.kickstart4j.ErrorDialog;
import org.fuin.kickstart4j.Kickstart4JListener;
import org.fuin.utils4j.Utils4J;

public final class ApplicationStarter {
    private final File destDir;
    private final CommandLine commandLine;
    private final JFrame startFrame;
    private final Kickstart4JListener listener;
    private final Config config;
    private volatile boolean failed = false;

    public ApplicationStarter(File destDir, CommandLine commandLine, JFrame startFrame, Kickstart4JListener listener, Config config) {
        Utils4J.checkNotNull((String)"destDir", (Object)destDir);
        Utils4J.checkNotNull((String)"commandLine", (Object)commandLine);
        Utils4J.checkNotNull((String)"listener", (Object)listener);
        Utils4J.checkNotNull((String)"config", (Object)config);
        this.destDir = destDir;
        this.commandLine = commandLine;
        this.startFrame = startFrame;
        this.listener = listener;
        this.config = config;
    }

    public void execute() {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        final ByteArrayOutputStream errStream = new ByteArrayOutputStream();
        DefaultExecutor exec = new DefaultExecutor();
        exec.setWorkingDirectory(this.destDir);
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)outStream, (OutputStream)errStream));
        try {
            exec.execute(this.commandLine, new ExecuteResultHandler(){

                public void onProcessFailed(ExecuteException ex) {
                    ApplicationStarter.this.failed = true;
                    if (ApplicationStarter.this.startFrame != null) {
                        ApplicationStarter.this.startFrame.setVisible(false);
                    }
                    System.out.print(errStream.toString());
                    ErrorDialog.showAndExit(errStream, ex, 1);
                }

                public void onProcessComplete(int exitValue) {
                }
            });
            if (this.startFrame != null) {
                this.startFrameSleep();
                this.startFrame.setVisible(false);
            }
            if (this.failed) {
                return;
            }
            System.out.print(outStream.toString());
            if (this.failed) {
                return;
            }
            if (this.config.isExitAfterExecute()) {
                if (this.failed) {
                    return;
                }
                System.exit(0);
            }
            if (this.failed) {
                return;
            }
            this.listener.startupComplete();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error executing target application!", ex);
        }
    }

    private void startFrameSleep() {
        if (this.config.getStartFrameDelaySeconds() > 0) {
            try {
                Thread.sleep(1000 * this.config.getStartFrameDelaySeconds());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

