/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.kickstart4j;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fuin.kickstart4j.SrcFile;
import org.fuin.utils4j.Utils4J;

public final class UpdateSet {
    private final File destDir;
    private final List newFiles = new ArrayList();
    private final List changedFiles = new ArrayList();
    private final List deletedFiles = new ArrayList();
    private final List unchangedFiles = new ArrayList();
    private final List decompressFiles = new ArrayList();
    private final List classpathJarFiles = new ArrayList();
    private final List mkDirs = new ArrayList();
    private final List orderList = new ArrayList();

    public UpdateSet(List srcFiles, List mkDirs, File destDir, boolean lazyLoading) {
        Utils4J.checkNotNull((String)"srcFiles", (Object)srcFiles);
        Utils4J.checkNotNull((String)"mkDirs", (Object)mkDirs);
        Utils4J.checkNotNull((String)"destDir", (Object)destDir);
        Utils4J.checkValidDir((File)destDir);
        this.destDir = destDir;
        this.mkDirs.addAll(mkDirs);
        for (int i = 0; i < srcFiles.size(); ++i) {
            SrcFile srcFile = (SrcFile)srcFiles.get(i);
            Integer order = new Integer(srcFile.getOrder());
            if (!this.orderList.contains(order)) {
                this.orderList.add(order);
            }
            if (lazyLoading && (!lazyLoading || !srcFile.isLoadAlways() && !srcFile.isAddToClasspath())) continue;
            File dir = new File(destDir, srcFile.getPath());
            File dest = new File(dir, srcFile.getFilename());
            if (dest.exists()) {
                this.handleExistingFile(srcFile, dest);
            } else {
                this.handleNewFile(srcFile);
            }
            if (!srcFile.isAddToClasspath()) continue;
            this.classpathJarFiles.add(srcFile);
        }
        Collections.sort(this.orderList);
    }

    private void handleNewFile(SrcFile srcFile) {
        this.newFiles.add(srcFile);
        if (srcFile.isUnzip()) {
            this.decompressFiles.add(srcFile);
        }
    }

    private void handleExistingFile(SrcFile srcFile, File dest) {
        String destHash = Utils4J.createHashMD5((File)dest);
        if (srcFile.getMd5Hash().equals(destHash)) {
            this.unchangedFiles.add(srcFile);
        } else {
            this.changedFiles.add(srcFile);
            if (srcFile.isUnzip()) {
                this.decompressFiles.add(srcFile);
            }
        }
    }

    public final File getDestDir() {
        return this.destDir;
    }

    public final List getNewFiles() {
        return this.newFiles;
    }

    public final List getNewFiles(int order) {
        ArrayList<SrcFile> list = new ArrayList<SrcFile>();
        for (int i = 0; i < this.newFiles.size(); ++i) {
            SrcFile srcFile = (SrcFile)this.newFiles.get(i);
            if (srcFile.getOrder() != order) continue;
            list.add(srcFile);
        }
        return list;
    }

    public final List getChangedFiles() {
        return this.changedFiles;
    }

    public final List getChangedFiles(int order) {
        ArrayList<SrcFile> list = new ArrayList<SrcFile>();
        for (int i = 0; i < this.changedFiles.size(); ++i) {
            SrcFile srcFile = (SrcFile)this.changedFiles.get(i);
            if (srcFile.getOrder() != order) continue;
            list.add(srcFile);
        }
        return list;
    }

    public final List getDeletedFiles() {
        return this.deletedFiles;
    }

    public final List getDeletedFiles(int order) {
        ArrayList<SrcFile> list = new ArrayList<SrcFile>();
        for (int i = 0; i < this.deletedFiles.size(); ++i) {
            SrcFile srcFile = (SrcFile)this.deletedFiles.get(i);
            if (srcFile.getOrder() != order) continue;
            list.add(srcFile);
        }
        return list;
    }

    public final List getUnchangedFiles() {
        return this.unchangedFiles;
    }

    public final List getUnchangedFiles(int order) {
        ArrayList<SrcFile> list = new ArrayList<SrcFile>();
        for (int i = 0; i < this.unchangedFiles.size(); ++i) {
            SrcFile srcFile = (SrcFile)this.unchangedFiles.get(i);
            if (srcFile.getOrder() != order) continue;
            list.add(srcFile);
        }
        return list;
    }

    public final List getDecompressFiles() {
        return this.decompressFiles;
    }

    public final List getDecompressFiles(int order) {
        ArrayList<SrcFile> list = new ArrayList<SrcFile>();
        for (int i = 0; i < this.decompressFiles.size(); ++i) {
            SrcFile srcFile = (SrcFile)this.decompressFiles.get(i);
            if (srcFile.getOrder() != order) continue;
            list.add(srcFile);
        }
        return list;
    }

    public final List getClasspathJarFiles() {
        return this.classpathJarFiles;
    }

    public final List getMkDirs() {
        return this.mkDirs;
    }

    public final List getOrderList() {
        return this.orderList;
    }

    public final boolean isUpdateNecessary() {
        return this.newFiles.size() + this.changedFiles.size() + this.deletedFiles.size() > 0;
    }

    public final String createClasspath() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.classpathJarFiles.size(); ++i) {
            SrcFile srcFile = (SrcFile)this.classpathJarFiles.get(i);
            if (i > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append("\"");
            sb.append(srcFile.getRelativeSlashPathAndFilename());
            sb.append("\"");
        }
        return sb.toString();
    }
}

