/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.mjunitrun;

import java.io.File;
import org.kohsuke.args4j.Option;

public final class JUnitAppConfig {
    @Option(name="-name", usage="Sets the unique test name", metaVar="TEST_NAME", required=true)
    private String testName;
    @Option(name="-class", usage="Sets the fully qualified name of the junit test class", metaVar="TEST_CLASS", required=true)
    private String testClass;
    @Option(name="-dir", usage="Sets the directory to write the result to", metaVar="RESULT_DIR", required=true)
    private File dir;

    public JUnitAppConfig() {
    }

    public JUnitAppConfig(String testName, Class<?> testClass, File dir) {
        this.testName = testName;
        this.testClass = testClass.getName();
        this.dir = dir;
    }

    public final String getTestName() {
        return this.testName;
    }

    public final void setTestName(String testName) {
        this.testName = testName;
    }

    public final Class<?> getTestClass() {
        try {
            return Class.forName(this.testClass);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public final void setTestClass(Class<?> testClass) {
        this.testClass = testClass.getName();
    }

    public final File getDir() {
        return this.dir;
    }

    public final void setDir(File dir) {
        this.dir = dir;
    }
}

