/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.mjunitrun;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import org.apache.commons.io.FileUtils;
import org.fuin.ext4logback.LogbackStandalone;
import org.fuin.mjunitrun.JUnitAppConfig;
import org.junit.runner.Computer;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JUnitApp {
    private static final Logger LOG = LoggerFactory.getLogger(JUnitApp.class);
    private static final String STATUS = "status";
    private static final String MESSAGE = "message";
    private static final String TRACE = "trace";
    private static final String DESCRIPTION = "description";

    private static String stackTraceAsString(Exception ex) {
        PrintWriter sw = new PrintWriter(new StringWriter());
        ex.printStackTrace(sw);
        return sw.toString();
    }

    private static void writeResult(JsonObjectBuilder builder, File resultDir, String testName) {
        String json = builder.build().toString();
        File outFile = new File(resultDir, testName + ".json");
        try {
            FileUtils.write((File)outFile, (CharSequence)json, (String)"utf-8");
        }
        catch (IOException ex) {
            LOG.error("Failed to write result to " + outFile);
            ex.printStackTrace(System.err);
        }
    }

    private static void initLogging(String name, File logbackXmlSrc, File resultDir) {
        File logFile = new File(resultDir, name + ".log");
        System.setProperty("log_file_path_and_name", logFile.getPath());
        File logbackConfigTarget = new File(resultDir, "logback.xml");
        System.out.println("LOG FILE: " + logFile);
        if (logbackConfigTarget.exists()) {
            System.out.println("LOG CONFIG ALREADY EXISTS: " + logbackConfigTarget);
        } else {
            try {
                FileUtils.copyFile((File)logbackXmlSrc, (File)logbackConfigTarget);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to copy logback config from " + logbackXmlSrc + " to " + logbackConfigTarget, ex);
            }
            System.out.println("LOG CONFIG CREATED: " + logbackConfigTarget);
        }
        new LogbackStandalone().init(logbackConfigTarget);
    }

    public int execute(JUnitAppConfig config) {
        String appName = "Application " + config.getTestName();
        LOG.info(appName + " started");
        JsonObjectBuilder builder = Json.createObjectBuilder();
        try {
            Computer computer = new Computer();
            JUnitCore jUnitCore = new JUnitCore();
            Result result = jUnitCore.run(computer, new Class[]{config.getTestClass()});
            builder.add(MESSAGE, "Executed: " + result.getRunCount() + ", Passed: " + (result.getRunCount() - result.getFailureCount()) + ", Failed: " + result.getFailureCount());
            if (result.getFailureCount() == 0) {
                builder.add(STATUS, "success");
                JUnitApp.writeResult(builder, config.getDir(), config.getTestName());
                LOG.info(appName + " finished with: SUCCESS");
                return 0;
            }
            builder.add(STATUS, "failure");
            JsonArrayBuilder arr = Json.createArrayBuilder();
            for (Failure failure : result.getFailures()) {
                if (failure.getException() == null) continue;
                JsonObjectBuilder failObj = Json.createObjectBuilder();
                failObj.add(DESCRIPTION, failure.getTestHeader());
                failObj.add(MESSAGE, failure.getMessage());
                failObj.add(TRACE, failure.getTrace());
                arr.add(failObj);
                LOG.warn(failure.getTestHeader(), failure.getException());
            }
            builder.add("failures", arr);
            JUnitApp.writeResult(builder, config.getDir(), config.getTestName());
            LOG.warn(appName + " finished with: FAILURE");
            return 0;
        }
        catch (RuntimeException ex) {
            builder.add(STATUS, "error");
            builder.add(MESSAGE, ex.getMessage());
            builder.add(TRACE, JUnitApp.stackTraceAsString(ex));
            JUnitApp.writeResult(builder, config.getDir(), config.getTestName());
            LOG.error(appName + " finished with: ERROR");
            return 1;
        }
    }

    public static void main(String[] args) {
        JUnitAppConfig config = new JUnitAppConfig();
        CmdLineParser parser = new CmdLineParser((Object)config);
        try {
            parser.parseArgument(args);
            JUnitApp.initLogging(config.getTestName(), config.getLogbackXmlSrc(), config.getDir());
            System.exit(new JUnitApp().execute(config));
        }
        catch (CmdLineException ex) {
            System.err.println(ex.getMessage());
            parser.printUsage((OutputStream)System.err);
            System.exit(2);
        }
    }
}

