/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.smp;

import com.sun.security.auth.module.UnixSystem;
import java.util.Properties;
import org.apache.commons.exec.OS;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

@Mojo(name="read-system-information", defaultPhase=LifecyclePhase.INITIALIZE, requiresProject=true, threadSafe=true)
public final class ReadSystemInformationMojo
extends AbstractMojo {
    private static final Logger LOG = LoggerFactory.getLogger(ReadSystemInformationMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(name="generic-prefix", defaultValue="org.fuin.smp.")
    private String genericPrefix = null;
    @Parameter(name="unix-prefix", defaultValue="org.fuin.smp.unix.")
    private String unixPrefix = null;

    public String getGenericPrefix() {
        return this.genericPrefix;
    }

    public void setGenericPrefix(String genericPrefix) {
        this.genericPrefix = genericPrefix;
    }

    public String getUnixPrefix() {
        return this.unixPrefix;
    }

    public void setUnixPrefix(String unixPrefix) {
        this.unixPrefix = unixPrefix;
    }

    public final void execute() throws MojoExecutionException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        LOG.info("generic-prefix={}", (Object)this.genericPrefix);
        LOG.info("unix-prefix={}", (Object)this.unixPrefix);
        String genericUid = this.genericPrefix + "uid";
        String genericGid = this.genericPrefix + "gid";
        String genericUsername = this.genericPrefix + "username";
        Properties projectProperties = this.project.getProperties();
        if (!OS.isFamilyUnix()) {
            throw new MojoExecutionException("Only Unix Family OS are supported");
        }
        UnixSystem system = new UnixSystem();
        String unixGid = this.unixPrefix + "gid";
        String unixGroups = this.unixPrefix + "groups";
        String unixUid = this.unixPrefix + "uid";
        String unixUsername = this.unixPrefix + "username";
        projectProperties.put(genericUid, "" + system.getUid());
        projectProperties.put(genericGid, "" + system.getGid());
        projectProperties.put(genericUsername, system.getUsername());
        projectProperties.put(unixGid, "" + system.getGid());
        projectProperties.put(unixGroups, this.asString(system.getGroups()));
        projectProperties.put(unixUid, "" + system.getUid());
        projectProperties.put(unixUsername, system.getUsername());
        LOG.info(unixGid + "={}", projectProperties.get(unixGid));
        LOG.info(unixGroups + "={}", projectProperties.get(unixGroups));
        LOG.info(unixUid + "={}", projectProperties.get(unixUid));
        LOG.info(unixUsername + "={}", projectProperties.get(unixUsername));
        LOG.info(genericUid + "={}", projectProperties.get(genericUid));
        LOG.info(genericGid + "={}", projectProperties.get(genericGid));
        LOG.info(genericUsername + "={}", projectProperties.get(genericUsername));
    }

    private String asString(long[] groups) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < groups.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(groups[i]);
        }
        return sb.toString();
    }
}

