/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.dialogs;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.fuin.utils4j.Utils4J;
import org.fuin.utils4swing.common.ScreenCenterPositioner;
import org.fuin.utils4swing.common.Utils4Swing;
import org.fuin.utils4swing.dialogs.CanceledException;
import org.fuin.utils4swing.dialogs.DirectorySelectionPanel;
import org.fuin.utils4swing.dialogs.DirectorySelectorListener;

public class DirectorySelector {
    private JFrame frame = null;
    private DirectorySelectionPanel panel = null;
    private boolean firstTime = true;
    private final String title;
    private final DirectorySelectorListener listener;
    private final String directory;
    private final boolean showIncludeSubdirs;

    public DirectorySelector(String title, String directory, DirectorySelectorListener listener) {
        this(title, directory, false, listener);
    }

    public DirectorySelector(String title, String directory, boolean showIncludeSubdirs, DirectorySelectorListener listener) {
        Utils4J.checkNotNull((String)"title", (Object)title);
        this.title = title;
        Utils4J.checkNotNull((String)"directory", (Object)directory);
        this.directory = directory;
        this.showIncludeSubdirs = showIncludeSubdirs;
        Utils4J.checkNotNull((String)"listener", (Object)listener);
        this.listener = listener;
    }

    public final void show() {
        if (this.firstTime) {
            this.firstTime = false;
            if (SwingUtilities.isEventDispatchThread()) {
                this.showIntern();
            } else {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            DirectorySelector.this.showIntern();
                        }
                    });
                }
                catch (Exception ex) {
                    DirectorySelector.ignore();
                }
            }
        } else {
            throw new IllegalStateException("This object cannot be reused!");
        }
    }

    private final void showIntern() {
        this.panel = new DirectorySelectionPanel(this);
        this.panel.setTitle(this.title);
        this.panel.setDirectory(this.directory);
        this.panel.setIncludeSubdirsVisible(this.showIncludeSubdirs);
        this.frame = Utils4Swing.createShowAndPosition(this.title, this.panel, false, new ScreenCenterPositioner());
        this.frame.setDefaultCloseOperation(0);
        this.frame.getRootPane().setDefaultButton(this.panel.getButtonOK());
        this.frame.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                DirectorySelector.this.cancel();
            }
        });
    }

    protected final void close() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.closeIntern();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        DirectorySelector.this.closeIntern();
                    }
                });
            }
            catch (Exception ex) {
                DirectorySelector.ignore();
            }
        }
    }

    private final void closeIntern() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.panel = null;
            this.frame = null;
        }
    }

    protected final void cancel() {
        this.close();
        this.listener.canceled();
    }

    protected final void ok() {
        String dir = this.panel.getDirectory();
        boolean include = this.panel.isIncludeSubdirs();
        this.close();
        this.listener.finished(dir, include);
    }

    private static void ignore() {
    }

    public static Result selectDirectory(String title, String directory) throws CanceledException {
        return DirectorySelector.selectDirectory(title, directory, false);
    }

    public static Result selectDirectory(String title, String directory, boolean showIncludeSubdirs) throws CanceledException {
        class MyListener
        implements DirectorySelectorListener {
            private volatile String directory = null;
            private volatile boolean includeSubdirs = false;

            MyListener() {
            }

            public String getDirectory() {
                return this.directory;
            }

            public boolean isIncludeSubdirs() {
                return this.includeSubdirs;
            }

            public void canceled() {
                this.directory = "";
            }

            public void finished(String directory, boolean includeSubdirs) {
                this.directory = directory;
                this.includeSubdirs = includeSubdirs;
            }
        }
        MyListener myListener = new MyListener();
        new DirectorySelector(title, directory, showIncludeSubdirs, myListener).show();
        while (myListener.getDirectory() == null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                DirectorySelector.ignore();
            }
        }
        if (myListener.getDirectory().length() == 0) {
            throw new CanceledException();
        }
        return new Result(myListener.getDirectory(), myListener.isIncludeSubdirs());
    }

    public static void main(String[] args) throws IOException {
        Utils4Swing.initSystemLookAndFeel();
        try {
            Result result = DirectorySelector.selectDirectory("Please select the destination directory:", new File(".").getCanonicalPath(), true);
            System.out.println("SELECTED=" + result.getDirectory() + ", SUBDIRS=" + result.isIncludeSubdirs());
        }
        catch (CanceledException e) {
            System.out.println("CANCELED!");
        }
    }

    public static final class Result {
        private final String directory;
        private final boolean includeSubdirs;

        public Result(String directory, boolean includeSubdirs) {
            Utils4J.checkNotNull((String)"directory", (Object)directory);
            this.directory = directory;
            this.includeSubdirs = includeSubdirs;
        }

        public final String getDirectory() {
            return this.directory;
        }

        public final boolean isIncludeSubdirs() {
            return this.includeSubdirs;
        }
    }
}

