/*
 * Decompiled with CFR 0.152.
 */
package org.fuin.utils4swing.progress;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.fuin.utils4j.Cancelable;
import org.fuin.utils4swing.common.ScreenCenterPositioner;
import org.fuin.utils4swing.common.Utils4Swing;

public class FileCopyProgressPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_TRANSFER_TEXT = "Transferring file $N of $M...";
    private static final String DEFAULT_TITLE = "File Copy Progress";
    private JPanel panelTitle = null;
    private JPanel panelButtons = null;
    private JPanel panelCenter = null;
    private JLabel labelNofM = null;
    private JProgressBar progressBarNofM = null;
    private JLabel labelSpacer = null;
    private JLabel labelDestFile = null;
    private JProgressBar progressBarFile = null;
    private JLabel labelTitle = null;
    private JButton buttonCancel = null;
    private JLabel labelSourceFile = null;
    private String transferText;
    private String currentTransferText = this.transferText = "Transferring file $N of $M...";
    private int currentFile = 0;
    private Cancelable cancelable = null;
    private JLabel labelSource = null;
    private JLabel labelDest = null;

    public FileCopyProgressPanel() {
        this.initialize();
    }

    private void initialize() {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(0);
        borderLayout.setVgap(5);
        this.setLayout(borderLayout);
        this.setSize(600, 320);
        this.setMaximumSize(new Dimension(1600, 400));
        this.setMinimumSize(new Dimension(400, 320));
        this.setPreferredSize(new Dimension(600, 320));
        this.add((Component)this.getTitlePanel(), "North");
        this.add((Component)this.getButtonPanel(), "South");
        this.add((Component)this.getPanelCenter(), "Center");
    }

    private JLabel getLabelTitle() {
        if (this.labelTitle == null) {
            this.labelTitle = new JLabel();
            this.labelTitle.setText(DEFAULT_TITLE);
            this.labelTitle.setFont(new Font("Dialog", 1, 18));
            this.labelTitle.setName("labelTitle");
        }
        return this.labelTitle;
    }

    private JPanel getTitlePanel() {
        if (this.panelTitle == null) {
            FlowLayout flowLayout1 = new FlowLayout();
            flowLayout1.setVgap(10);
            this.panelTitle = new JPanel();
            this.panelTitle.setLayout(flowLayout1);
            this.panelTitle.setPreferredSize(new Dimension(100, 50));
            this.panelTitle.setName("panelTitle");
            this.panelTitle.add((Component)this.getLabelTitle(), null);
        }
        return this.panelTitle;
    }

    private JPanel getButtonPanel() {
        if (this.panelButtons == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(10);
            flowLayout.setVgap(10);
            this.panelButtons = new JPanel();
            this.panelButtons.setLayout(flowLayout);
            this.panelButtons.setPreferredSize(new Dimension(100, 50));
            this.panelButtons.setName("buttonPanel");
            this.panelButtons.add((Component)this.getButtonCancel(), null);
        }
        return this.panelButtons;
    }

    private JLabel getLabelSourceFile() {
        if (this.labelSourceFile == null) {
            this.labelSourceFile = new JLabel();
            this.labelSourceFile.setText("http://www.fuin.org/kickstart4j/jnlp/data/demo.jar");
            this.labelSourceFile.setName("labelSourceFile");
        }
        return this.labelSourceFile;
    }

    private JLabel getLabelDestFile() {
        if (this.labelDestFile == null) {
            this.labelDestFile = new JLabel();
            this.labelDestFile.setText("C:\\Program Files\\Demo Application\\demo.jar");
            this.labelDestFile.setName("labelDestFile");
        }
        return this.labelDestFile;
    }

    private JLabel getLabelSpacer() {
        if (this.labelSpacer == null) {
            this.labelSpacer = new JLabel();
            this.labelSpacer.setText("");
            this.labelSpacer.setName("labelSpacer");
            this.labelSpacer.setPreferredSize(new Dimension(38, 16));
        }
        return this.labelSpacer;
    }

    private JLabel getLabelNofM() {
        if (this.labelNofM == null) {
            this.labelNofM = new JLabel();
            this.labelNofM.setText(this.transferText);
            this.labelNofM.setName("labelNofM");
        }
        return this.labelNofM;
    }

    private JLabel getLabelDest() {
        if (this.labelDest == null) {
            this.labelDest = new JLabel();
            this.labelDest.setText("Destination:");
            this.labelDest.setName("labelDest");
        }
        return this.labelDest;
    }

    private JLabel getLabelSource() {
        if (this.labelSource == null) {
            this.labelSource = new JLabel();
            this.labelSource.setText("Source:");
            this.labelSource.setName("labelSource");
        }
        return this.labelSource;
    }

    private JPanel getPanelCenter() {
        if (this.panelCenter == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(8);
            gridLayout.setHgap(5);
            gridLayout.setVgap(5);
            gridLayout.setColumns(1);
            this.panelCenter = new JPanel();
            this.panelCenter.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.panelCenter.setLayout(gridLayout);
            this.panelCenter.setName("panelCenter");
            this.panelCenter.add((Component)this.getLabelNofM(), null);
            this.panelCenter.add((Component)this.getProgressBarNofM(), null);
            this.panelCenter.add((Component)this.getLabelSpacer(), null);
            this.panelCenter.add((Component)this.getLabelSource(), null);
            this.panelCenter.add((Component)this.getLabelSourceFile(), null);
            this.panelCenter.add((Component)this.getLabelDest(), null);
            this.panelCenter.add((Component)this.getLabelDestFile(), null);
            this.panelCenter.add((Component)this.getProgressBarFile(), null);
        }
        return this.panelCenter;
    }

    private JProgressBar getProgressBarNofM() {
        if (this.progressBarNofM == null) {
            this.progressBarNofM = new JProgressBar();
            this.progressBarNofM.setValue(50);
            this.progressBarNofM.setName("progressBarNofM");
        }
        return this.progressBarNofM;
    }

    private JProgressBar getProgressBarFile() {
        if (this.progressBarFile == null) {
            this.progressBarFile = new JProgressBar();
            this.progressBarFile.setName("progressBarFile");
            this.progressBarFile.setValue(80);
        }
        return this.progressBarFile;
    }

    private JButton getButtonCancel() {
        if (this.buttonCancel == null) {
            this.buttonCancel = new JButton();
            this.buttonCancel.setName("buttonCancel");
            this.buttonCancel.setText("Cancel");
            this.buttonCancel.setMnemonic(67);
            this.buttonCancel.setEnabled(false);
            this.buttonCancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FileCopyProgressPanel.this.getButtonCancel().setEnabled(false);
                    if (FileCopyProgressPanel.this.cancelable != null) {
                        FileCopyProgressPanel.this.cancelable.cancel();
                    }
                }
            });
        }
        return this.buttonCancel;
    }

    private static String replace(String src, String var, String val) {
        if (src == null) {
            return src;
        }
        if (var == null) {
            return src;
        }
        int p = src.indexOf(var);
        if (p > -1) {
            return src.substring(0, p) + val + src.substring(p + var.length());
        }
        return src;
    }

    private void updateTransferText() {
        String text = FileCopyProgressPanel.replace(this.currentTransferText, "$N", "" + this.currentFile);
        this.getLabelNofM().setText(text);
    }

    private void setCurrentFileIntern(int n) {
        this.currentFile = n;
        this.updateTransferText();
        this.getProgressBarNofM().setValue(n);
    }

    private void setMaxFileIntern(int m) {
        this.currentTransferText = FileCopyProgressPanel.replace(this.transferText, "$M", "" + m);
        this.updateTransferText();
        this.getProgressBarNofM().setMaximum(m);
    }

    private void setDestFileIntern(String destFile) {
        this.getLabelDestFile().setText(destFile);
    }

    private void setSourceFileIntern(String sourceFile) {
        this.getLabelSourceFile().setText(sourceFile);
    }

    private void setTitleIntern(String title) {
        if (title == null) {
            this.getLabelTitle().setText(DEFAULT_TITLE);
        } else {
            this.getLabelTitle().setText(title);
        }
    }

    private void setCurrentByteIntern(int n) {
        this.getProgressBarFile().setValue(n);
    }

    private void setMaxByteIntern(int m) {
        this.getProgressBarFile().setMaximum(m);
    }

    private void setTransferTextIntern(String transferText) {
        this.transferText = transferText == null ? DEFAULT_TRANSFER_TEXT : transferText;
        this.currentTransferText = transferText;
    }

    private void updateFileIntern(String sourceFile, String destFile, int currentFile, int maxByte) {
        this.setSourceFileIntern(sourceFile);
        this.setDestFileIntern(destFile);
        this.setCurrentFileIntern(currentFile);
        this.setMaxByteIntern(maxByte);
    }

    private void setCancelableIntern(Cancelable cancelable) {
        this.cancelable = cancelable;
        this.getButtonCancel().setEnabled(cancelable != null);
    }

    private void setDestTextIntern(String text) {
        this.getLabelDest().setText(text);
    }

    private void setSourceTextIntern(String text) {
        this.getLabelSource().setText(text);
    }

    public final void setCurrentFile(final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setCurrentFileIntern(n);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileCopyProgressPanel.this.setCurrentFileIntern(n);
                    }
                });
            }
            catch (Exception ex) {
                FileCopyProgressPanel.ignore();
            }
        }
    }

    public final void setMaxFile(final int m) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setMaxFileIntern(m);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileCopyProgressPanel.this.setMaxFileIntern(m);
                    }
                });
            }
            catch (Exception ex) {
                FileCopyProgressPanel.ignore();
            }
        }
    }

    public final void setDestFile(final String destFile) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setDestFileIntern(destFile);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileCopyProgressPanel.this.setDestFileIntern(destFile);
                    }
                });
            }
            catch (Exception ex) {
                FileCopyProgressPanel.ignore();
            }
        }
    }

    public final void setSourceFile(final String srcFile) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setSourceFileIntern(srcFile);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileCopyProgressPanel.this.setSourceFileIntern(srcFile);
                    }
                });
            }
            catch (Exception ex) {
                FileCopyProgressPanel.ignore();
            }
        }
    }

    public final void setTitle(final String title) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setTitleIntern(title);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileCopyProgressPanel.this.setTitleIntern(title);
                    }
                });
            }
            catch (Exception ex) {
                FileCopyProgressPanel.ignore();
            }
        }
    }

    public final void setCurrentByte(final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setCurrentByteIntern(n);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileCopyProgressPanel.this.setCurrentByteIntern(n);
                    }
                });
            }
            catch (Exception ex) {
                FileCopyProgressPanel.ignore();
            }
        }
    }

    public final void setMaxByte(final int m) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setMaxByteIntern(m);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileCopyProgressPanel.this.setMaxByteIntern(m);
                    }
                });
            }
            catch (Exception ex) {
                FileCopyProgressPanel.ignore();
            }
        }
    }

    public final void setTransferText(final String transferText) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setTransferTextIntern(transferText);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileCopyProgressPanel.this.setTransferTextIntern(transferText);
                    }
                });
            }
            catch (Exception ex) {
                FileCopyProgressPanel.ignore();
            }
        }
    }

    public final void updateFile(final String sourceFile, final String destFile, final int fileNo, final int maxByte) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateFileIntern(sourceFile, destFile, fileNo, maxByte);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileCopyProgressPanel.this.updateFileIntern(sourceFile, destFile, fileNo, maxByte);
                    }
                });
            }
            catch (Exception ex) {
                FileCopyProgressPanel.ignore();
            }
        }
    }

    public final void setCancelable(final Cancelable cancelable) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setCancelableIntern(cancelable);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileCopyProgressPanel.this.setCancelableIntern(cancelable);
                    }
                });
            }
            catch (Exception ex) {
                FileCopyProgressPanel.ignore();
            }
        }
    }

    public final void setDestText(final String text) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setDestTextIntern(text);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileCopyProgressPanel.this.setDestTextIntern(text);
                    }
                });
            }
            catch (Exception ex) {
                FileCopyProgressPanel.ignore();
            }
        }
    }

    public final void setSourceText(final String text) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setSourceTextIntern(text);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FileCopyProgressPanel.this.setSourceTextIntern(text);
                    }
                });
            }
            catch (Exception ex) {
                FileCopyProgressPanel.ignore();
            }
        }
    }

    private static void ignore() {
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Utils4Swing.initSystemLookAndFeel();
                Utils4Swing.createShowAndPosition("Test Progress Dialog", new FileCopyProgressPanel(), true, new ScreenCenterPositioner());
            }
        });
    }
}

