/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.barcode;

import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.lang3.math.NumberUtils;
import org.fujion.annotation.Component;
import org.fujion.component.BaseUIComponent;
import org.springframework.util.StringUtils;

@Component(tag="barcode", widgetModule="fujion-barcode", widgetClass="BarCode", parentTag={"*"}, description="Barcode component.")
public class BarCode
extends BaseUIComponent {
    private static final Function<String, Boolean> PHARMACODE_VALIDATOR = value -> {
        int i = NumberUtils.toInt((String)value);
        return i >= 3 && i <= 131070;
    };
    private Format format = Format.CODE128;
    private boolean displayValue;
    private String value;
    private boolean flat;

    public BarCode() {
    }

    public BarCode(Format format) {
        this.setFormat(format);
    }

    private void validateValue(String value) {
        if (!this.format.validate(value)) {
            throw new IllegalArgumentException(String.format("Value \"%s\" is not valid for the format type \"%s\"", value, this.format.name()));
        }
    }

    @Component.PropertyGetter(value="format", description="The barcode format.")
    public Format getFormat() {
        return this.format;
    }

    @Component.PropertySetter(value="format", defaultValue="code128", description="The barcode format.")
    public void setFormat(Format format) {
        this.format = format = (Format)((Object)this.defaultify((Object)format, (Object)Format.CODE128));
        if (this.propertyChange("format", (Object)this.format, (Object)this.format, true)) {
            this.setValue(null);
        }
    }

    @Component.PropertyGetter(value="displayValue", description="If true, display the value in plain text.")
    public boolean getDisplayValue() {
        return this.displayValue;
    }

    @Component.PropertySetter(value="displayValue", description="If true, display the value in plain text.")
    public void setDisplayValue(boolean displayValue) {
        this.displayValue = displayValue;
        this.propertyChange("displayValue", this.displayValue, this.displayValue, true);
    }

    @Component.PropertyGetter(value="value", description="The value to encode.")
    public String getValue() {
        return this.value;
    }

    @Component.PropertySetter(value="value", defer=true, description="The value to encode.")
    public void setValue(String value) {
        value = this.trimify(value);
        this.validateValue(value);
        this.value = value;
        this.propertyChange("value", this.value, this.value, true);
    }

    @Component.PropertyGetter(value="flat", description="If true, suppresses rendering of guard bars.")
    public boolean isFlat() {
        return this.flat;
    }

    @Component.PropertySetter(value="flat", description="If true, suppresses rendering of guard bars.")
    public void setFlat(boolean flat) {
        this.flat = flat;
        this.propertyChange("flat", this.flat, this.flat, true);
    }

    static /* synthetic */ Function access$000() {
        return PHARMACODE_VALIDATOR;
    }

    public static enum Format {
        CODABAR("^[A-D][0-9\\+$:\\-/.]*[A-D]$"),
        CODE39("^[0-9 a-z A-Z - . $ / + %]*$"),
        CODE128,
        CODE128A,
        CODE128B,
        CODE128C,
        EAN2("^\\d{2}$"),
        EAN5("^\\d{5}$"),
        EAN8("^\\d{7}$"),
        EAN13("^\\d{12}$"),
        ITF("^\\d{14}$"),
        ITF14("^\\d{13}$"),
        MSI("^\\d*$"),
        MSI10("^\\d*$"),
        MSI11("^\\d*$"),
        MSI1010("^\\d*$"),
        MSI1110("^\\d*$"),
        PHARMACODE(BarCode.access$000()),
        QR,
        UPC("^\\d{12}$"),
        UPCE("^\\d{6}$");

        private final Function<String, Boolean> validator;

        private Format() {
            this.validator = null;
        }

        private Format(String regex) {
            Pattern pattern = Pattern.compile(regex);
            this.validator = value -> pattern.matcher((CharSequence)value).matches();
        }

        private Format(Function<String, Boolean> validator) {
            this.validator = validator;
        }

        public boolean validate(String value) {
            return StringUtils.isEmpty((Object)value) || this.validator == null || this.validator.apply(value) != false;
        }
    }
}

