/*
 * #%L
 * fujion
 * %%
 * Copyright (C) 2008 - 2018 Regenstrief Institute, Inc.
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * #L%
 */
package org.fujion.canvas.webgl;

import org.fujion.ancillary.IEnumWithValue;

/**
 * Internal formats for render buffers.
 */
public enum RenderBufferInternalFormat implements IEnumWithValue {
    /**
     * 16 depth bits.
     */
    DEPTH_COMPONENT16(33189),
    /**
     * WebGL 2 only
     */
    DEPTH_COMPONENT24(33190),
    /**
     * WebGL 2 only
     */
    DEPTH_COMPONENT32F(36012),
    /**
     * WebGL 2 only
     */
    DEPTH24_STENCIL8(35056),
    /**
     * WebGL 2 only
     */
    DEPTH32F_STENCIL8(36013),
    /**
     * WebGL 2 only
     */
    R11F_G11F_B10F(35898),
    /**
     * WebGL 2 only
     */
    R16F(33325),
    /**
     * WebGL 2 only
     */
    R16I(33331),
    /**
     * WebGL 2 only
     */
    R16UI(33332),
    /**
     * WebGL 2 only
     */
    R32F(33326),
    /**
     * WebGL 2 only
     */
    R32I(33333),
    /**
     * WebGL 2 only
     */
    R32UI(33334),
    /**
     * WebGL 2 only
     */
    R8(33321),
    /**
     * WebGL 2 only
     */
    R8I(33329),
    /**
     * WebGL 2 only
     */
    R8UI(33330),
    /**
     * WebGL 2 only
     */
    RG16F(33327),
    /**
     * WebGL 2 only
     */
    RG16I(33337),
    /**
     * WebGL 2 only
     */
    RG16UI(33338),
    /**
     * WebGL 2 only
     */
    RG32F(33328),
    /**
     * WebGL 2 only
     */
    RG32I(33339),
    /**
     * WebGL 2 only
     */
    RG32UI(33340),
    /**
     * WebGL 2 only
     */
    RG8(33323),
    /**
     * WebGL 2 only
     */
    RG8I(33335),
    /**
     * WebGL 2 only
     */
    RG8UI(33336),
    /**
     * WebGL 2 only
     */
    RGB10_A2(32857),
    /**
     * WebGL 2 only
     */
    RGB10_A2UI(36975),
    /**
     * 5 red bits, 5 green bits, 5 blue bits, 1 alpha bit.
     */
    RGB5_A1(32855),
    /**
     * 5 red bits, 6 green bits, 5 blue bits.
     */
    RGB565(36194),
    /**
     * WebGL 2 only
     */
    RGB8(32849),
    /**
     * WebGL 2 only
     */
    RGBA16F(34842),
    /**
     * WebGL 2 only
     */
    RGBA16I(36232),
    /**
     * WebGL 2 only
     */
    RGBA16UI(36214),
    /**
     * WebGL 2 only
     */
    RGBA32F(34836),
    /**
     * WebGL 2 only
     */
    RGBA32I(36226),
    /**
     * WebGL 2 only
     */
    RGBA32UI(36208),
    /**
     * 4 red bits, 4 green bits, 4 blue bits 4 alpha bits.
     */
    RGBA4(32854),
    /**
     * WebGL 2 only
     */
    RGBA8(32856),
    /**
     * WebGL 2 only
     */
    RGBA8I(36238),
    /**
     * WebGL 2 only
     */
    RGBA8UI(36220),
    /**
     * WebGL 2 only
     */
    SRGB8_ALPHA8(35907),
    /**
     * 8 stencil bits.
     */
    STENCIL_INDEX8(36168);
    
    private int value;
    
    RenderBufferInternalFormat(int value) {
        this.value = value;
    }
    
    @Override
    public int value() {
        return value;
    }
    
}
