/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.canvas.d2;

import org.fujion.canvas.BaseCanvasComponent;
import org.fujion.canvas.RenderingContextBase;
import org.fujion.canvas.d2.CanvasGradient;
import org.fujion.canvas.d2.CanvasPattern;
import org.fujion.canvas.d2.CompositeOperation;
import org.fujion.canvas.d2.FillRule;
import org.fujion.canvas.d2.LineCap;
import org.fujion.canvas.d2.LineJoin;
import org.fujion.canvas.d2.Repetition;
import org.fujion.canvas.d2.TextAlign;
import org.fujion.canvas.d2.TextBaseline;
import org.fujion.component.Image;
import org.springframework.util.Assert;

public class RenderingContext2D
extends RenderingContextBase {
    private Object fillStyle;
    private String font;
    private double globalAlpha = 1.0;
    private CompositeOperation globalCompositeOperation = CompositeOperation.SOURCE_OVER;
    private LineCap lineCap = LineCap.BUTT;
    private double lineDashOffset;
    private LineJoin lineJoin = LineJoin.MITER;
    private double lineWidth = 1.0;
    private double miterLimit = 10.0;
    private double shadowBlur;
    private String shadowColor;
    private double shadowOffsetX;
    private double shadowOffsetY;
    private Object strokeStyle;
    private TextAlign textAlign = TextAlign.START;
    private TextBaseline textBaseline = TextBaseline.ALPHABETIC;

    public RenderingContext2D(BaseCanvasComponent<?, ?> canvas) {
        super(canvas, "2d");
    }

    private void _setFillStyle(Object fillStyle) {
        this.fillStyle = fillStyle;
        this.config("fillStyle", this.fillStyle);
    }

    private void _setStrokeStyle(Object strokeStyle) {
        this.strokeStyle = strokeStyle;
        this.config("strokeStyle", this.strokeStyle);
    }

    public void arc(double x, double y, double radius, double startAngle, double endAngle) {
        this.arc(x, y, radius, startAngle, endAngle, false);
    }

    public void arc(double x, double y, double radius, double startAngle, double endAngle, boolean anticlockwise) {
        this.invoke("arc", x, y, radius, startAngle, endAngle, anticlockwise);
    }

    public void arcTo(double x1, double y1, double x2, double y2, double radius) {
        this.invoke("arcTo", x1, y1, x2, y2, radius);
    }

    public void beginPath() {
        this.invoke("beginPath", new Object[0]);
    }

    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
        this.invoke("bezierCurveTo", cp1x, cp1y, cp2x, cp2y, x, y);
    }

    public void clearRect(double x, double y, double width, double height) {
        this.invoke("clearRect", x, y, width, height);
    }

    public void clip() {
        this.clip(FillRule.NONZERO);
    }

    public void clip(FillRule fillRule) {
        this.invoke("clip", new Object[]{fillRule});
    }

    public void closePath() {
        this.invoke("closePath", new Object[0]);
    }

    public void createImageData(double height, double width) {
        throw new UnsupportedOperationException("createImageData");
    }

    public CanvasGradient createLinearGradient(double x0, double y0, double x1, double y1) {
        return new CanvasGradient(this.getCanvas(), "createLinearGradient", x0, y0, x1, y1);
    }

    public CanvasPattern createPattern(Image image, Repetition repetition) {
        return new CanvasPattern(this.getCanvas(), image, repetition);
    }

    public CanvasGradient createRadialGradient(double x0, double y0, double r0, double x1, double y1, double r1) {
        return new CanvasGradient(this.getCanvas(), "createRadialGradient", x0, y0, r0, x1, y1, r1);
    }

    public void fill() {
        this.fill(FillRule.NONZERO);
    }

    public void fill(FillRule fillRule) {
        this.invoke("fill", new Object[]{fillRule});
    }

    public void fillRect(double x, double y, double width, double height) {
        this.invoke("fillRect", x, y, width, height);
    }

    public void fillText(String text, double x, double y) {
        this.invoke("fillText", text, x, y);
    }

    public void fillText(String text, double x, double y, Integer maxWidth) {
        this.invoke("fillText", text, x, y, maxWidth);
    }

    public Object getFillStyle() {
        return this.fillStyle;
    }

    public String getFont() {
        return this.font;
    }

    public double getGlobalAlpha() {
        return this.globalAlpha;
    }

    public CompositeOperation getGlobalCompositeOperation() {
        return this.globalCompositeOperation;
    }

    public LineCap getLineCap() {
        return this.lineCap;
    }

    public double getLineDashOffset() {
        return this.lineDashOffset;
    }

    public LineJoin getLineJoin() {
        return this.lineJoin;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public double getMiterLimit() {
        return this.miterLimit;
    }

    public double getShadowBlur() {
        return this.shadowBlur;
    }

    public String getShadowColor() {
        return this.shadowColor;
    }

    public double getShadowOffsetX() {
        return this.shadowOffsetX;
    }

    public double getShadowOffsetY() {
        return this.shadowOffsetY;
    }

    public Object getStrokeStyle() {
        return this.strokeStyle;
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    public TextBaseline getTextBaseline() {
        return this.textBaseline;
    }

    public void lineTo(double x, double y) {
        this.invoke("lineTo", x, y);
    }

    public void moveTo(double x, double y) {
        this.invoke("moveTo", x, y);
    }

    public void quadraticCurveTo(double cpx, double cpy, double x, double y) {
        this.invoke("quadraticCurveTo", cpx, cpy, x, y);
    }

    public void rect(double x, double y, double width, double height) {
        this.invoke("rect", x, y, width, height);
    }

    public void restore() {
        this.invoke("restore", new Object[0]);
    }

    public void rotateDegrees(double angle) {
        this.rotateRadians(angle * Math.PI / 180.0);
    }

    public void rotateRadians(double angle) {
        this.invoke("rotate", angle);
    }

    public void save() {
        this.invoke("save", new Object[0]);
    }

    public void scale(double x, double y) {
        this.invoke("scale", x, y);
    }

    public void setFillStyle(CanvasGradient gradient) {
        this._setFillStyle(gradient);
    }

    public void setFillStyle(CanvasPattern pattern) {
        this._setFillStyle(pattern);
    }

    public void setFillStyle(String color) {
        this._setFillStyle(color);
    }

    public void setFont(String font) {
        this.font = font;
        this.config("font", this.font);
    }

    public void setGlobalAlpha(double globalAlpha) {
        Assert.isTrue((globalAlpha >= 0.0 && globalAlpha <= 1.0 ? 1 : 0) != 0, (String)"globalAlpha must be between 0 and 1, inclusive");
        this.globalAlpha = globalAlpha;
        this.config("globalAlpha", this.globalAlpha);
    }

    public void setGlobalCompositeOperation(CompositeOperation globalCompositeOperation) {
        this.globalCompositeOperation = globalCompositeOperation;
        this.config("globalCompositeOperation", (Object)this.globalCompositeOperation);
    }

    public void setLineCap(LineCap lineCap) {
        this.lineCap = lineCap;
        this.config("lineCap", (Object)this.lineCap);
    }

    public void setLineDash(double[] segments) {
        this.invoke("setLineDash", new Object[]{segments});
    }

    public void setLineDashOffset(double lineDashOffset) {
        this.lineDashOffset = lineDashOffset;
        this.config("lineDashOffset", this.lineDashOffset);
    }

    public void setLineJoin(LineJoin lineJoin) {
        this.lineJoin = lineJoin;
        this.config("lineJoin", (Object)this.lineJoin);
    }

    public void setLineWidth(double lineWidth) {
        Assert.isTrue((lineWidth > 0.0 ? 1 : 0) != 0, (String)"lineWidth must be greater than zero");
        this.lineWidth = lineWidth;
        this.config("lineWidth", this.lineWidth);
    }

    public void setMiterLimit(double miterLimit) {
        Assert.isTrue((miterLimit > 0.0 ? 1 : 0) != 0, (String)"miterLimit must be greater than zero");
        this.miterLimit = miterLimit;
        this.config("miterLimit", this.miterLimit);
    }

    public void setShadowBlur(double shadowBlur) {
        this.shadowBlur = shadowBlur;
        this.config("shadowBlur", this.shadowBlur);
    }

    public void setShadowColor(String shadowColor) {
        this.shadowColor = shadowColor;
        this.config("shadowColor", this.shadowColor);
    }

    public void setShadowOffsetX(double shadowOffsetX) {
        this.shadowOffsetX = shadowOffsetX;
        this.config("shadowOffsetX", this.shadowOffsetX);
    }

    public void setShadowOffsetY(double shadowOffsetY) {
        this.shadowOffsetY = shadowOffsetY;
        this.config("shadowOffsetY", this.shadowOffsetY);
    }

    public void setStrokeStyle(CanvasGradient gradient) {
        this._setStrokeStyle(gradient);
    }

    public void setStrokeStyle(CanvasPattern pattern) {
        this._setStrokeStyle(pattern);
    }

    public void setStrokeStyle(String color) {
        this._setStrokeStyle(color);
    }

    public void setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
        this.config("textAlign", (Object)this.textAlign);
    }

    public void setTextBaseline(TextBaseline textBaseline) {
        this.textBaseline = textBaseline;
        this.config("textBaseline", (Object)this.textBaseline);
    }

    public void setTransform(double a, double b, double c, double d, double dx, double dy) {
        this.invoke("setTransform", a, b, c, d, dx, dy);
    }

    public void stroke() {
        this.invoke("stroke", new Object[0]);
    }

    public void strokeRect(double x, double y, double width, double height) {
        this.invoke("strokeRect", x, y, width, height);
    }

    public void strokeText(String text, double x, double y) {
        this.invoke("strokeText", text, x, y);
    }

    public void strokeText(String text, double x, double y, double maxWidth) {
        this.invoke("strokeText", text, x, y, maxWidth);
    }

    public void transform(double a, double b, double c, double d, double dx, double dy) {
        this.invoke("transform", a, b, c, d, dx, dy);
    }

    public void translate(double x, double y) {
        this.invoke("translate", x, y);
    }
}

