/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.canvas;

import java.util.Collections;
import org.apache.commons.lang.ArrayUtils;
import org.fujion.ancillary.IResponseCallback;
import org.fujion.canvas.BaseCanvasComponent;
import org.fujion.client.IClientTransform;

public abstract class CanvasResource
implements IClientTransform {
    private final BaseCanvasComponent<?, ?> canvas;
    private final int handle;
    private final IResponseCallback<?> callback = response -> this.callback(response);

    protected CanvasResource(BaseCanvasComponent<?, ?> canvas, String factory, Object ... args) {
        this(canvas, false, factory, args);
    }

    protected CanvasResource(BaseCanvasComponent<?, ?> canvas, boolean requestResponse, String factory, Object ... args) {
        this.canvas = canvas;
        this.handle = canvas.nextResourceId();
        this.initResource(requestResponse ? this.callback : null, factory, args);
    }

    protected void callback(Object response) {
    }

    protected void initResource(IResponseCallback<?> callback, String factory, Object ... args) {
        this.init(callback, factory, args);
    }

    protected void init(String function, Object ... args) {
        this.init(null, function, args);
    }

    protected void init(IResponseCallback<?> callback, String function, Object ... args) {
        args = ArrayUtils.add((Object[])args, (int)0, (Object)this.handle);
        this.canvas.invoke(function, callback, args);
    }

    protected void invoke(String function, Object ... args) {
        this.invoke(null, function, args);
    }

    protected void invoke(IResponseCallback<?> callback, String function, Object ... args) {
        this.canvas.invoke("invokeResource", callback, new Object[]{this.handle, function, args});
    }

    protected void config(String property, Object value) {
        this.config(null, property, value);
    }

    protected void config(IResponseCallback<?> callback, String property, Object value) {
        this.canvas.invoke("configResource", callback, new Object[]{this.handle, property, value});
    }

    protected void destroy() {
        this.canvas.invoke("destroyResource", new Object[]{this.handle});
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public BaseCanvasComponent<?, ?> getCanvas() {
        return this.canvas;
    }

    public Object transformForClient() {
        return Collections.singletonMap("__fujion_res__", this.handle);
    }
}

