/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.canvas.webgl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.fujion.ancillary.IEnumWithValue;
import org.fujion.ancillary.IResponseCallback;
import org.fujion.canvas.BaseCanvasComponent;
import org.fujion.canvas.RenderingContextBase;
import org.fujion.canvas.webgl.ArrayBufferBase;
import org.fujion.canvas.webgl.ArrayBufferView;
import org.fujion.canvas.webgl.AttachmentParameterType;
import org.fujion.canvas.webgl.AttachmentPoint;
import org.fujion.canvas.webgl.BlendFactor;
import org.fujion.canvas.webgl.BlendMode;
import org.fujion.canvas.webgl.BufferBinding;
import org.fujion.canvas.webgl.BufferBitMask;
import org.fujion.canvas.webgl.BufferParameterType;
import org.fujion.canvas.webgl.BufferUsagePattern;
import org.fujion.canvas.webgl.Capability;
import org.fujion.canvas.webgl.ColorFormat;
import org.fujion.canvas.webgl.ContextParameterType;
import org.fujion.canvas.webgl.DepthFunction;
import org.fujion.canvas.webgl.DrawMode;
import org.fujion.canvas.webgl.ErrorType;
import org.fujion.canvas.webgl.FaceMode;
import org.fujion.canvas.webgl.FrameBufferBinding;
import org.fujion.canvas.webgl.FrameBufferStatus;
import org.fujion.canvas.webgl.HintBehavior;
import org.fujion.canvas.webgl.HintMode;
import org.fujion.canvas.webgl.PixelDataType;
import org.fujion.canvas.webgl.PixelFormat;
import org.fujion.canvas.webgl.PixelStorageParameter;
import org.fujion.canvas.webgl.PrecisionType;
import org.fujion.canvas.webgl.ProgramParameterType;
import org.fujion.canvas.webgl.RenderBufferBinding;
import org.fujion.canvas.webgl.RenderBufferInternalFormat;
import org.fujion.canvas.webgl.RenderBufferParameterType;
import org.fujion.canvas.webgl.ShaderParameterType;
import org.fujion.canvas.webgl.ShaderType;
import org.fujion.canvas.webgl.StencilFunction;
import org.fujion.canvas.webgl.TextureBufferInternalFormat;
import org.fujion.canvas.webgl.TextureFormat;
import org.fujion.canvas.webgl.TextureParameterType;
import org.fujion.canvas.webgl.TextureType;
import org.fujion.canvas.webgl.TextureType2;
import org.fujion.canvas.webgl.ValueType;
import org.fujion.canvas.webgl.VertexAttributeOffsetType;
import org.fujion.canvas.webgl.VertexAttributeType;
import org.fujion.canvas.webgl.WebGLActiveInfo;
import org.fujion.canvas.webgl.WebGLBuffer;
import org.fujion.canvas.webgl.WebGLFrameBuffer;
import org.fujion.canvas.webgl.WebGLProgram;
import org.fujion.canvas.webgl.WebGLRenderBuffer;
import org.fujion.canvas.webgl.WebGLShader;
import org.fujion.canvas.webgl.WebGLShaderPrecisionFormat;
import org.fujion.canvas.webgl.WebGLTexture;
import org.fujion.canvas.webgl.WebGLUniformLocation;
import org.fujion.canvas.webgl.WindingMode;
import org.springframework.util.Assert;

public class RenderingContextWebGL
extends RenderingContextBase {
    protected RenderingContextWebGL(BaseCanvasComponent<?, ?> canvas) {
        super(canvas, "webgl");
    }

    public void activeTexture(WebGLTexture texture) {
        this.invoke("activeTexture", texture);
    }

    public void attachShader(WebGLProgram program, WebGLShader shader) {
        this.invoke("attachShader", program, shader);
        program.getShaders().add(shader);
    }

    public void bindBuffer(BufferBinding target, WebGLBuffer buffer) {
        this.invoke("bindBuffer", new Object[]{target, buffer});
    }

    public void bindFrameBuffer(FrameBufferBinding target, WebGLFrameBuffer buffer) {
        this.invoke("bindFrameBuffer", new Object[]{target, buffer});
    }

    public void bindRenderBuffer(RenderBufferBinding target, WebGLRenderBuffer buffer) {
        this.invoke("bindRenderBuffer", new Object[]{target, buffer});
    }

    public void bindTexture(TextureType target, WebGLTexture texture) {
        this.invoke("bindTexture", new Object[]{target, texture});
    }

    public void blendEquation(BlendMode blendMode) {
        this.invoke("blendEquation", new Object[]{blendMode});
    }

    public void blendEquationSeparate(BlendMode modeRGB, BlendMode modeAlpha) {
        this.invoke("blendEquationSeparate", new Object[]{modeRGB, modeAlpha});
    }

    public void blendFunc(BlendFactor sfactor, BlendFactor dfactor) {
        this.invoke("blendFunc", new Object[]{sfactor, dfactor});
    }

    public void blendFuncSeparate(BlendFactor srcRGB, BlendFactor dstRGB, BlendFactor srcAlpha, BlendFactor dstAlpha) {
        this.invoke("blendFuncSeparate", new Object[]{srcRGB, dstRGB, srcAlpha, dstAlpha});
    }

    public void blendTexture(double red, double green, double blue, double alpha) {
        this.invoke("blendTexture", red, green, blue, alpha);
    }

    public void bufferData(BufferBinding target, int size, BufferUsagePattern usage) {
        this.invoke("bufferData", new Object[]{target, size, usage});
    }

    public void bufferData(BufferBinding target, ArrayBufferBase srcData, BufferUsagePattern usage) {
        this.invoke("bufferData", new Object[]{target, srcData, usage});
    }

    public void bufferData(BufferBinding target, ArrayBufferBase srcData, BufferUsagePattern usage, int srcOffset, int length) {
        this.invoke("bufferData", new Object[]{target, srcData, usage, srcOffset});
    }

    public void bufferSubData(BufferBinding target, int offset, ArrayBufferBase srcData) {
        this.invoke("bufferSubData", offset, srcData);
    }

    public void bufferSubData(BufferBinding target, int dstByteOffset, ArrayBufferBase srcData, int srcOffset, int length) {
        this.invoke("bufferSubData", new Object[]{target, dstByteOffset, srcData, srcOffset, length});
    }

    public void checkFramebufferStatus(FrameBufferBinding target, IResponseCallback<FrameBufferStatus> callback) {
        this.invoke(response -> IResponseCallback.invoke((IResponseCallback)callback, (Object)IEnumWithValue.fromValue(FrameBufferStatus.class, (int)((Integer)response))), "checkFramebufferStatus", new Object[]{target});
    }

    public void clear(BufferBitMask ... bitmasks) {
        this.invoke("clear", BufferBitMask.combine(bitmasks));
    }

    public void clearColor(double red, double green, double blue, double alpha) {
        this.invoke("clearColor", red, green, blue, alpha);
    }

    public void clearDepth(double depth) {
        this.invoke("clearDepth", depth);
    }

    public void clearStencil(int index) {
        this.invoke("clearStencil", index);
    }

    public void colorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        this.invoke("colorMask", red, green, blue, alpha);
    }

    public void compileShader(WebGLShader shader) {
        this.invoke("compileShader", shader);
    }

    public void copyTexImage2D(TextureType2 target, int level, ColorFormat internalformat, int x, int y, int width, int height) {
        this.invoke("copyTexImage2D", new Object[]{target, level, internalformat, x, y, width, height, 0});
    }

    public void copyTexSubImage2D(TextureType2 target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        this.invoke("copyTexSubImage2D", new Object[]{target, level, xoffset, yoffset, x, y, width, height});
    }

    public ArrayBufferView createArrayBufferView(PixelDataType type, int size) {
        return new ArrayBufferView(this.getCanvas(), type, size);
    }

    public WebGLBuffer createBuffer() {
        return new WebGLBuffer(this.getCanvas());
    }

    public WebGLFrameBuffer createFrameBuffer() {
        return new WebGLFrameBuffer(this.getCanvas());
    }

    public WebGLProgram createProgram() {
        return new WebGLProgram(this.getCanvas());
    }

    public WebGLRenderBuffer createRenderBuffer() {
        return new WebGLRenderBuffer(this.getCanvas());
    }

    public WebGLShader createShader(ShaderType type) {
        return new WebGLShader(this.getCanvas(), type);
    }

    public WebGLTexture createTexture() {
        return new WebGLTexture(this.getCanvas());
    }

    public void cullFace(FaceMode mode) {
        this.invoke("cullFace", new Object[]{mode});
    }

    public void deleteBuffer(WebGLBuffer buffer) {
        this.invoke("deleteBuffer", buffer);
    }

    public void deleteFrameBuffer(WebGLFrameBuffer buffer) {
        this.invoke("deleteFrameBuffer", buffer);
    }

    public void deleteProgram(WebGLProgram program) {
        this.invoke("deleteProgram", program);
    }

    public void deleteRenderBuffer(WebGLRenderBuffer buffer) {
        this.invoke("deleteRenderBuffer", buffer);
    }

    public void deleteShader(WebGLShader shader) {
        this.invoke("deleteShader", shader);
    }

    public void deleteTexture(WebGLTexture texture) {
        this.invoke("deleteTexture", texture);
    }

    public void depthFunc(DepthFunction func) {
        this.invoke("depthFunc", new Object[]{func});
    }

    public void depthMask(boolean flag) {
        this.invoke("depthMask", flag);
    }

    public void depthRange(double zNear, double zFar) {
        this.invoke("depthRange", zNear, zFar);
    }

    public void detachShader(WebGLProgram program, WebGLShader shader) {
        this.invoke("detachShader", program, shader);
        program.getShaders().remove(shader);
    }

    public void disable(Capability cap) {
        this.invoke("disable", new Object[]{cap});
    }

    public void disableVertexAttribArray(int index) {
        this.invoke("disableVertexAttribArray", index);
    }

    public void drawArrays(DrawMode mode, int first, int count) {
        this.invoke("drawArrays", new Object[]{mode, first, count});
    }

    public void drawElements(DrawMode mode, int count, ValueType type, int offset) {
        ValueType.validate(type, ValueType.UNSIGNED_BYTE, ValueType.UNSIGNED_SHORT, ValueType.UNSIGNED_INT);
        this.invoke("drawElements", new Object[]{count, type, offset});
    }

    public void enable(Capability cap) {
        this.invoke("enable", new Object[]{cap});
    }

    public void enableVertexAttribArray(int index) {
        this.invoke("enableVertexAttribArray", index);
    }

    public void finish() {
        this.invoke("finish", new Object[0]);
    }

    public void flush() {
        this.invoke("flush", new Object[0]);
    }

    public void framebufferRenderbuffer(FrameBufferBinding target, AttachmentPoint attachment, RenderBufferBinding renderbuffertarget, WebGLRenderBuffer renderbuffer) {
        this.invoke("framebufferRenderbuffer", new Object[]{target, attachment, renderbuffertarget, renderbuffer});
    }

    public void framebufferTexture2D(FrameBufferBinding target, AttachmentPoint attachment, TextureType2 textarget, WebGLTexture texture) {
        this.invoke("framebufferTexture2D", new Object[]{target, attachment, textarget, texture, 0});
    }

    public void frontFace(WindingMode mode) {
        this.invoke("frontFace", new Object[]{mode});
    }

    public void generateMipmap(TextureType target) {
        this.invoke("generateMipmap", new Object[]{target});
    }

    public void getActiveAttrib(WebGLProgram program, int index, IWebGLInfoCallback callback) {
        new WebGLActiveInfo("getActiveAttrib", program, index, callback);
    }

    public void getActiveUniform(WebGLProgram program, int index, IWebGLInfoCallback callback) {
        new WebGLActiveInfo("getActiveUniform", program, index, callback);
    }

    public Set<WebGLShader> getAttachedShaders(WebGLProgram program) {
        return Collections.unmodifiableSet(program.getShaders());
    }

    public void getAttribLocation(WebGLProgram program, String name, IResponseCallback<Integer> callback) {
        this.invoke(callback, "getAttribLocation", program, name);
    }

    public void getBufferParameter(BufferBinding target, BufferParameterType pname, IResponseCallback<Object> callback) {
        this.invoke(callback, "getBufferParameter", new Object[]{target, pname});
    }

    public void getContextAttributes(IResponseCallback<Map<String, Object>> callback) {
        this.invoke(callback, "getContextAttributes", new Object[0]);
    }

    public void getError(IResponseCallback<ErrorType> callback) {
        this.invoke(response -> IResponseCallback.invoke((IResponseCallback)callback, (Object)IEnumWithValue.fromValue(ErrorType.class, (int)((Integer)response))), "getError", new Object[0]);
    }

    public void getFramebufferAttachmentParameter(FrameBufferBinding target, AttachmentPoint attachment, AttachmentParameterType pname, IResponseCallback<Object> callback) {
        this.invoke(callback, "getFramebufferAttachmentParameter", new Object[]{target, attachment, pname});
    }

    public void getParameter(ContextParameterType pname, IResponseCallback<Object> callback) {
        this.invoke(callback, "getParameter", new Object[]{pname});
    }

    public void getProgramInfoLog(WebGLProgram program, IResponseCallback<String> callback) {
        this.invoke(callback, "getProgramInfoLog", program);
    }

    public void getProgramParameter(WebGLProgram program, ProgramParameterType pname, IResponseCallback<Object> callback) {
        this.invoke(callback, "getProgramParameter", new Object[]{program, pname});
    }

    public void getRenderbufferParameter(RenderBufferBinding target, RenderBufferParameterType pname, IResponseCallback<Object> callback) {
        this.invoke(callback, "getRenderbufferParameter", new Object[]{target, pname});
    }

    public void getShaderInfoLog(WebGLShader shader, IResponseCallback<String> callback) {
        this.invoke(callback, "getShaderInfoLog", shader);
    }

    public void getShaderParameter(WebGLShader shader, ShaderParameterType pname, IResponseCallback<Object> callback) {
        this.invoke(callback, "getShaderParameter", new Object[]{shader, pname});
    }

    public void getShaderPrecisionFormat(ShaderType shaderType, PrecisionType precisionType, IResponseCallback<WebGLShaderPrecisionFormat> callback) {
        new WebGLShaderPrecisionFormat(this.getCanvas(), shaderType, precisionType, callback);
    }

    public void getShaderSource(WebGLShader shader, IResponseCallback<String> callback) {
        this.invoke(callback, "getShaderSource", shader);
    }

    public void getSupportedExtensions(IResponseCallback<String[]> callback) {
        this.invoke(callback, "getSupportedExtensions", new Object[0]);
    }

    public void getTexParameter(TextureType target, TextureParameterType pname, IResponseCallback<Object> callback) {
        this.invoke(callback, "getTexParameter", new Object[]{target, pname});
    }

    public void getUniform(WebGLProgram program, WebGLUniformLocation location, IResponseCallback<Object> callback) {
        this.invoke(callback, "getUniform", program, location);
    }

    public WebGLUniformLocation getUniformLocation(WebGLProgram program, String name) {
        return new WebGLUniformLocation(program, name);
    }

    public void getVertexAttrib(int index, VertexAttributeType pname, IResponseCallback<Object> callback) {
        this.invoke(callback, "getVertexAttrib", new Object[]{index, pname});
    }

    public void getVertexAttribOffset(int index, VertexAttributeOffsetType pname, IResponseCallback<Integer> callback) {
        this.invoke(callback, "getVertexAttribOffset", new Object[]{index, pname});
    }

    public void hint(HintBehavior target, HintMode mode) {
        this.invoke("hint", new Object[]{target, mode});
    }

    public void isBuffer(WebGLBuffer buffer, IResponseCallback<Boolean> callback) {
        this.invoke(callback, "isBuffer", buffer);
    }

    public void isContextLost(IResponseCallback<Boolean> callback) {
        this.invoke(callback, "isContextLost", new Object[0]);
    }

    public void isEnabled(Capability cap, IResponseCallback<Boolean> callback) {
        this.invoke(callback, "isEnabled", new Object[]{cap});
    }

    public void isFramebuffer(WebGLFrameBuffer framebuffer, IResponseCallback<Boolean> callback) {
        this.invoke(callback, "isFramebuffer", framebuffer);
    }

    public void isProgram(WebGLProgram program, IResponseCallback<Boolean> callback) {
        this.invoke(callback, "isProgram", program);
    }

    public void isRenderbuffer(WebGLRenderBuffer renderbuffer, IResponseCallback<Boolean> callback) {
        this.invoke(callback, "isRenderbuffer", renderbuffer);
    }

    public void isShader(WebGLShader shader, IResponseCallback<Boolean> callback) {
        this.invoke(callback, "isShader", shader);
    }

    public void isTexture(WebGLTexture texture, IResponseCallback<Boolean> callback) {
        this.invoke(callback, "isTexture", texture);
    }

    public void linkProgram(WebGLProgram program) {
        this.invoke("linkProgram", program);
    }

    public void pixelStorei(PixelStorageParameter pname, Object value) {
        this.invoke("pixelStorei", new Object[]{pname, value});
    }

    public void polygonOffset(double factor, double units) {
        this.invoke("polygonOffset", factor, units);
    }

    public void readPixels(int x, int y, int width, int height, PixelFormat format, ArrayBufferView pixels) {
        this.invoke("readPixels", new Object[]{x, y, width, height, format, pixels.getType(), pixels});
    }

    public void readPixels(int x, int y, int width, int height, PixelFormat format, ArrayBufferView pixels, int offset) {
        this.invoke("readPixels", new Object[]{x, y, width, height, format, pixels.getType(), pixels, offset});
    }

    public void renderbufferStorage(RenderBufferBinding target, RenderBufferInternalFormat internalFormat, int width, int height) {
        this.invoke("renderbufferStorage", new Object[]{target, internalFormat, width, height});
    }

    public void sampleCoverage(double value, boolean invert) {
        this.invoke("sampleCoverage", value, invert);
    }

    public void scissor(int x, int y, int width, int height) {
        this.invoke("scissor", x, y, width, height);
    }

    public void shaderSource(WebGLShader shader, String source) {
        this.invoke("shaderSource", shader, source);
    }

    public void stencilFunc(DepthFunction func, int ref, int mask) {
        this.invoke("stencilFunc", new Object[]{func, ref, mask});
    }

    public void stencilFuncSeparate(FaceMode face, DepthFunction func, int ref, int mask) {
        this.invoke("stencilFuncSeparate", new Object[]{func, ref, mask});
    }

    public void stencilMask(int mask) {
        this.invoke("stencilMask", mask);
    }

    public void stencilMaskSeparate(FaceMode face, int mask) {
        this.invoke("stencilMaskSeparate", new Object[]{face, mask});
    }

    public void stencilOp(StencilFunction fail, StencilFunction zfail, StencilFunction zpass) {
        this.invoke("stencipOp", new Object[]{fail, zfail, zpass});
    }

    public void stencilOpSeparate(FaceMode face, StencilFunction fail, StencilFunction zfail, StencilFunction zpass) {
        this.invoke("stencipOpSeparate", new Object[]{face, fail, zfail, zpass});
    }

    public void texImage2D(TextureType2 target, int level, TextureBufferInternalFormat internalformat, int width, int height, TextureBufferInternalFormat format, ArrayBufferView pixels) {
        this.invoke("texImage2D", new Object[]{target, level, internalformat, width, height, 0, format, pixels.getType(), pixels});
    }

    public void texParameterf(TextureType target, TextureParameterType pname, double param) {
        this.invoke("texParameterf", new Object[]{target, pname, param});
    }

    public void texParameteri(TextureType target, TextureParameterType pname, int param) {
        this.invoke("texParameteri", new Object[]{target, pname, param});
    }

    public void texSubImage2D(TextureType2 target, int level, int xoffset, int yoffset, int width, int height, TextureFormat format, ArrayBufferView pixels) {
        this.invoke("texSubImage2D", new Object[]{target, level, xoffset, yoffset, width, height, format, pixels});
    }

    public void uniform(WebGLUniformLocation location, Double ... values) {
        int i = values.length;
        Assert.isTrue((i > 0 && i < 5 ? 1 : 0) != 0, () -> "Must specify between 1 and 4 values");
        this.invoke(String.format("uniform%dfv", i), new Object[]{values});
    }

    public void uniform(WebGLUniformLocation location, Integer ... values) {
        int i = values.length;
        Assert.isTrue((i > 0 && i < 5 ? 1 : 0) != 0, () -> "Must specify between 1 and 4 values");
        this.invoke(String.format("uniform%div", i), new Object[]{values});
    }

    public void uniformMatrix(WebGLUniformLocation location, Double ... values) {
        int i = values.length;
        Assert.isTrue((i > 1 && i < 5 ? 1 : 0) != 0, () -> "Must specify between 2 and 4 values");
        this.invoke(String.format("uniformMatrix%dfv", i), false, values);
    }

    public void useProgram(WebGLProgram program) {
        this.invoke("useProgram", program);
    }

    public void validateProgram(WebGLProgram program) {
        this.invoke("validateProgram", program);
    }

    public void vertexAttrib(int index, Double ... values) {
        int i = values.length;
        Assert.isTrue((i > 0 && i < 5 ? 1 : 0) != 0, () -> "Must specify between 1 and 4 values");
        this.invoke(String.format("vertexAttrib%dfv", i), new Object[]{values});
    }

    public void vertexAttribPointer(int index, int size, ValueType type, boolean normalized, int stride, int offset) {
        ValueType.validate(type, ValueType.BYTE, ValueType.SHORT, ValueType.UNSIGNED_BYTE, ValueType.UNSIGNED_SHORT, ValueType.FLOAT, ValueType.HALF_FLOAT);
        this.invoke("vertexAttribPointer", new Object[]{index, size, type, normalized, stride, offset});
    }

    public void viewport(int x, int y, int width, int height) {
        this.invoke("viewport", x, y, width, height);
    }

    public static interface IWebGLInfoCallback
    extends IResponseCallback<WebGLActiveInfo> {
    }
}

