/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.canvas.webgl;

import java.util.HashMap;
import java.util.Map;
import org.fujion.canvas.BaseCanvasComponent;
import org.fujion.canvas.webgl.ArrayBufferBase;
import org.fujion.canvas.webgl.PixelDataType;
import org.springframework.util.Assert;

public class ArrayBuffer
extends ArrayBufferBase {
    private static final Map<Class<?>, PixelDataType> classToType = new HashMap();

    private static PixelDataType typeFromData(Object data) {
        Assert.notNull((Object)data, () -> "Data may not be null");
        Class<?> clazz = data.getClass().getComponentType();
        PixelDataType type = classToType.get(clazz);
        Assert.notNull((Object)((Object)type), () -> "Unsupported numeric data type: " + clazz.getName());
        return type;
    }

    private ArrayBuffer(BaseCanvasComponent<?, ?> canvas, Object data) {
        super(canvas, ArrayBuffer.typeFromData(data), 0, data);
    }

    public ArrayBuffer(BaseCanvasComponent<?, ?> canvas, Number[] data) {
        this(canvas, (Object)data);
    }

    public ArrayBuffer(BaseCanvasComponent<?, ?> canvas, byte[] data) {
        this(canvas, (Object)data);
    }

    public ArrayBuffer(BaseCanvasComponent<?, ?> canvas, int[] data) {
        this(canvas, (Object)data);
    }

    public ArrayBuffer(BaseCanvasComponent<?, ?> canvas, float[] data) {
        this(canvas, (Object)data);
    }

    public ArrayBuffer(BaseCanvasComponent<?, ?> canvas, double[] data) {
        this(canvas, (Object)data);
    }

    static {
        classToType.put(Short.class, PixelDataType.UNSIGNED_SHORT_5_6_5);
        classToType.put(Short.TYPE, PixelDataType.UNSIGNED_SHORT_5_6_5);
        classToType.put(Integer.class, PixelDataType.UNSIGNED_SHORT_5_6_5);
        classToType.put(Integer.TYPE, PixelDataType.UNSIGNED_SHORT_5_6_5);
        classToType.put(Byte.class, PixelDataType.UNSIGNED_BYTE);
        classToType.put(Byte.TYPE, PixelDataType.UNSIGNED_BYTE);
        classToType.put(Float.class, PixelDataType.FLOAT);
        classToType.put(Float.TYPE, PixelDataType.FLOAT);
        classToType.put(Double.class, PixelDataType.FLOAT);
        classToType.put(Double.TYPE, PixelDataType.FLOAT);
    }
}

