/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.codemirror;

import org.fujion.annotation.Component;
import org.fujion.component.BaseInputComponent;

@Component(tag="codemirror", widgetModule="fujion-codemirror", widgetClass="CodeMirror", parentTag={"*"}, description="Fujion wrapper for CodeMirror JavaScript editor.")
public class CodeMirror
extends BaseInputComponent<String> {
    private String mode;
    private boolean lineNumbers;
    private String placeholder;
    private boolean readonly;

    public void format() {
        this.invoke("format", new Object[0]);
    }

    @Component.PropertyGetter(value="readonly", description="True if read-only.")
    public boolean isReadonly() {
        return this.readonly;
    }

    @Component.PropertySetter(value="readonly", defaultValue="false", description="True if read-only.")
    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
        this.propertyChange("readonly", this.readonly, this.readonly, true);
    }

    @Component.PropertyGetter(value="placeholder", description="The placeholder message that is displayed when the editor is empty.")
    public String getPlaceholder() {
        return this.placeholder;
    }

    @Component.PropertySetter(value="placeholder", description="The placeholder message that is displayed when the editor is empty.")
    public void setPlaceholder(String placeholder) {
        this.placeholder = this.nullify(placeholder);
        this.propertyChange("placeholder", this.placeholder, this.placeholder, true);
    }

    @Component.PropertyGetter(value="mode", description="The CodeMirror mode parameter.")
    public String getMode() {
        return this.mode;
    }

    @Component.PropertySetter(value="mode", description="The CodeMirror mode parameter.")
    public void setMode(String mode) {
        this.mode = this.trimify(mode);
        this.propertyChange("mode", this.mode, this.mode, true);
    }

    @Component.PropertyGetter(value="lineNumbers", description="The CodeMirror lineNumbers parameter.")
    public boolean getLineNumbers() {
        return this.lineNumbers;
    }

    @Component.PropertySetter(value="lineNumbers", description="The CodeMirror lineNumbers parameter.")
    public void setLineNumbers(boolean lineNumbers) {
        this.lineNumbers = lineNumbers;
        this.propertyChange("lineNumbers", this.lineNumbers, this.lineNumbers, true);
    }

    protected String _toValue(String value) {
        return value;
    }

    protected String _toString(String value) {
        return value;
    }
}

