/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.codemirror;

import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.fujion.annotation.Component;
import org.fujion.annotation.EventHandler;
import org.fujion.codemirror.CodeMirrorOptions;
import org.fujion.component.BaseComponent;
import org.fujion.component.BaseInputComponent;
import org.fujion.event.EventUtil;

public class CodeMirrorBase<T extends CodeMirrorOptions>
extends BaseInputComponent<String> {
    protected final T options;
    private boolean refreshOptions;

    protected CodeMirrorBase(T options) {
        this.options = options;
        this.setMode(((CodeMirrorOptions)((Object)options)).mode);
    }

    public void format() {
        this.invoke("format", new Object[0]);
    }

    @Component.PropertyGetter(value="readonly", description="True if read-only.")
    public boolean isReadonly() {
        return BooleanUtils.isTrue((Boolean)((CodeMirrorOptions)((Object)this.options)).readonly);
    }

    @Component.PropertySetter(value="readonly", defaultValue="false", description="True if read-only.")
    public void setReadonly(boolean readonly) {
        ((CodeMirrorOptions)((Object)this.options)).readonly = readonly ? Boolean.valueOf(readonly) : null;
        this.propertyChange("readonly", ((CodeMirrorOptions)((Object)this.options)).readonly, ((CodeMirrorOptions)((Object)this.options)).readonly, true);
    }

    @Component.PropertyGetter(value="placeholder", description="The placeholder message that is displayed when the editor is empty.")
    public String getPlaceholder() {
        return ((CodeMirrorOptions)((Object)this.options)).placeholder;
    }

    @Component.PropertySetter(value="placeholder", description="The placeholder message that is displayed when the editor is empty.")
    public void setPlaceholder(String placeholder) {
        ((CodeMirrorOptions)((Object)this.options)).placeholder = this.nullify(placeholder);
        this.propertyChange("placeholder", ((CodeMirrorOptions)((Object)this.options)).placeholder, ((CodeMirrorOptions)((Object)this.options)).placeholder, true);
    }

    protected String getMode() {
        return ((CodeMirrorOptions)((Object)this.options)).mode;
    }

    protected void setMode(String mode) {
        if ((mode = this.trimify(mode)) != null) {
            this.loadModule("codemirror/mode/" + mode + "/" + mode);
        }
        ((CodeMirrorOptions)((Object)this.options)).mode = mode;
        this.refreshOptions();
    }

    @Component.PropertyGetter(value="lineNumbers", description="The CodeMirror lineNumbers parameter.")
    public boolean getLineNumbers() {
        return BooleanUtils.isTrue((Boolean)((CodeMirrorOptions)((Object)this.options)).lineNumbers);
    }

    @Component.PropertySetter(value="lineNumbers", defaultValue="false", description="The CodeMirror lineNumbers parameter.")
    public void setLineNumbers(boolean lineNumbers) {
        ((CodeMirrorOptions)((Object)this.options)).lineNumbers = lineNumbers ? Boolean.valueOf(lineNumbers) : null;
        this.propertyChange("lineNumbers", ((CodeMirrorOptions)((Object)this.options)).lineNumbers, ((CodeMirrorOptions)((Object)this.options)).lineNumbers, true);
    }

    protected void _initProps(Map<String, Object> props) {
        super._initProps(props);
        props.put("wclazz", "fujion_codemirror");
    }

    protected String _toValue(String value) {
        return value;
    }

    protected String _toString(String value) {
        return value;
    }

    public void refreshOptions() {
        if (!this.refreshOptions && this.options != null) {
            this.refreshOptions = true;
            EventUtil.post((String)"refreshOptions", (BaseComponent)this, null);
        }
    }

    @EventHandler(value={"refreshOptions"}, mode={"init"})
    private void onRefreshOptions() {
        this.sync("options", this.options);
        this.refreshOptions = false;
    }

    public T getOptions() {
        return this.options;
    }
}

