/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.codemirror;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.BooleanUtils;
import org.fujion.ancillary.Options;
import org.fujion.annotation.Component;
import org.fujion.annotation.Option;
import org.fujion.codemirror.CodeMirrorBase;
import org.fujion.codemirror.CodeMirrorOptions;

@Component(tag="codemirror_xml", widgetModule="fujion-codemirror-xml", widgetClass="CodeMirrorXML", parentTag={"*"}, description="XML Extensions CodeMirror JavaScript editor.")
public class CodeMirrorXML
extends CodeMirrorBase<XMLOptions> {
    private static final String MATCHING_TAG_COMMAND = "toMatchingTag";
    private boolean autoComplete = true;
    private String jumpShortcut;

    public CodeMirrorXML() {
        super(new XMLOptions());
        this.setJumpShortcut("Alt-J");
    }

    @Component.PropertyGetter(value="autoCloseTags", bindable=false, description="If true, automatically generate closing XML tags.")
    public Boolean getAutoCloseTags() {
        return ((XMLOptions)this.options).autoCloseTags;
    }

    @Component.PropertySetter(value="autoCloseTags", bindable=false, defaultValue="true", description="If true, automatically generate closing XML tags.")
    public void setAutoCloseTags(Boolean autoCloseTags) {
        ((XMLOptions)this.options).autoCloseTags = autoCloseTags;
        if (this.propertyChange("autoCloseTags", ((XMLOptions)this.options).autoCloseTags, ((XMLOptions)this.options).autoCloseTags, false)) {
            this.refreshOptions();
        }
    }

    @Component.PropertyGetter(value="matchTags", bindable=false, description="If true, highlight matching tag.")
    public boolean getMatchTags() {
        return ((XMLOptions)this.options).matchTags;
    }

    @Component.PropertySetter(value="matchTags", bindable=false, defaultValue="true", description="If true, highlight matching tag.")
    public void setMatchTags(boolean matchTags) {
        ((XMLOptions)this.options).matchTags = matchTags;
        if (this.propertyChange("matchTags", ((XMLOptions)this.options).matchTags, ((XMLOptions)this.options).matchTags, false)) {
            this.refreshOptions();
        }
    }

    @Component.PropertyGetter(value="autoComplete", bindable=false, description="If true, autocompletion mode is enabled.")
    public boolean getAutoComplete() {
        return this.autoComplete;
    }

    @Component.PropertySetter(value="autoComplete", bindable=false, defaultValue="true", description="If true, autocompletion mode is enabled.")
    public void setAutoComplete(boolean autoComplete) {
        this.autoComplete = autoComplete;
        this.propertyChange("autoComplete", this.autoComplete, this.autoComplete, true);
    }

    @Component.PropertyGetter(value="htmlMode", bindable=false, description="If true, sets the mode to parse HTML instead of XML. This means attributes do not have to be quoted, and some elements (such as br) do not require a closing tag.")
    public boolean isHtmlMode() {
        return BooleanUtils.isTrue((Boolean)((XMLOptions)this.options).htmlMode);
    }

    @Component.PropertySetter(value="htmlMode", bindable=false, defaultValue="false", description="If true, sets the mode to parse HTML instead of XML. This means attributes do not have to be quoted, and some elements (such as br) do not require a closing tag.")
    public void setHtmlMode(Boolean htmlMode) {
        ((XMLOptions)this.options).htmlMode = htmlMode != false ? htmlMode : null;
        if (this.propertyChange("htmlMode", ((XMLOptions)this.options).htmlMode, ((XMLOptions)this.options).htmlMode, false)) {
            this.refreshOptions();
        }
    }

    @Component.PropertyGetter(value="matchClosing", bindable=false, description="Controls whether the mode checks that close tags match the corresponding opening tag, and highlights mismatches as errors.")
    public boolean getMatchClosing() {
        return !BooleanUtils.isFalse((Boolean)((XMLOptions)this.options).matchClosing);
    }

    @Component.PropertySetter(value="matchClosing", bindable=false, defaultValue="true", description="Controls whether the mode checks that close tags match the corresponding opening tag, and highlights mismatches as errors. ")
    public void setMatchClosing(boolean matchClosing) {
        ((XMLOptions)this.options).matchClosing = matchClosing ? null : Boolean.valueOf(matchClosing);
        if (this.propertyChange("matchClosing", ((XMLOptions)this.options).matchClosing, ((XMLOptions)this.options).matchClosing, false)) {
            this.refreshOptions();
        }
    }

    @Component.PropertyGetter(value="alignCDATA", bindable=false, description="Setting this to true will force the opening tag of CDATA blocks to not be indented.")
    public boolean getAlignCDATA() {
        return BooleanUtils.isTrue((Boolean)((XMLOptions)this.options).alignCDATA);
    }

    @Component.PropertySetter(value="alignCDATA", bindable=false, defaultValue="false", description="Setting this to true will force the opening tag of CDATA blocks to not be indented.")
    public void setAlignCDATA(boolean alignCDATA) {
        ((XMLOptions)this.options).alignCDATA = alignCDATA ? Boolean.valueOf(alignCDATA) : null;
        if (this.propertyChange("alignCDATA", ((XMLOptions)this.options).alignCDATA, ((XMLOptions)this.options).alignCDATA, false)) {
            this.refreshOptions();
        }
    }

    @Component.PropertyGetter(value="jumpShortcut", bindable=false, description="Key combination to jump to matching tag.")
    public String getJumpShortcut() {
        return this.jumpShortcut;
    }

    @Component.PropertySetter(value="jumpShortcut", bindable=false, defaultValue="Alt-J", description="Key combination to jump to matching tag.")
    public void setJumpShortcut(String jumpShortcut) {
        String oldValue = this.jumpShortcut;
        XMLOptions options = (XMLOptions)((Object)this.getOptions());
        this.jumpShortcut = this.trimify(jumpShortcut);
        if (this.propertyChange("jumpShortcut", this.jumpShortcut, this.jumpShortcut, false)) {
            if (oldValue != null && MATCHING_TAG_COMMAND.equals(options.getKeyBinding(oldValue))) {
                options.removeKeyBinding(oldValue);
            }
            if (jumpShortcut != null) {
                options.addKeyBinding(jumpShortcut, MATCHING_TAG_COMMAND);
            }
            this.refreshOptions();
        }
    }

    public void setSchemaInfo(SchemaInfo schemaInfo) {
        ((XMLOptions)this.options).schemaInfo = schemaInfo;
        this.refreshOptions();
    }

    public static class SchemaInfo
    extends Options {
        @Option
        private final Map<String, Tag> schemaInfo = new TreeMap<String, Tag>(String.CASE_INSENSITIVE_ORDER);
        private final Tag root = new Tag();
        @Option(value="schemaInfo.!top")
        private final Set<String> top = Tag.access$000(this.root);
        @Option(value="schemaInfo.!attrs")
        private final Map<String, String[]> attrs = Tag.access$100(this.root);

        public Tag addTag(String tagName) {
            Tag tag = this.getTag(tagName);
            return tag != null ? tag : this.addTag(tagName, new Tag());
        }

        public Tag addTag(String tagName, Tag tag) {
            Tag atag = this.getTag(tagName);
            if (atag == null) {
                this.schemaInfo.put(tagName, tag);
            } else {
                tag = atag.copy(tag);
            }
            return tag;
        }

        public Tag getTag(String tagName) {
            return tagName == null ? this.root : this.schemaInfo.get(tagName);
        }

        public void clear() {
            this.root.clear();
            this.schemaInfo.clear();
        }
    }

    public static class Tag
    extends Options {
        @Option
        private final Map<String, String[]> attrs = new TreeMap<String, String[]>(String.CASE_INSENSITIVE_ORDER);
        @Option
        private final Set<String> children = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);

        public Tag addAttribute(String name, String ... values) {
            Arrays.sort(values);
            this.attrs.put(name, values);
            return this;
        }

        public Tag addChildren(String ... children) {
            this.children.addAll(Arrays.asList(children));
            return this;
        }

        public Tag clear() {
            this.attrs.clear();
            this.children.clear();
            return this;
        }

        public Tag copy(Tag tag) {
            this.clear();
            this.attrs.putAll(tag.attrs);
            this.children.addAll(tag.children);
            return this;
        }

        static /* synthetic */ Set access$000(Tag x0) {
            return x0.children;
        }

        static /* synthetic */ Map access$100(Tag x0) {
            return x0.attrs;
        }
    }

    protected static class XMLOptions
    extends CodeMirrorOptions {
        @Option
        Boolean htmlMode;
        @Option
        Boolean matchClosing;
        @Option
        Boolean alignCDATA;
        @Option
        Boolean autoCloseTags = true;
        @Option(value="matchTags.bothTags")
        Boolean matchTags = true;
        @Option(value="hintOptions")
        SchemaInfo schemaInfo;

        public XMLOptions() {
            super("xml");
        }
    }
}

