/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.UnhandledException;

public class MiscUtil {
    public static boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    public static boolean containsInstance(List<?> list, Object object) {
        return MiscUtil.indexOfInstance(list, object) > -1;
    }

    public static int indexOfInstance(List<?> list, Object object) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != object) continue;
            return i;
        }
        return -1;
    }

    public static <T, S extends T> List<S> castList(List<T> list, Class<S> clazz) {
        return list;
    }

    public static <T, S extends T> Iterator<S> iteratorForType(final Collection<T> collection, final Class<S> type) {
        return new Iterator<S>(){
            Iterator<T> iter;
            S next;
            boolean needsNext;
            {
                this.iter = collection.iterator();
                this.needsNext = true;
            }

            @Override
            public boolean hasNext() {
                return this.nxt() != null;
            }

            @Override
            public S next() {
                Object result = this.nxt();
                this.needsNext = true;
                return result;
            }

            @Override
            public void remove() {
                this.iter.remove();
            }

            private S nxt() {
                if (this.needsNext) {
                    this.next = null;
                    this.needsNext = false;
                    while (this.iter.hasNext()) {
                        Object nxt = this.iter.next();
                        if (!type.isInstance(nxt)) continue;
                        this.next = nxt;
                        break;
                    }
                }
                return this.next;
            }
        };
    }

    public static <T, S extends T> Iterable<S> iterableForType(final Collection<T> collection, final Class<S> type) {
        return new Iterable<S>(){

            @Override
            public Iterator<S> iterator() {
                return MiscUtil.iteratorForType(collection, type);
            }
        };
    }

    public static RuntimeException toUnchecked(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new UnhandledException(e);
    }

    private MiscUtil() {
    }
}

