/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

public class QueryStringBuilder {
    private final StringBuilder sb = new StringBuilder();

    public QueryStringBuilder append(String name, List<?> values) {
        if (values != null) {
            for (Object value : values) {
                this.append(name, value);
            }
        }
        return this;
    }

    public QueryStringBuilder append(String name, Object ... values) {
        if (values != null && values.length > 0) {
            boolean first = true;
            for (Object value : values) {
                if (value == null) continue;
                if (first) {
                    first = false;
                    if (this.sb.length() > 0) {
                        this.sb.append('&');
                    }
                    this.sb.append(this.encode(name)).append('=');
                } else {
                    this.sb.append(',');
                }
                this.sb.append(this.encode(value));
            }
        }
        return this;
    }

    private String encode(Object value) {
        try {
            return URLEncoder.encode(value.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public int length() {
        return this.sb.length();
    }

    public void clear() {
        this.sb.delete(0, this.sb.length());
    }

    public String toString() {
        return this.sb.toString();
    }
}

