/*
 * Decompiled with CFR 0.152.
 */
package org.fujion.common;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;

public abstract class WeakCollectionBase<E> {
    private final transient ReferenceQueue<E> referenceQueue = new ReferenceQueue();

    public void compact() {
        Reference<E> ref = null;
        while ((ref = this.referenceQueue.poll()) != null) {
            this.removeReference(ref);
        }
    }

    protected abstract void removeReference(Reference<? extends E> var1);

    protected Iterator<E> getIterator(Iterable<WeakReference<E>> iterable) {
        this.compact();
        final Iterator<WeakReference<E>> iterator = iterable.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public E next() {
                return WeakCollectionBase.this.getReferent((WeakReference)iterator.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected WeakReference<E> createWeakReference(E element) {
        return new WeakReference<E>(element, this.referenceQueue){

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                Object val1 = this.get();
                if (val1 != null && object instanceof WeakReference) {
                    return this.get().equals(((WeakReference)object).get());
                }
                return false;
            }
        };
    }

    protected boolean contains(Collection<WeakReference<E>> c, Object item) {
        E element = this.cast(item);
        if (element == null) {
            return false;
        }
        this.compact();
        for (WeakReference<E> ref : c) {
            Object ele2 = ref.get();
            if (element != ele2 && !element.equals(ele2)) continue;
            return true;
        }
        return false;
    }

    protected E cast(Object o) {
        try {
            return (E)o;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected E getReferent(WeakReference<E> ref) {
        return ref == null ? null : (E)ref.get();
    }
}

